/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.error.Error;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.swing.ui.tools.FormLayoutBuilder;
import com.jaxfront.swing.ui.visualizers.AbstractPagingView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class PagingView
extends AbstractPagingView
implements TabbableView,
ActionListener {
    public PagingView(ComplexGroup model, Type context) {
        this((Type)model, context);
    }

    public PagingView(SimpleGroup model, Type context) {
        this((Type)model, context);
    }

    public PagingView(Type model, Type context) {
        this._context = context;
        this.setModel(model);
    }

    protected int getTotalPageSize() {
        Vector layoutInfos = this.getStyle().getLayoutInfos();
        return layoutInfos.size();
    }

    public void setApplicationRequired(boolean aBoolean) {
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this._nextButton) {
            this.nextPage();
        } else if (e.getSource() == this._previousButton) {
            this.previousPage();
        }
    }

    protected boolean drawPage() {
        boolean firstDraw = false;
        JPanel holderPanel = new JPanel(new BorderLayout());
        holderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FormLayoutInfo layout = null;
        Vector layoutInfos = this.getStyle().getLayoutInfos();
        layout = (FormLayoutInfo)layoutInfos.get(this._selectedPageIndex);
        JPanel formLayoutPanel = (JPanel)this.getCachedPages().get(layout);
        if (formLayoutPanel == null) {
            formLayoutPanel = FormLayoutBuilder.applyTableLayout(holderPanel, this.getModel(), this._context, layout, null);
            this.getCachedPages().put(layout, formLayoutPanel);
            firstDraw = true;
        }
        holderPanel.add((Component)formLayoutPanel, "Center");
        this._pageContentPanel.removeAll();
        this._pageContentPanel.add((Component)holderPanel, "Center");
        this._pageContentPanel.repaint();
        this.updatePagingNavigationPanel();
        if (this._nextButton != null) {
            if (this._selectedPageIndex == this.getTotalPageSize() - 1) {
                this._nextButton.setEnabled(false);
                this._previousButton.setEnabled(this._selectedPageIndex > 0);
            } else {
                this._nextButton.setEnabled(true);
                this._previousButton.setEnabled(this._selectedPageIndex > 0);
            }
        }
        return firstDraw;
    }

    private void nextPage() {
        if (!this.currentPageHasErrors()) {
            ++this._selectedPageIndex;
            boolean firstDraw = this.drawPage();
            if (firstDraw) {
                this.getModel().getDOM().validate();
            }
        }
    }

    private void previousPage() {
        --this._selectedPageIndex;
        this.drawPage();
    }

    private boolean currentPageHasErrors() {
        Vector<Error> pageErrors = new Vector<Error>();
        this.getDOM().validate();
        FormLayoutInfo layout = (FormLayoutInfo)this.getStyle().getLayoutInfos().get(this._selectedPageIndex);
        if (this.getDOM().getController().getErrorController().hasValidationErrors()) {
            Collection allErrors = this.getDOM().getController().getErrorController().getAllErrors();
            Iterator iterator = allErrors.iterator();
            while (iterator.hasNext()) {
                Error element = (Error)iterator.next();
                if (!layout.contains(element.getErrorHolder())) continue;
                pageErrors.add(element);
            }
        }
        return pageErrors.size() > 0;
    }
}

