/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.swing.ui.wrapper.Selectable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SelectablePanel
extends JPanel
implements Selectable,
ComponentListener {
    boolean _selectable = true;
    String _selectorOrientation = "East";
    JComponent _content = null;
    JCheckBox _selectorComp = null;

    public SelectablePanel(boolean isSelectable, JComponent content) {
        this(isSelectable, "East", content);
    }

    public SelectablePanel(boolean isSelectable, String selectorOrientation, JComponent content) {
        this._selectable = isSelectable;
        this._selectorOrientation = selectorOrientation;
        this._content = content;
        if (this._selectable && content.getComponentCount() > 0) {
            content.getComponent(0).addComponentListener(this);
        }
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        if (this._selectable) {
            this.add((Component)this.getSelectorComponent(), this._selectorOrientation);
            this.add((Component)this._content, "Center");
        } else {
            this.add((Component)this._content, "Center");
        }
    }

    public boolean isSelected() {
        if (this.isSelectable()) {
            return this.getSelectorComponent().isSelected();
        }
        return false;
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public JCheckBox getSelectorComponent() {
        if (this._selectorComp == null) {
            this._selectorComp = new JCheckBox();
            this._selectorComp.setMargin(new Insets(4, 4, 4, 1));
        }
        return this._selectorComp;
    }

    public void select(boolean selected) {
        if (this.isSelectable()) {
            this._selectorComp.setSelected(selected);
        }
    }

    public void componentHidden(ComponentEvent arg0) {
        if (this._selectorComp != null) {
            this._selectorComp.setVisible(false);
        }
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
        if (this._selectorComp != null) {
            this._selectorComp.setVisible(true);
        }
    }
}

