/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.swing.ui.visualizers.SimpleListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class SimpleJList
extends JComponent
implements Scrollable,
Accessible {
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private int horizontalScrollIncrement = -1;
    private Object prototypeCellValue;
    private int visibleRowCount = 8;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean dragEnabled;
    private ListSelectionModel selectionModel;
    private ListModel dataModel;
    private SimpleListCellRenderer cellRenderer;
    private ListSelectionListener selectionListener;
    private int layoutOrientation;

    public SimpleJList(ListModel dataModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.layoutOrientation = 0;
        this.dataModel = dataModel;
        this.selectionModel = this.createSelectionModel();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.updateUI();
    }

    public SimpleJList(final Object[] listData) {
        this(new AbstractListModel(){

            public int getSize() {
                return listData.length;
            }

            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public void revalidate() {
        super.revalidate();
    }

    public void invalidate() {
        super.invalidate();
    }

    public SimpleJList(final Vector listData) {
        this(new AbstractListModel(){

            public int getSize() {
                return listData.size();
            }

            public Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    public SimpleJList() {
        this(new AbstractListModel(){

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int i) {
                return "No Data Model";
            }
        });
    }

    private void updateFixedCellSize() {
        SimpleListCellRenderer cr = this.getCellRenderer();
        Object value = this.getPrototypeCellValue();
        if (cr != null && value != null) {
            Component c = cr.getListCellRendererComponent(this, value, 0, false, false);
            Font f = c.getFont();
            c.setFont(this.getFont());
            Dimension d = c.getPreferredSize();
            this.fixedCellWidth = d.width;
            this.fixedCellHeight = d.height;
            c.setFont(f);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        Object oldValue = this.prototypeCellValue;
        this.prototypeCellValue = prototypeCellValue;
        if (prototypeCellValue != null && !prototypeCellValue.equals(oldValue)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("prototypeCellValue", oldValue, prototypeCellValue);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int width) {
        int oldValue = this.fixedCellWidth;
        this.fixedCellWidth = width;
        this.firePropertyChange("fixedCellWidth", oldValue, this.fixedCellWidth);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int height) {
        int oldValue = this.fixedCellHeight;
        this.fixedCellHeight = height;
        this.firePropertyChange("fixedCellHeight", oldValue, this.fixedCellHeight);
    }

    public SimpleListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(SimpleListCellRenderer cellRenderer) {
        SimpleListCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = cellRenderer;
        if (cellRenderer != null && !cellRenderer.equals(oldValue)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("cellRenderer", oldValue, cellRenderer);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        Color oldValue = this.selectionForeground;
        this.selectionForeground = selectionForeground;
        this.firePropertyChange("selectionForeground", oldValue, selectionForeground);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        Color oldValue = this.selectionBackground;
        this.selectionBackground = selectionBackground;
        this.firePropertyChange("selectionBackground", oldValue, selectionBackground);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        int oldValue = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, visibleRowCount);
        this.firePropertyChange("visibleRowCount", oldValue, visibleRowCount);
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int layoutOrientation) {
        int oldValue = this.layoutOrientation;
        switch (layoutOrientation) {
            case 0: 
            case 1: 
            case 2: {
                this.layoutOrientation = layoutOrientation;
                this.firePropertyChange("layoutOrientation", oldValue, layoutOrientation);
                break;
            }
            default: {
                throw new IllegalArgumentException("layoutOrientation must be one of: VERTICAL, HORIZONTAL_WRAP or VERTICAL_WRAP");
            }
        }
    }

    public int getFirstVisibleIndex() {
        Rectangle bounds;
        Rectangle r = this.getVisibleRect();
        int first = this.getComponentOrientation().isLeftToRight() ? this.locationToIndex(r.getLocation()) : this.locationToIndex(new Point(r.x + r.width - 1, r.y));
        if (first != -1 && (bounds = this.getCellBounds(first, first)) != null) {
            SwingUtilities.computeIntersection(r.x, r.y, r.width, r.height, bounds);
            if (bounds.width == 0 || bounds.height == 0) {
                first = -1;
            }
        }
        return first;
    }

    public int getLastVisibleIndex() {
        Rectangle bounds;
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        Rectangle r = this.getVisibleRect();
        Point lastPoint = leftToRight ? new Point(r.x + r.width - 1, r.y + r.height - 1) : new Point(r.x, r.y + r.height - 1);
        int location = this.locationToIndex(lastPoint);
        if (location != -1 && (bounds = this.getCellBounds(location, location)) != null) {
            SwingUtilities.computeIntersection(r.x, r.y, r.width, r.height, bounds);
            if (bounds.width == 0 || bounds.height == 0) {
                int last;
                Point visibleLL = new Point(r.x, lastPoint.y);
                int llIndex = -1;
                int lrIndex = location;
                location = -1;
                do {
                    last = llIndex;
                    llIndex = this.locationToIndex(visibleLL);
                    if (llIndex == -1) continue;
                    bounds = this.getCellBounds(llIndex, llIndex);
                    if (llIndex != lrIndex && bounds != null && bounds.contains(visibleLL)) {
                        location = llIndex;
                        visibleLL.x = bounds.x + bounds.width + 1;
                        if (visibleLL.x < lastPoint.x) continue;
                        last = llIndex;
                        continue;
                    }
                    last = llIndex;
                } while (llIndex != -1 && last != llIndex);
            }
        }
        return location;
    }

    public void ensureIndexIsVisible(int index) {
        Rectangle cellBounds = this.getCellBounds(index, index);
        if (cellBounds != null) {
            this.scrollRectToVisible(cellBounds);
        }
    }

    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        ListModel model = this.getModel();
        int max = model.getSize();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            String string;
            Object o;
            if ((o = model.getElementAt(index)) == null) continue;
            if (o instanceof String) {
                string = ((String)o).toUpperCase();
            } else {
                string = o.toString();
                if (string != null) {
                    string = string.toUpperCase();
                }
            }
            if (string == null || !string.startsWith(prefix)) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startIndex);
        return -1;
    }

    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Rectangle cellBounds;
            Point p = event.getPoint();
            int index = this.locationToIndex(p);
            SimpleListCellRenderer r = this.getCellRenderer();
            if (index != -1 && r != null && (cellBounds = this.getCellBounds(index, index)) != null && cellBounds.contains(p.x, p.y)) {
                ListSelectionModel lsm = this.getSelectionModel();
                Component rComponent = r.getListCellRendererComponent(this, this.getModel().getElementAt(index), index, lsm.isSelectedIndex(index), this.hasFocus() && lsm.getLeadSelectionIndex() == index);
                if (rComponent instanceof JComponent) {
                    p.translate(-cellBounds.x, -cellBounds.y);
                    MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                    String tip = ((JComponent)rComponent).getToolTipText(newEvent);
                    if (tip != null) {
                        return tip;
                    }
                }
            }
        }
        return super.getToolTipText();
    }

    public int locationToIndex(Point location) {
        return 1;
    }

    public Point indexToLocation(int index) {
        return new Point(0, 0);
    }

    public Rectangle getCellBounds(int index0, int index1) {
        return new Rectangle(20, 20);
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel oldValue = this.dataModel;
        this.dataModel = model;
        this.firePropertyChange("model", oldValue, this.dataModel);
        this.clearSelection();
    }

    public void setListData(final Object[] listData) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return listData.length;
            }

            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public void setListData(final Vector listData) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return listData.size();
            }

            public Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListSelectionListener == null ? SimpleJList.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionHandler();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            selectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        this.firePropertyChange("selectionModel", oldValue, selectionModel);
    }

    public void setSelectionMode(int selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int index) {
        return this.getSelectionModel().isSelectedIndex(index);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.getSelectionModel().setSelectionInterval(anchor, lead);
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.getSelectionModel().addSelectionInterval(anchor, lead);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public void setValueIsAdjusting(boolean b) {
        this.getSelectionModel().setValueIsAdjusting(b);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel sm = this.getSelectionModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!sm.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public void setSelectedIndex(int index) {
        this.getSelectionModel().setSelectionInterval(index, index);
    }

    public void setSelectedIndices(int[] indices) {
        ListSelectionModel sm = this.getSelectionModel();
        sm.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            sm.addSelectionInterval(indices[i], indices[i]);
        }
    }

    public Object[] getSelectedValues() {
        ListSelectionModel sm = this.getSelectionModel();
        ListModel dm = this.getModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new Object[0];
        }
        Object[] rvTmp = new Object[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!sm.isSelectedIndex(i)) continue;
            rvTmp[n++] = dm.getElementAt(i);
        }
        Object[] rv = new Object[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public Object getSelectedValue() {
        int i = this.getMinSelectionIndex();
        return i == -1 ? null : this.getModel().getElementAt(i);
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else if (!anObject.equals(this.getSelectedValue())) {
            ListModel dm = this.getModel();
            int c = dm.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(dm.getElementAt(i))) continue;
                this.setSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    private void checkScrollableParameters(Rectangle visibleRect, int orientation) {
        if (visibleRect == null) {
            throw new IllegalArgumentException("visibleRect must be non-null");
        }
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        int visibleRowCount = this.getVisibleRowCount();
        int fixedCellWidth = this.getFixedCellWidth();
        int fixedCellHeight = this.getFixedCellHeight();
        if (fixedCellWidth > 0 && fixedCellHeight > 0) {
            int width = fixedCellWidth + dx;
            int height = visibleRowCount * fixedCellHeight + dy;
            return new Dimension(width, height);
        }
        if (this.getModel().getSize() > 0) {
            int width = this.getPreferredSize().width;
            Rectangle r = this.getCellBounds(0, 0);
            int height = r != null ? visibleRowCount * r.height + dy : 1;
            return new Dimension(width, height);
        }
        fixedCellWidth = fixedCellWidth > 0 ? fixedCellWidth : 256;
        fixedCellHeight = fixedCellHeight > 0 ? fixedCellHeight : 16;
        return new Dimension(fixedCellWidth, fixedCellHeight * visibleRowCount);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        this.checkScrollableParameters(visibleRect, orientation);
        if (orientation == 0) {
            Font f = this.getFont();
            return f != null ? f.getSize() : 1;
        }
        int row = this.getFirstVisibleIndex();
        if (row == -1) {
            return 0;
        }
        if (direction > 0) {
            Rectangle r = this.getCellBounds(row, row);
            return r == null ? 0 : r.height - (visibleRect.y - r.y);
        }
        Rectangle r = this.getCellBounds(row, row);
        if (r.y == visibleRect.y && row == 0) {
            return 0;
        }
        if (r.y == visibleRect.y) {
            Rectangle prevR = this.getCellBounds(row - 1, row - 1);
            if (prevR.x != r.x) {
                return 0;
            }
            return prevR == null ? 0 : prevR.height;
        }
        return visibleRect.y - r.y;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int index;
        this.checkScrollableParameters(visibleRect, orientation);
        if (orientation == 1) {
            int inc = visibleRect.height;
            if (direction > 0) {
                Rectangle lastRect;
                int last = this.locationToIndex(new Point(visibleRect.x, visibleRect.y + visibleRect.height - 1));
                if (last != -1 && (lastRect = this.getCellBounds(last, last)) != null && (inc = lastRect.y - visibleRect.y) == 0 && last < this.getModel().getSize() - 1) {
                    inc = lastRect.height;
                }
            } else {
                int newFirst = this.locationToIndex(new Point(visibleRect.x, visibleRect.y - visibleRect.height));
                int first = this.getFirstVisibleIndex();
                if (newFirst != -1) {
                    if (first == -1) {
                        first = this.locationToIndex(visibleRect.getLocation());
                    }
                    Rectangle newFirstRect = this.getCellBounds(newFirst, newFirst);
                    Rectangle firstRect = this.getCellBounds(first, first);
                    if (newFirstRect != null && firstRect != null) {
                        while (newFirstRect.y + visibleRect.height < firstRect.y + firstRect.height && newFirstRect.y < firstRect.y) {
                            newFirstRect = this.getCellBounds(++newFirst, newFirst);
                        }
                        inc = visibleRect.y - newFirstRect.y;
                        if (inc <= 0 && newFirstRect.y > 0 && (newFirstRect = this.getCellBounds(--newFirst, newFirst)) != null) {
                            inc = visibleRect.y - newFirstRect.y;
                        }
                    }
                }
            }
            return inc;
        }
        if (orientation == 0 && this.getLayoutOrientation() != 0 && (index = this.getFirstVisibleIndex()) != -1) {
            Rectangle cellBounds = this.getCellBounds(index, index);
            if (visibleRect != null && cellBounds != null) {
                if (cellBounds.x != visibleRect.x) {
                    if (direction < 0) {
                        return Math.abs(cellBounds.x - visibleRect.x);
                    }
                    return cellBounds.width + cellBounds.x - visibleRect.x;
                }
                return cellBounds.width;
            }
        }
        return visibleRect.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected String paramString() {
        String selectionForegroundString = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String selectionBackgroundString = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",fixedCellHeight=" + this.fixedCellHeight + ",fixedCellWidth=" + this.fixedCellWidth + ",horizontalScrollIncrement=" + this.horizontalScrollIncrement + ",selectionBackground=" + selectionBackgroundString + ",selectionForeground=" + selectionForegroundString + ",visibleRowCount=" + this.visibleRowCount + ",layoutOrientation=" + this.layoutOrientation;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJList();
        }
        return this.accessibleContext;
    }

    public static void main(String[] args) {
        Vector<String> data = new Vector<String>();
        data.add("test1");
        data.add("test2");
        data.add("test3");
        SimpleJList list = new SimpleJList(data);
        JFrame f = new JFrame();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)list, "Center");
        p.setVisible(true);
        f.getContentPane().add(p);
        f.setSize(300, 300);
        f.setVisible(true);
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        int leadSelectionIndex;

        public AccessibleJList() {
            super(SimpleJList.this);
            SimpleJList.this.addPropertyChangeListener(this);
            SimpleJList.this.getSelectionModel().addListSelectionListener(this);
            SimpleJList.this.getModel().addListDataListener(this);
            this.leadSelectionIndex = SimpleJList.this.getLeadSelectionIndex();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if (name.compareTo("model") == 0) {
                if (oldValue != null && oldValue instanceof ListModel) {
                    ((ListModel)oldValue).removeListDataListener(this);
                }
                if (newValue != null && newValue instanceof ListModel) {
                    ((ListModel)newValue).addListDataListener(this);
                }
            } else if (name.compareTo("selectionModel") == 0) {
                if (oldValue != null && oldValue instanceof ListSelectionModel) {
                    ((ListSelectionModel)oldValue).removeListSelectionListener(this);
                }
                if (newValue != null && newValue instanceof ListSelectionModel) {
                    ((ListSelectionModel)newValue).addListSelectionListener(this);
                }
                this.firePropertyChange("AccessibleSelection", false, true);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int oldLeadSelectionIndex = this.leadSelectionIndex;
            this.leadSelectionIndex = SimpleJList.this.getLeadSelectionIndex();
            if (oldLeadSelectionIndex != this.leadSelectionIndex) {
                Accessible oldLS = oldLeadSelectionIndex >= 0 ? this.getAccessibleChild(oldLeadSelectionIndex) : null;
                Accessible newLS = this.leadSelectionIndex >= 0 ? this.getAccessibleChild(this.leadSelectionIndex) : null;
                this.firePropertyChange("AccessibleActiveDescendant", oldLS, newLS);
            }
            this.firePropertyChange("AccessibleVisibleData", false, true);
            this.firePropertyChange("AccessibleSelection", false, true);
            AccessibleStateSet s = this.getAccessibleStateSet();
            ListSelectionModel lsm = SimpleJList.this.getSelectionModel();
            if (lsm.getSelectionMode() != 0) {
                if (!s.contains(AccessibleState.MULTISELECTABLE)) {
                    s.add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                }
            } else if (s.contains(AccessibleState.MULTISELECTABLE)) {
                s.remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        public void intervalAdded(ListDataEvent e) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public void intervalRemoved(ListDataEvent e) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public void contentsChanged(ListDataEvent e) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (SimpleJList.this.selectionModel.getSelectionMode() != 0) {
                states.add(AccessibleState.MULTISELECTABLE);
            }
            return states;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point p) {
            int i = SimpleJList.this.locationToIndex(p);
            if (i >= 0) {
                return new AccessibleJListChild(SimpleJList.this, i);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return SimpleJList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int i) {
            if (i >= SimpleJList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJListChild(SimpleJList.this, i);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return SimpleJList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int i) {
            int len = this.getAccessibleSelectionCount();
            if (i < 0 || i >= len) {
                return null;
            }
            return this.getAccessibleChild(SimpleJList.this.getSelectedIndices()[i]);
        }

        public boolean isAccessibleChildSelected(int i) {
            return SimpleJList.this.isSelectedIndex(i);
        }

        public void addAccessibleSelection(int i) {
            SimpleJList.this.addSelectionInterval(i, i);
        }

        public void removeAccessibleSelection(int i) {
            SimpleJList.this.removeSelectionInterval(i, i);
        }

        public void clearAccessibleSelection() {
            SimpleJList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            SimpleJList.this.addSelectionInterval(0, this.getAccessibleChildrenCount() - 1);
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private SimpleJList parent = null;
            private int indexInParent;
            private ListModel listModel;
            private SimpleListCellRenderer cellRenderer = null;

            public AccessibleJListChild(SimpleJList parent, int indexInParent) {
                this.parent = parent;
                this.setAccessibleParent(parent);
                this.indexInParent = indexInParent;
                if (parent != null) {
                    this.listModel = parent.getModel();
                    this.cellRenderer = parent.getCellRenderer();
                }
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component c = this.getComponentAtIndex(this.indexInParent);
                if (c instanceof Accessible) {
                    return ((Accessible)((Object)c)).getAccessibleContext();
                }
                return null;
            }

            private Component getComponentAtIndex(int index) {
                if (index < 0 || index >= this.listModel.getSize()) {
                    return null;
                }
                if (this.parent != null && this.listModel != null && this.cellRenderer != null) {
                    Object value = this.listModel.getElementAt(index);
                    boolean isSelected = this.parent.isSelectedIndex(index);
                    boolean isFocussed = this.parent.isFocusOwner() && index == this.parent.getLeadSelectionIndex();
                    return this.cellRenderer.getListCellRendererComponent(this.parent, value, index, isSelected, isFocussed);
                }
                return null;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleName() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleName();
                }
                return null;
            }

            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return null;
            }

            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                AccessibleStateSet s = ac != null ? ac.getAccessibleStateSet() : new AccessibleStateSet();
                s = ac.getAccessibleStateSet();
                s.add(AccessibleState.SELECTABLE);
                if (this.parent.isFocusOwner() && this.indexInParent == this.parent.getLeadSelectionIndex()) {
                    s.add(AccessibleState.ACTIVE);
                }
                if (this.parent.isSelectedIndex(this.indexInParent)) {
                    s.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    s.add(AccessibleState.SHOWING);
                } else if (s.contains(AccessibleState.SHOWING)) {
                    s.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    s.add(AccessibleState.VISIBLE);
                } else if (s.contains(AccessibleState.VISIBLE)) {
                    s.remove(AccessibleState.VISIBLE);
                }
                s.add(AccessibleState.TRANSIENT);
                return s;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    Accessible accessibleChild = ac.getAccessibleChild(i);
                    ac.setAccessibleParent(this);
                    return accessibleChild;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            public boolean isVisible() {
                int fi = this.parent.getFirstVisibleIndex();
                int li = this.parent.getLastVisibleIndex();
                if (li == -1) {
                    li = this.parent.getModel().getSize() - 1;
                }
                return this.indexInParent >= fi && this.indexInParent <= li;
            }

            public void setVisible(boolean b) {
            }

            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point listLocation = this.parent.getLocationOnScreen();
                    Point componentLocation = this.parent.indexToLocation(this.indexInParent);
                    if (componentLocation != null) {
                        componentLocation.translate(listLocation.x, listLocation.y);
                        return componentLocation;
                    }
                    return null;
                }
                return null;
            }

            public Point getLocation() {
                if (this.parent != null) {
                    return this.parent.indexToLocation(this.indexInParent);
                }
                return null;
            }

            public void setLocation(Point p) {
                if (this.parent != null && this.parent.contains(p)) {
                    SimpleJList.this.ensureIndexIsVisible(this.indexInParent);
                }
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellBounds(this.indexInParent, this.indexInParent);
                }
                return null;
            }

            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                }
            }

            public Dimension getSize() {
                Rectangle cellBounds = this.getBounds();
                if (cellBounds != null) {
                    return cellBounds.getSize();
                }
                return null;
            }

            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        private ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SimpleJList.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
        }
    }
}

