/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJList;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;

public class SimpleTypeListSelectionView
extends AbstractSimpleTypeView
implements ActionListener,
MouseListener {
    private JAXJList _unassignedValuesList;
    private JAXJList _assignedValuesList;
    private JAXJButton _moveFromLeftToRightButton;
    private JAXJButton _moveALLFromLeftToRightButton;
    private JAXJButton _moveFromRightToLeftButton;
    private JAXJButton _moveALLFromRightToLeftButton;
    private JAXJButton _editButton;
    private JAXJButton _okButton;
    private JAXJButton _cancelButton;
    private JPanel _dialogButtonPanel;
    private JPanel _listSelectionView;
    private JTextField _textField;
    private JDialog _dialog;
    private Vector _unassignedValues;
    private Vector _modelValues;
    private Type _originalType;
    private SimpleTypeListCellRenderer _simpleTypeListCellRenderer = null;
    private Object[] _currentCodes;

    public SimpleTypeListSelectionView(Type model) {
        this.setModel(model);
    }

    public SimpleTypeListSelectionView(Type model, Type context) {
        super(context);
        this.setModel(model);
    }

    public void markError() {
        if (this._editorComponent != null) {
            Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
            this._editorComponent.setBorder(border);
        }
    }

    public void populateModel() {
    }

    private SimpleType getEditingType() {
        if (this.getModel() != null) {
            return (SimpleType)((ListType)this.getModel()).getEditingType();
        }
        return null;
    }

    private Vector getModelValues() {
        if (this._modelValues == null && ((ListType)this.getModel()).getList() != null) {
            this._modelValues = (Vector)((ListType)this.getModel()).getList();
        }
        return this._modelValues;
    }

    private void setModelValues(Object[] newValues) {
        if (this.getModelValues() != null) {
            for (int a = 0; a < newValues.length; ++a) {
                String newValue = (String)newValues[a];
                Type newChild = ((ListType)this.getModel()).addNewChild();
                if (newChild == null) continue;
                if (this.getEditingType().getStyle().isUsingCodeSet()) {
                    newValue = this.getCodeForText(newValue);
                }
                if (newValue == null) continue;
                ((SimpleType)newChild).setValue((Object)this, newValue, false);
            }
        }
    }

    private void removeModelValues(Object[] valuesToRemove) {
        if (this.getModelValues() != null) {
            for (int a = 0; a < valuesToRemove.length; ++a) {
                SimpleType valueToRemove = (SimpleType)valuesToRemove[a];
                if (valueToRemove == null) continue;
                this.getDOM().getController().getErrorController().removeValidationError((Type)valueToRemove);
                int noOfItemsBefore = ((ListType)this.getModel()).getList().size();
                try {
                    ((ListType)this.getModel()).removeChild((Type)valueToRemove);
                }
                catch (ListModificationException e) {
                    // empty catch block
                }
                if (noOfItemsBefore != ((ListType)this.getModel()).getList().size()) continue;
                ((ListType)this.getModel()).getList().remove(valueToRemove);
            }
        }
        this.handleItemErrors();
    }

    private Vector getUnassignedValues() {
        if (this._unassignedValues == null) {
            this._unassignedValues = new Vector();
        }
        return this._unassignedValues;
    }

    private String getCodeForText(String text) {
        String codeSet = this.getEditingType().getStyle().getCodeSetName();
        if (codeSet != null && text != null) {
            return this.getDOM().getSchema().getCodeTables().getId(((ListType)this.getModel()).getEditingType(), codeSet, text, this.getDOM().getLanguage());
        }
        return null;
    }

    private String getTextForCode(String code) {
        String codeSet = this.getEditingType().getStyle().getCodeSetName();
        if (codeSet != null && code != null) {
            return this.getDOM().getSchema().getCodeTables().getText(((ListType)this.getModel()).getEditingType(), codeSet, code, this.getDOM().getLanguage());
        }
        return null;
    }

    private void calculateUnassignedValues() {
        if (this.getCurrentCodes() != null && this.getModelValues() != null) {
            this._unassignedValues.clear();
            Object[] curCodes = this.getCurrentCodes();
            for (int a = 0; a < curCodes.length; ++a) {
                boolean hasEqualValue = false;
                String currentObject = (String)curCodes[a];
                if (currentObject != null) {
                    for (int b = 0; b < this.getModelValues().size(); ++b) {
                        SimpleType simpleType = (SimpleType)this.getModelValues().get(b);
                        if (simpleType == null) continue;
                        String currentValue = simpleType.getValue();
                        if (this.getEditingType().getStyle().isUsingCodeSet()) {
                            currentValue = this.getTextForCode(currentValue);
                        }
                        String cObjToComp = currentObject;
                        String cuValToComp = currentValue;
                        if (cObjToComp != null && cObjToComp.length() == 0) {
                            cObjToComp = null;
                        }
                        if (cuValToComp != null && cuValToComp.length() == 0) {
                            cuValToComp = null;
                        }
                        if (cuValToComp != cObjToComp && (cuValToComp == null || !cuValToComp.equals(cObjToComp))) continue;
                        hasEqualValue = true;
                        break;
                    }
                }
                if (currentObject == null || currentObject.length() <= 0 || hasEqualValue) continue;
                this._unassignedValues.add(currentObject);
            }
        }
    }

    private String getTranslatedModelValuesAsTableString() {
        String tableString = "";
        if (this.getModel() != null && this.getModel().isList()) {
            List list = ((ListType)this.getModel()).getList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String code;
                String text;
                Type type = (Type)iterator.next();
                if (type == null || !type.isSimple() || (text = this.getTextForCode(code = ((SimpleType)type).getValue())) == null) continue;
                tableString = tableString + text;
                if (!iterator.hasNext()) continue;
                tableString = tableString + ", ";
            }
        }
        return tableString;
    }

    public void populateView() {
        if (this.getEditingType() != null) {
            if (this._unassignedValuesList != null && this.getUnassignedValues() != null) {
                this.calculateUnassignedValues();
                this._unassignedValuesList.updateUI();
            }
            if (this._assignedValuesList != null && this.getModelValues() != null) {
                this._assignedValuesList.updateUI();
            }
            this.handleItemErrors();
        }
        if (this._textField != null) {
            String text = "";
            text = this.getEditingType().getStyle().isUsingCodeSet() ? this.getTranslatedModelValuesAsTableString() : ((SimpleTypeList)this.getModel()).getDisplayValue();
            this._textField.setText(text);
            this._textField.setToolTipText(text);
            this._textField.setCaretPosition(0);
        }
    }

    private void handleItemErrors() {
        if (this.getModel() != null && this.getModel().isList()) {
            Vector errors;
            boolean hasErrorFound = false;
            List list = ((ListType)this.getModel()).getList();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Vector errors2;
                    Type typeToCheck = (Type)iterator.next();
                    if (typeToCheck == null || (errors2 = this.getDOM().getController().getErrorController().getErrorsForType(typeToCheck)) == null || errors2.size() <= 0) continue;
                    hasErrorFound = true;
                    this.markError();
                    break;
                }
            }
            if (!(hasErrorFound || (errors = this.getDOM().getController().getErrorController().getErrorsForType(this.getModel())) != null && errors.size() > 0)) {
                this.resetError();
            }
        }
    }

    private Object[] getCurrentCodes() {
        if (this._currentCodes == null) {
            if (this.getEditingType() != null) {
                String codesetName;
                if (this.getEditingType().getStyle().isEnumeration()) {
                    this._currentCodes = this.getEditingType().getStyle().getEnumeration();
                } else if (this.getEditingType().getStyle().isUsingCodeSet() && (codesetName = this.getEditingType().getStyle().getCodeSetName()) != null && codesetName.length() > 0) {
                    this._currentCodes = this.getDOM().getSchema().getCodeTables().getItems(true, this.getModel(), codesetName, this.getDOM().getLanguage());
                }
            }
            if (this._currentCodes != null && !this.getEditingType().getStyle().isEnumerationAllowingInvalidCodes()) {
                Vector<String> filteredCodes = new Vector<String>();
                for (int a = 0; a < this._currentCodes.length; ++a) {
                    String currentValue = (String)this._currentCodes[a];
                    if (currentValue == null || CodeTables.isValueInvalid((String)currentValue, (String)this.getDOM().getLanguage())) continue;
                    filteredCodes.add(currentValue);
                }
                this._currentCodes = filteredCodes.toArray();
            }
        }
        return this._currentCodes;
    }

    public void resetError() {
        if (this._editorComponent != null) {
            this._editorComponent.setBorder(null);
        }
    }

    public void setLabelColor(Color color) {
        if (color != null && this.getLabel() != null) {
            this.getLabel().setForeground(color);
        }
    }

    public void setRequired(boolean required) {
        if (this.getEditorField() != null) {
            if (this.getEditingType().getStyle().getBackgroundColor() != null) {
                this.setBackground(this.getStyle().getBackgroundColor());
            } else if (required) {
                if (this.getEditingType().getStyle().isApplicationRequired()) {
                    this.setBackground(this.getDOM().getApplicationFieldColor());
                } else {
                    this.setBackground(this.getDOM().getSchemaRequiredFieldColor());
                }
            } else {
                this.setBackground(this.getDOM().getOptionalFieldColor());
            }
        }
    }

    public void setApplicationRequired(boolean required) {
        this.getEditingType().setApplicationRequired(required);
        if (!required) {
            required = this.getEditingType().isRequired();
        }
        this.setRequired(required);
    }

    public void showLabel(boolean show) {
        if (this.getLabelPanel() != null) {
            this.getLabelPanel().setVisible(show);
        }
    }

    private void cancelDialog() {
        this._dialog.setVisible(false);
        if (this._originalType != null) {
            this.getModel().bind(this._originalType);
        }
        this.populateView();
    }

    private void commitDialog() {
        this._dialog.setVisible(false);
        this._originalType = null;
    }

    private JDialog getDialog() {
        if (this._dialog == null) {
            String dialogTitle;
            boolean allowEditing;
            Window parentWindow = this.getEditor().getWindow();
            this._dialog = GUITools.createDialogFor(parentWindow, true);
            this._dialog.getContentPane().setLayout(new BorderLayout());
            this._dialog.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    SimpleTypeListSelectionView.this.cancelDialog();
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            this._okButton = new JAXJButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_ok", "Ok"));
            this._cancelButton = new JAXJButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_cancel", "Cancel"));
            this._okButton.addActionListener(this);
            this._cancelButton.addActionListener(this);
            this._dialogButtonPanel = new JPanel(new BorderLayout());
            this._dialogButtonPanel.setName("dialogButtonPanel");
            this._dialogButtonPanel.setBorder(BorderFactory.createEtchedBorder());
            String okButtonAlignment = this.getStyle().getTableInfo().getOkButtonAlignment();
            String cancelButtonAlignment = this.getStyle().getTableInfo().getCancelButtonAlignment();
            if (okButtonAlignment.equalsIgnoreCase(cancelButtonAlignment)) {
                JPanel buttonBoxPanel = new JPanel();
                buttonBoxPanel.setName("buttonBoxPanel");
                buttonBoxPanel.setLayout(new BoxLayout(buttonBoxPanel, 0));
                if (this.getStyle().getTableInfo().getOkButtonSeqPos() == 0) {
                    buttonBoxPanel.add(this._okButton);
                    buttonBoxPanel.add(this._cancelButton);
                } else {
                    buttonBoxPanel.add(this._cancelButton);
                    buttonBoxPanel.add(this._okButton);
                }
                if (okButtonAlignment.equalsIgnoreCase("left")) {
                    this._dialogButtonPanel.add((Component)buttonBoxPanel, "West");
                } else if (okButtonAlignment.equalsIgnoreCase("right")) {
                    this._dialogButtonPanel.add((Component)buttonBoxPanel, "East");
                } else {
                    this._dialogButtonPanel.add((Component)buttonBoxPanel, "Center");
                }
            } else if (this.getStyle().getTableInfo().getOkButtonSeqPos() == 0) {
                if (okButtonAlignment.equalsIgnoreCase("left") && cancelButtonAlignment.equalsIgnoreCase("right")) {
                    this._dialogButtonPanel.add((Component)this._okButton, "West");
                    this._dialogButtonPanel.add((Component)this._cancelButton, "East");
                }
            } else if (okButtonAlignment.equalsIgnoreCase("right") && cancelButtonAlignment.equalsIgnoreCase("left")) {
                this._dialogButtonPanel.add((Component)this._cancelButton, "West");
                this._dialogButtonPanel.add((Component)this._okButton, "East");
            }
            this._dialog.getContentPane().add((Component)this.createListSelectionView(true), "Center");
            this._dialog.getContentPane().add((Component)this._dialogButtonPanel, "South");
            TableInfo tableInfo = this.getStyle().getTableInfo();
            if (tableInfo != null) {
                Dimension dialogSize = tableInfo.getDialogSize();
                Point dialogLocation = tableInfo.getDialogLocation();
                if (dialogSize != null && dialogSize.width > -1 && dialogSize.height > -1) {
                    this._dialog.setSize(dialogSize.width, dialogSize.height);
                } else {
                    this._dialog.setSize(600, 247);
                }
                int x = 0;
                int y = 0;
                if (dialogLocation.x == 0 && dialogLocation.y == 0) {
                    Rectangle bounds = parentWindow.getBounds();
                    x = bounds.x + (bounds.width - this._dialog.getSize().width) / 2;
                    y = bounds.y + (bounds.height - this._dialog.getSize().height) / 2;
                } else {
                    Rectangle bounds = parentWindow.getBounds();
                    x = (int)bounds.getX() + dialogLocation.x;
                    y = (int)bounds.getY() + dialogLocation.y;
                }
                this._dialog.setLocation(x, y);
            }
            boolean bl = allowEditing = !this.getEditingType().getStyle().isReadOnly();
            if (this._moveFromLeftToRightButton != null) {
                this._moveFromLeftToRightButton.setEnabled(allowEditing);
            }
            if (this._moveFromRightToLeftButton != null) {
                this._moveFromRightToLeftButton.setEnabled(allowEditing);
            }
            if (this._moveALLFromRightToLeftButton != null) {
                this._moveALLFromRightToLeftButton.setEnabled(allowEditing);
            }
            if (this._moveALLFromLeftToRightButton != null) {
                this._moveALLFromLeftToRightButton.setEnabled(allowEditing);
            }
            if ((dialogTitle = this.getStyle().getDialogLabel()) == null) {
                dialogTitle = this.getLabelText();
            }
            this.getDialog().setTitle(dialogTitle);
            this.populateView();
        }
        return this._dialog;
    }

    private JComponent createListSelectionView(boolean forDialog) {
        if (this._listSelectionView != null) {
            return this._listSelectionView;
        }
        this._listSelectionView = new JPanel();
        this._listSelectionView.setName("listSelectionView");
        this._listSelectionView.setBorder(BorderFactory.createEtchedBorder());
        this._listSelectionView.setFocusable(false);
        String columnSpecInnerPanelConstraints = "50px:g(0.4),10px,50px,10px,50px:g(0.4)";
        String rowSpecInnerPanelConstraints = "93px";
        String columnSpecInnerPanelConstraintsDialog = "100px:g(0.4),10px,50px,10px,100px:g(0.4)";
        String rowSpecInnerPanelConstraintsDialog = "100px:g(100)";
        if (forDialog) {
            String columnSpec = "20px,p:g,20px";
            String rowSpec = "20px,p:g,20px";
            FormLayout tableLayoutOuterPanel = new FormLayout(columnSpec, rowSpec);
            this._listSelectionView.setLayout(tableLayoutOuterPanel);
            columnSpecInnerPanelConstraints = columnSpecInnerPanelConstraintsDialog;
            rowSpecInnerPanelConstraints = rowSpecInnerPanelConstraintsDialog;
        }
        this._simpleTypeListCellRenderer = new SimpleTypeListCellRenderer();
        FormLayout tableLayoutInnerPanel = new FormLayout(columnSpecInnerPanelConstraints, rowSpecInnerPanelConstraints);
        JPanel innerPanel = new JPanel(tableLayoutInnerPanel);
        innerPanel.setName("innerPanel");
        this._unassignedValuesList = new JAXJList();
        this._unassignedValuesList.addFocusListener(this);
        this._unassignedValuesList.addMouseListener(this);
        this._unassignedValuesList.setCellRenderer(this._simpleTypeListCellRenderer);
        if (!forDialog) {
            this.setFirstFocusableComponent(this._unassignedValuesList);
        }
        if (this.getUnassignedValues() != null) {
            this._unassignedValuesList.setListData(this.getUnassignedValues());
        }
        JScrollPane scrollPane1 = new JScrollPane(this._unassignedValuesList);
        scrollPane1.setVerticalScrollBarPolicy(20);
        scrollPane1.setFocusable(false);
        scrollPane1.getViewport().setFocusable(false);
        scrollPane1.getHorizontalScrollBar().setFocusable(false);
        scrollPane1.getVerticalScrollBar().setFocusable(false);
        scrollPane1.setPreferredSize(new Dimension(300, 300));
        JPanel unassignedPanel = new JPanel(new BorderLayout());
        unassignedPanel.setName("unassignedPanel");
        JLabel unassignedLabel = new JLabel(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "label_unassigned", "Unassigned"));
        unassignedPanel.add((Component)unassignedLabel, "North");
        unassignedPanel.add((Component)scrollPane1, "Center");
        this._moveFromLeftToRightButton = new JAXJButton(">");
        this._moveFromRightToLeftButton = new JAXJButton("<");
        this._moveALLFromLeftToRightButton = new JAXJButton(">>");
        this._moveALLFromRightToLeftButton = new JAXJButton("<<");
        this._moveFromLeftToRightButton.addFocusListener(this);
        this._moveFromRightToLeftButton.addFocusListener(this);
        this._moveFromLeftToRightButton.addActionListener(this);
        this._moveFromRightToLeftButton.addActionListener(this);
        this._moveALLFromLeftToRightButton.addFocusListener(this);
        this._moveALLFromRightToLeftButton.addFocusListener(this);
        this._moveALLFromLeftToRightButton.addActionListener(this);
        this._moveALLFromRightToLeftButton.addActionListener(this);
        String rowSpec = "0:g(0.1),20px,0:g(0.1),20px,0:g(0.1),20px,0:g(0.1),20px,0:g(0.1)";
        FormLayout buttonTableLayout = new FormLayout("fill:default:grow", rowSpec);
        JPanel innerButtonPanel = new JPanel(buttonTableLayout);
        innerButtonPanel.setName("innerButtonPanel");
        innerButtonPanel.add((Component)this._moveFromLeftToRightButton, "1,2");
        innerButtonPanel.add((Component)this._moveFromRightToLeftButton, "1,8");
        innerButtonPanel.add((Component)this._moveALLFromLeftToRightButton, "1,4");
        innerButtonPanel.add((Component)this._moveALLFromRightToLeftButton, "1,6");
        innerButtonPanel.setFocusable(false);
        JPanel buttonHolderPanel = new JPanel(new BorderLayout());
        buttonHolderPanel.setName("buttonHolderPanel");
        buttonHolderPanel.add((Component)new JLabel(" "), "North");
        buttonHolderPanel.add((Component)innerButtonPanel, "Center");
        this._assignedValuesList = new JAXJList();
        this._assignedValuesList.addFocusListener(this);
        this._assignedValuesList.addMouseListener(this);
        this._assignedValuesList.setCellRenderer(this._simpleTypeListCellRenderer);
        if (this.getModelValues() != null) {
            this._assignedValuesList.setListData(this.getModelValues());
        }
        JScrollPane scrollPane2 = new JScrollPane(this._assignedValuesList);
        scrollPane2.setVerticalScrollBarPolicy(20);
        scrollPane2.setFocusable(false);
        scrollPane2.getViewport().setFocusable(false);
        scrollPane2.getHorizontalScrollBar().setFocusable(false);
        scrollPane2.getVerticalScrollBar().setFocusable(false);
        scrollPane2.setPreferredSize(new Dimension(300, 300));
        JPanel assignedPanel = new JPanel(new BorderLayout());
        assignedPanel.setName("assignedPanel");
        JLabel assignedLabel = new JLabel(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "label_assigned", "Assigned"));
        assignedPanel.add((Component)assignedLabel, "North");
        assignedPanel.add((Component)scrollPane2, "Center");
        innerPanel.add((Component)unassignedPanel, "1,1");
        innerPanel.add((Component)buttonHolderPanel, "3,1");
        innerPanel.add((Component)assignedPanel, "5,1");
        innerPanel.setFocusable(false);
        if (forDialog) {
            this._listSelectionView.add((Component)innerPanel, "2,2");
        } else {
            this._listSelectionView = innerPanel;
        }
        this._listSelectionView.setBorder(null);
        JScrollPane outerScrollPane = new JScrollPane(this._listSelectionView);
        outerScrollPane.setBorder(null);
        outerScrollPane.setVerticalScrollBarPolicy(20);
        outerScrollPane.setFocusable(false);
        outerScrollPane.getViewport().setFocusable(false);
        outerScrollPane.getViewport().setBorder(null);
        outerScrollPane.getHorizontalScrollBar().setFocusable(false);
        outerScrollPane.getVerticalScrollBar().setFocusable(false);
        return outerScrollPane;
    }

    private boolean isListInDialogMode() {
        if (this.getModel() != null && this.getModel().isList()) {
            return this.getStyle().isDialogMode();
        }
        return false;
    }

    protected JComponent createEditorComponent() {
        if (this.isListInDialogMode()) {
            FormLayout tableLayout = new FormLayout("fill:default:grow,85px", this.getStringDefaultComponentHeight());
            this._editorComponent = new JPanel(tableLayout);
            this._editorComponent.setName("editorComponent");
            this._textField = new JTextField();
            this._textField.setEnabled(false);
            this._textField.setColumns(1);
            this._textField.setFocusable(false);
            this.setEditorField(this._textField);
            this._editButton = new JAXJButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_edit", "Edit"));
            this._editButton.addActionListener(this);
            this._editButton.addFocusListener(this);
            this.setFirstFocusableComponent(this._editButton);
            this._editorComponent.add((Component)this._textField, "1,1");
            this._editorComponent.add((Component)this._editButton, "2,1");
        } else {
            this._editorComponent = this.createListSelectionView(false);
        }
        return this._editorComponent;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._moveALLFromLeftToRightButton) {
            ListModel lModel = this._unassignedValuesList.getModel();
            Object[] selectedValues = this._unassignedValues.toArray();
            this.setModelValues(selectedValues);
            this.populateView();
        } else if (event.getSource() == this._moveALLFromRightToLeftButton) {
            Object[] selectedValues = this.getModelValues().toArray();
            this.removeModelValues(selectedValues);
            this.populateView();
        } else if (event.getSource() == this._moveFromLeftToRightButton && this.getUnassignedValues() != null && this.getUnassignedValues().size() > 0 && this._unassignedValuesList.getSelectedIndex() < this.getUnassignedValues().size()) {
            if (this._unassignedValuesList.getMaxSelectionIndex() >= this.getUnassignedValues().size()) {
                this._unassignedValuesList.setSelectionInterval(this._unassignedValuesList.getMinSelectionIndex(), this.getUnassignedValues().size() - 1);
            }
            Object[] selectedValues = this._unassignedValuesList.getSelectedValues();
            this.setModelValues(selectedValues);
            this.populateView();
        } else if (event.getSource() == this._moveFromRightToLeftButton && this.getModelValues() != null && this.getModelValues().size() > 0 && this._assignedValuesList.getMinSelectionIndex() < this.getModelValues().size()) {
            if (this._assignedValuesList.getMaxSelectionIndex() >= this.getModelValues().size()) {
                this._assignedValuesList.setSelectionInterval(this._assignedValuesList.getMinSelectionIndex(), this.getModelValues().size() - 1);
            }
            Object[] selectedValues = this._assignedValuesList.getSelectedValues();
            this.removeModelValues(selectedValues);
            this.populateView();
        } else if (event.getSource() == this._editButton) {
            this.showDialog(true);
        } else if (event.getSource() == this._cancelButton) {
            this.cancelDialog();
        } else if (event.getSource() == this._okButton) {
            this.commitDialog();
        }
    }

    private void showDialog(boolean show) {
        block2: {
            try {
                this._originalType = this.getModel().deepClone(this.getDOM(), true, true);
            }
            catch (CloneNotSupportedException ex) {
                if (!LogRegistry.getInstance().logWarnings()) break block2;
                LogRegistry.getInstance().warn(this.getClass(), "unable to clone type from: " + this.getModel().getXPathLocation());
            }
        }
        this.getDialog().setVisible(show);
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public void release() {
        if (this._unassignedValuesList != null) {
            this._unassignedValuesList.removeFocusListener(this);
            this._unassignedValuesList.removeMouseListener(this);
        }
        if (this._assignedValuesList != null) {
            this._assignedValuesList.removeFocusListener(this);
            this._assignedValuesList.removeMouseListener(this);
        }
        if (this._moveFromLeftToRightButton != null) {
            this._moveFromLeftToRightButton.removeFocusListener(this);
        }
        if (this._moveFromRightToLeftButton != null) {
            this._moveFromRightToLeftButton.removeFocusListener(this);
        }
        if (this._moveALLFromLeftToRightButton != null) {
            this._moveALLFromLeftToRightButton.removeFocusListener(this);
        }
        if (this._moveALLFromRightToLeftButton != null) {
            this._moveALLFromRightToLeftButton.removeFocusListener(this);
        }
        if (this._editButton != null) {
            this._editButton.removeFocusListener(this);
        }
        this._simpleTypeListCellRenderer = null;
        this._unassignedValuesList = null;
        this._assignedValuesList = null;
        this._moveFromLeftToRightButton = null;
        this._moveALLFromLeftToRightButton = null;
        this._moveALLFromRightToLeftButton = null;
        this._moveFromRightToLeftButton = null;
        this._editButton = null;
        this._okButton = null;
        this._cancelButton = null;
        this._dialogButtonPanel = null;
        this._textField = null;
        this._dialog = null;
        this._unassignedValues = null;
        this._modelValues = null;
        this._originalType = null;
        this._currentCodes = null;
        this._listSelectionView = null;
    }

    public void setBackground(Color color) {
        if (color != null) {
            if (this._textField != null) {
                this._textField.setBackground(color);
            }
            if (this._assignedValuesList != null) {
                this._assignedValuesList.setBackground(color);
            }
            if (this._unassignedValuesList != null) {
                this._unassignedValuesList.setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        if (color != null) {
            if (this._textField != null) {
                this._textField.setForeground(color);
            }
            if (this._assignedValuesList != null) {
                this._assignedValuesList.setForeground(color);
            }
            if (this._unassignedValuesList != null) {
                this._unassignedValuesList.setForeground(color);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._editButton != null) {
            this._editButton.setEnabled(enabled);
        }
        if (this._unassignedValuesList != null) {
            this._unassignedValuesList.setEditable(enabled);
        }
        if (this._assignedValuesList != null) {
            this._assignedValuesList.setEditable(enabled);
        }
        this._moveFromLeftToRightButton.setEditable(enabled);
        this._moveFromRightToLeftButton.setEditable(enabled);
        this._moveALLFromLeftToRightButton.setEditable(enabled);
        this._moveALLFromRightToLeftButton.setEditable(enabled);
    }

    public String getText() {
        return null;
    }

    public void setCodeSetValues(String url, String codeSetName, String[] codes, String defaultSelection) {
        ((ListType)this.getModel()).getEditingType().setCodeSetValues(url, codeSetName, codes, defaultSelection);
        this._currentCodes = null;
        this.populateView();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this._unassignedValuesList != null) {
            this._unassignedValuesList.setEditable(editable);
        }
        if (this._assignedValuesList != null) {
            this._assignedValuesList.setEditable(editable);
        }
        this._moveFromLeftToRightButton.setEditable(editable);
        this._moveFromRightToLeftButton.setEditable(editable);
        this._moveALLFromLeftToRightButton.setEditable(editable);
        this._moveALLFromRightToLeftButton.setEditable(editable);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            if (e.getSource() == this._unassignedValuesList && this._unassignedValuesList.getModel().getSize() > 0) {
                Object[] selectedValues = this._unassignedValuesList.getSelectedValues();
                this.setModelValues(selectedValues);
                this.populateView();
            } else if (e.getSource() == this._assignedValuesList && this._assignedValuesList.getModel().getSize() > 0) {
                Object[] selectedValues = this._assignedValuesList.getSelectedValues();
                this.removeModelValues(selectedValues);
                this.populateView();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public class SimpleTypeListCellRenderer
    extends DefaultListCellRenderer {
        private static final String N_A = " ";

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel defaultListCellRenderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof SimpleType) {
                String newValue = ((SimpleType)value).getValue();
                String text = N_A;
                if (newValue != null) {
                    if (SimpleTypeListSelectionView.this.getEditingType().getStyle().isUsingCodeSet()) {
                        String translatedCode = SimpleTypeListSelectionView.this.getTextForCode(newValue);
                        if (translatedCode != null) {
                            text = translatedCode;
                        }
                    } else {
                        text = newValue;
                    }
                }
                defaultListCellRenderer.setText(text);
            } else if (value == null || value.toString().length() == 0) {
                defaultListCellRenderer.setText(N_A);
            }
            return defaultListCellRenderer;
        }
    }
}

