/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.wrapper;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Recursion;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.RecursionVisualizer;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.ui.tableModel.JAXDataTable;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.FunctionalTitleBorder;
import com.jaxfront.swing.ui.tools.GenericAction;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeView;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class RecursionWrapper
extends AbstractSimpleTypeView
implements TabbableView,
Visualizer,
ListVisualizer,
RecursionVisualizer {
    private Visualizer _visualizer;
    private JPanel _recursionPanel;
    protected int _originHeight;
    private BorderActionSet createRecursionActionSet;
    private BorderActionSet deleteRecursionActionSet;
    protected boolean _isBuilt = false;

    public RecursionWrapper(Type type) {
        this.setModel(type);
    }

    public RecursionWrapper(Type type, Type context) {
        super(context);
        this.setModel(type);
    }

    protected JComponent createEditorComponent() {
        return null;
    }

    protected void defaultBuild() {
        this.setLayout(new BorderLayout());
        if (this.getModel().getParent() == null || !this.getModel().getParent().isList()) {
            FunctionalTitleBorder funcBorder = new FunctionalTitleBorder(this.getModel().getStyle().getCaptionTitleLabel(), this);
            this.deleteRecursionActionSet = new BorderActionSet("deleteRecursion", new GenericAction("deleteRecursion", this, "deleteRecursion"), null, JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/delete_16x16.gif").getImage(), null, null, null, "deleteRecursion", 1);
            this.createRecursionActionSet = new BorderActionSet("createRecursion", new GenericAction("createRecursion", this, "createRecursion"), null, JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/new_16x16.gif").getImage(), null, null, null, "createRecursion", 1);
            funcBorder.addBorderAction(this.deleteRecursionActionSet);
            funcBorder.addBorderAction(this.createRecursionActionSet);
            if (this.getModel().getDirectChildren().size() > 0) {
                this.setDelRecursionEnabled(true);
                this.setCreRecursionEnabled(false);
            } else {
                this.setDelRecursionEnabled(false);
                this.setCreRecursionEnabled(true);
            }
            this.setBorder(funcBorder);
        }
        this._recursionPanel = new JPanel(new BorderLayout());
        this.add((Component)this._recursionPanel, "Center");
        this._isBuilt = this.getModel().hasRecursionBeenBuilt();
    }

    public void setDeleteable(boolean deleteable) {
        this.setDelRecursionEnabled(deleteable);
        this.setCreRecursionEnabled(!deleteable);
    }

    private void setDelRecursionEnabled(boolean enabled) {
        if (this.deleteRecursionActionSet != null) {
            this.deleteRecursionActionSet.setEnabled(enabled);
        }
    }

    private void setCreRecursionEnabled(boolean enabled) {
        if (this.createRecursionActionSet != null) {
            this.createRecursionActionSet.setEnabled(enabled);
        }
    }

    public Dimension getSize(Dimension dim) {
        if (this._visualizer != null) {
            Dimension newDimension = new Dimension((int)((JComponent)this._visualizer).getSize(dim).getWidth(), (int)((JComponent)this._visualizer).getSize(dim).getHeight() + 50);
            return newDimension;
        }
        return super.getPreferredSize();
    }

    public void markError() {
        if (this._visualizer != null) {
            this._visualizer.markError();
        }
    }

    public void populateModel() {
        if (this._visualizer != null) {
            this._visualizer.populateModel();
        } else {
            super.populateModel();
        }
    }

    public void populateView() {
        if (this._visualizer != null) {
            this._visualizer.populateView();
        }
    }

    public void resetError() {
        if (this._visualizer != null) {
            this._visualizer.resetError();
        }
    }

    public void setLabelColor(Color color) {
        if (this._visualizer != null) {
            this._visualizer.setLabelColor(color);
        }
    }

    public void setRequired(boolean required) {
        if (this._visualizer != null) {
            this._visualizer.setRequired(required);
        }
    }

    public void setApplicationRequired(boolean required) {
        if (this._visualizer != null) {
            this._visualizer.setApplicationRequired(required);
        }
    }

    public void showLabel(boolean show) {
        if (this._visualizer != null) {
            this._visualizer.showLabel(show);
        }
    }

    public void createRecursion() {
        if (!this._isBuilt) {
            this._visualizer = Recursion.createRecursionVisualizer((RecursionVisualizer)this);
            this.addToRecursionPanel(this._visualizer);
            this.setDelRecursionEnabled(true);
            this.createRecursionActionSet.setEnabled(false);
            this.getDOM().getEditor().getWindow().validate();
            this._isBuilt = true;
        }
    }

    public Document getDOM() {
        if (this._visualizer != null && !this._visualizer.isViewReleased()) {
            return this._visualizer.getModel().getDOM();
        }
        return super.getDOM();
    }

    public Type getModel() {
        if (this._visualizer != null) {
            return this._visualizer.getModel();
        }
        return super.getModel();
    }

    public void deleteRecursion() {
        if (this._isBuilt) {
            boolean delete = true;
            boolean showDeletionMesssage = true;
            if (showDeletionMesssage) {
                delete = Dialog.showListDeletionDialog(this.getModel(), null);
            }
            if (delete) {
                this._recursionPanel.removeAll();
                Recursion.deleteRecursion((RecursionVisualizer)this);
                this._visualizer = null;
                this.setDelRecursionEnabled(false);
                this.setCreRecursionEnabled(true);
                ((CompositeType)this.getModel()).getDOM().getEditor().getWindow().validate();
                this._isBuilt = false;
            }
        }
    }

    public JPanel getRecursionPanel() {
        return this._recursionPanel;
    }

    public void jumpTo() {
        if (this._visualizer != null) {
            this._visualizer.jumpTo();
        }
    }

    public void postInitialization() {
        if (this._visualizer != null) {
            this._visualizer.postInitialization();
        }
    }

    public void setEditable(boolean enabled) {
        if (this._visualizer != null) {
            this._visualizer.setEditable(enabled);
        }
        this.setDelRecursionEnabled(enabled);
        this.setCreRecursionEnabled(enabled);
    }

    public void setVisible(boolean visible) {
        if (this._visualizer != null) {
            this._visualizer.setVisible(visible);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this._visualizer != null) {
            this._visualizer.setEnabled(enabled);
        }
        this.setDelRecursionEnabled(enabled);
        this.setCreRecursionEnabled(enabled);
    }

    public String getText() {
        if (this._visualizer != null && this._visualizer instanceof AbstractSimpleTypeView) {
            return ((AbstractSimpleTypeView)this._visualizer).getText();
        }
        return null;
    }

    public Type getContext() {
        return this.getImplementation() != null ? this.getImplementation().getContext() : null;
    }

    public void showTab(Type type, Object component) {
        if (this._visualizer != null) {
            if (this._visualizer instanceof TabbableView) {
                ((TabbableView)this._visualizer).showTab(null, component);
            } else if (this._visualizer instanceof AbstractListTypeView) {
                ((AbstractListTypeView)this._visualizer).selectTab(((Visualizer)component).getModel());
            }
        }
    }

    public Type getSelectedTabType() {
        if (this._visualizer != null && this._visualizer instanceof TabbableView) {
            return ((TabbableView)this._visualizer).getSelectedTabType();
        }
        return null;
    }

    public JComponent getEditorField() {
        if (this._visualizer != null && this._visualizer instanceof AbstractSimpleTypeView) {
            return ((AbstractSimpleTypeView)this._visualizer).getEditorField();
        }
        return this.getEditorComponent();
    }

    public void showHint(String text, boolean isFormula, Color color, boolean isBold) {
        if (this._visualizer != null && this._visualizer instanceof AbstractView) {
            ((AbstractView)this._visualizer).showHint(text, isFormula, color, isBold);
        } else {
            super.showHint(text, isFormula, color, isBold);
        }
    }

    public void setCodeSetValues(String url, String codeSetName, String[] values, String defaultSelection) {
        if (this._visualizer != null && this._visualizer instanceof AbstractView) {
            ((AbstractView)this._visualizer).setCodeSetValues(url, codeSetName, values, defaultSelection);
        } else {
            super.setCodeSetValues(url, codeSetName, values, defaultSelection);
        }
    }

    public void removeHint() {
        if (this._visualizer != null && this._visualizer instanceof AbstractView) {
            ((AbstractView)this._visualizer).removeHint();
        } else {
            super.removeHint();
        }
    }

    public void removeMessage() {
        if (this._visualizer != null && this._visualizer instanceof AbstractView) {
            ((AbstractView)this._visualizer).removeMessage();
        } else {
            super.removeMessage();
        }
    }

    public void setBackground(Color color) {
        if (this._visualizer != null) {
            ((JComponent)this._visualizer).setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this._visualizer != null) {
            ((JComponent)this._visualizer).setForeground(color);
        }
    }

    public void setToolTipText(String text) {
        if (this._visualizer != null) {
            ((JComponent)this._visualizer).setToolTipText(text);
        }
    }

    public void setFont(Font font) {
        if (this._visualizer != null) {
            ((JComponent)this._visualizer).setFont(font);
        }
    }

    public Component getFirstFocusableComponent() {
        if (this._visualizer != null && this._visualizer instanceof AbstractView) {
            return ((AbstractView)this._visualizer).getFirstFocusableComponent();
        }
        return super.getFirstFocusableComponent();
    }

    public JPanel getEditorComponentPanel() {
        if (this._visualizer != null && this._visualizer instanceof AbstractView) {
            return ((AbstractView)this._visualizer).getEditorComponentPanel();
        }
        return super.getEditorComponentPanel();
    }

    public void selectType(Type type) {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).selectType(type);
        }
    }

    public JDialog getEditDialog(Type selectedType, Type context) {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            return ((ListVisualizer)this._visualizer).getEditDialog(selectedType, context);
        }
        return null;
    }

    public JAXDataTable getDataTable() {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            return ((ListVisualizer)this._visualizer).getDataTable();
        }
        return null;
    }

    public void addTab(Type type) {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).addTab(type);
        }
    }

    public void removeTab(Type type) {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).removeTab(type);
        }
    }

    public void showUpDownButtons(boolean showUpDownButtons) {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).showUpDownButtons(showUpDownButtons);
        }
    }

    public Visualizer getImplementation() {
        if (this._visualizer != null) {
            return this._visualizer.getImplementation();
        }
        return this._visualizer;
    }

    public void resetView() {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this.getImplementation()).resetView();
        }
    }

    public void requestFocus() {
        if (this._visualizer != null) {
            ((Component)this._visualizer).requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void showModel(Type type) {
        if (this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).showModel(type);
        }
    }

    public void addToRecursionPanel(Visualizer comp) {
        this._recursionPanel.removeAll();
        this._visualizer = comp;
        if (comp != null) {
            this._recursionPanel.add((Component)comp);
        }
    }

    public void expand(boolean expand) {
        if (expand) {
            this._borderPanel.expand();
        } else {
            this._borderPanel.collapse();
        }
    }

    public ListType getListModel() {
        return (ListType)this.getModel();
    }

    public void release() {
        if (this._visualizer != null && this._visualizer != this) {
            if (this.getModel() != null && this.getModel().getPropertyChangeSupport() != null && this._visualizer instanceof PropertyChangeListener) {
                this.getModel().getPropertyChangeSupport().removePropertyChangeListener((PropertyChangeListener)this._visualizer);
            }
            this._visualizer.release();
        }
        super.release();
    }

    public void selectType(Type type, boolean isUserAction) {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).selectType(type, isUserAction);
        }
    }

    public void refresh() {
        if (this._visualizer != null && this._visualizer instanceof ListVisualizer) {
            ((ListVisualizer)this._visualizer).refresh();
        }
    }
}

