/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.wrapper;

import com.jaxfront.swing.ui.layout.ListLayout;
import com.jaxfront.swing.ui.visualizers.SelectablePanel;
import com.jaxfront.swing.ui.wrapper.Selectable;
import com.jaxfront.swing.ui.wrapper.SimpleJListCellRenderer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SimpleJList
extends JPanel
implements ListDataListener,
ItemListener {
    private ListModel _model;
    private boolean _selectAllEnabled = false;
    private Vector _selectionItems;
    private Vector _selectedItems;
    private boolean _selectionEnabled = true;
    private SelectablePanel _selectAllPanel = null;
    private SimpleJListCellRenderer _renderer;
    private SimpleJListCellRenderer _rendererDelegate = new RendererDelegate();

    public SimpleJList(ListModel model) {
        this._model = model;
        model.addListDataListener(this);
        this.setLayout(new ListLayout());
        this.build();
    }

    public SimpleJList(ListModel model, boolean showSelectAll) {
        this._model = model;
        this._selectAllEnabled = showSelectAll;
        model.addListDataListener(this);
        this.setLayout(new ListLayout());
        this.build();
    }

    public void rebuild() {
        if (this._selectAllPanel != null) {
            this._selectAllPanel.getSelectorComponent().removeItemListener(this);
        }
        this.setSelectionItems(null);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof SelectablePanel)) continue;
            SelectablePanel selectPanel = (SelectablePanel)this.getComponent(i);
            selectPanel.getSelectorComponent().removeItemListener(this);
        }
        this.removeAll();
        this.build();
        this.updateUI();
    }

    public void build() {
        if (this._selectAllEnabled) {
            this._selectAllPanel = new SelectablePanel(this.isSelectionEnabled(), "East", new JLabel(""));
            this._selectAllPanel.getSelectorComponent().addItemListener(this);
            this.add(this._selectAllPanel);
        }
        this.setSelectionItems(null);
        for (int i = 0; i < this._model.getSize(); ++i) {
            Object renderElement = this._model.getElementAt(i);
            Component comp = this.getCellRenderer().getListCellComponent(this, renderElement, i, false, false);
            SelectablePanel selectPanel = new SelectablePanel(this.isSelectionEnabled(), "East", (JComponent)comp);
            selectPanel.getSelectorComponent().addItemListener(this);
            this.getSelectionItems().add(selectPanel);
            this.add(selectPanel);
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.rebuild();
    }

    public void intervalAdded(ListDataEvent e) {
        this.rebuild();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.rebuild();
    }

    public void setCellRenderer(SimpleJListCellRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            this.rebuild();
        }
    }

    public SimpleJListCellRenderer getCellRenderer() {
        if (this._renderer == null) {
            return this._rendererDelegate;
        }
        return this._renderer;
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (this._model != model) {
            this._model = model;
            this.rebuild();
        }
    }

    public Vector getSelectedItems() {
        Vector selectedItems = new Vector();
        for (int i = 0; i < this.getSelectionItems().size(); ++i) {
            Object o = this.getSelectionItems().get(i);
            if (!(o instanceof Selectable) || !((Selectable)o).isSelected()) continue;
            selectedItems.add(this.getModel().getElementAt(i));
        }
        this._selectedItems = selectedItems;
        return selectedItems;
    }

    public int getFirstSelectedIndex() {
        for (int i = 0; i < this.getSelectionItems().size(); ++i) {
            Object o = this.getSelectionItems().get(i);
            if (!(o instanceof Selectable) || !((Selectable)o).isSelected()) continue;
            return i;
        }
        return -1;
    }

    private void setSelectionItems(Vector selectionItems) {
        this._selectionItems = selectionItems;
    }

    private Vector getSelectionItems() {
        if (this._selectionItems == null) {
            this._selectionItems = new Vector();
        }
        return this._selectionItems;
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this._selectionEnabled = selectionEnabled;
    }

    public boolean isSelectionEnabled() {
        return this._selectionEnabled;
    }

    public void itemStateChanged(ItemEvent e) {
        Vector oldSelection = this._selectedItems;
        if (e.getSource() == this._selectAllPanel.getSelectorComponent()) {
            Vector selectedItems = new Vector();
            boolean allSelected = this._selectAllPanel.isSelected();
            for (int i = 0; i < this.getSelectionItems().size(); ++i) {
                Object o = this.getSelectionItems().get(i);
                if (!(o instanceof Selectable)) continue;
                ((Selectable)o).select(allSelected);
            }
        } else if (e.getItem() instanceof JCheckBox) {
            // empty if block
        }
        this.firePropertyChange("listSelectionChanged", oldSelection, this.getSelectedItems());
    }

    class RendererDelegate
    implements SimpleJListCellRenderer {
        RendererDelegate() {
        }

        public Component getListCellComponent(SimpleJList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return new JTextField(value.toString());
        }
    }
}

