/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;

public final class FormFactory {
    public static final ColumnSpec MIN_COLSPEC = new ColumnSpec(Sizes.MINIMUM).asUnmodifyable();
    public static final ColumnSpec PREF_COLSPEC = new ColumnSpec(Sizes.PREFERRED).asUnmodifyable();
    public static final ColumnSpec DEFAULT_COLSPEC = new ColumnSpec(Sizes.DEFAULT).asUnmodifyable();
    public static final ColumnSpec GLUE_COLSPEC = new ColumnSpec(ColumnSpec.DEFAULT, Sizes.ZERO, 1.0).asUnmodifyable();
    public static final ColumnSpec RELATED_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getRelatedComponentsPadX());
    public static final ColumnSpec UNRELATED_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getUnrelatedComponentsPadX());
    public static final ColumnSpec BUTTON_COLSPEC = new ColumnSpec(Sizes.bounded(Sizes.PREFERRED, LayoutStyle.getCurrent().getDefaultButtonWidth(), null)).asUnmodifyable();
    public static final ColumnSpec GROWING_BUTTON_COLSPEC = new ColumnSpec(ColumnSpec.DEFAULT, BUTTON_COLSPEC.getSize(), 1.0).asUnmodifyable();
    public static final RowSpec MIN_ROWSPEC = new RowSpec(Sizes.MINIMUM).asUnmodifyable();
    public static final RowSpec PREF_ROWSPEC = new RowSpec(Sizes.PREFERRED).asUnmodifyable();
    public static final RowSpec DEFAULT_ROWSPEC = new RowSpec(Sizes.DEFAULT).asUnmodifyable();
    public static final RowSpec GLUE_ROWSPEC = new RowSpec(RowSpec.DEFAULT, Sizes.ZERO, 1.0).asUnmodifyable();
    public static final RowSpec RELATED_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getRelatedComponentsPadY());
    public static final RowSpec UNRELATED_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getUnrelatedComponentsPadY());
    public static final RowSpec LINE_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getLinePad());
    public static final RowSpec NARROW_LINE_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getNarrowLinePad());
    public static final RowSpec PARAGRAPH_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getParagraphPad());

    public static FormLayout createColumnLayout(int majorColumns, int minorColumns, ColumnSpec labelColumnSpec) {
        return FormFactory.createColumnLayout(majorColumns, minorColumns, labelColumnSpec, Sizes.DLUX14, Sizes.DLUX2);
    }

    public static FormLayout createColumnLayout(int majorColumns, int minorColumns, ColumnSpec labelColumnSpec, ConstantSize indent, ConstantSize minorColumnGap) {
        return FormFactory.createColumnLayout(majorColumns, minorColumns, labelColumnSpec, PREF_COLSPEC, indent, Sizes.DLUX14, minorColumnGap);
    }

    public static FormLayout createColumnLayout(int majorColumns, int minorColumns, ColumnSpec labelColumnSpec, ColumnSpec componentColumnSpec, ConstantSize indent, ConstantSize majorColumnGap, ConstantSize minorColumnGap) {
        ColumnSpec majorGapColSpec = FormFactory.createGapColumnSpec(majorColumnGap);
        ColumnSpec minorGapColSpec = FormFactory.createGapColumnSpec(minorColumnGap);
        FormLayout layout = new FormLayout(new ColumnSpec[0], new RowSpec[0]);
        if (indent != null) {
            layout.appendColumn(FormFactory.createGapColumnSpec(indent));
        }
        for (int i = 0; i < majorColumns; ++i) {
            if (labelColumnSpec != null) {
                layout.appendColumn(labelColumnSpec);
                layout.appendColumn(RELATED_GAP_COLSPEC);
            }
            for (int j = 0; j < minorColumns; ++j) {
                layout.appendColumn(componentColumnSpec);
                layout.addGroupedColumn(layout.getColumnCount());
                if (j >= minorColumns - 1) continue;
                layout.appendColumn(minorGapColSpec);
            }
            if (i >= majorColumns - 1) continue;
            layout.appendColumn(majorGapColSpec);
        }
        return layout;
    }

    public static ColumnSpec createGapColumnSpec(ConstantSize gapSize) {
        ColumnSpec spec = new ColumnSpec(ColumnSpec.LEFT, gapSize, 0.0);
        return spec.asUnmodifyable();
    }

    public static RowSpec createGapRowSpec(ConstantSize gapSize) {
        RowSpec spec = new RowSpec(RowSpec.TOP, gapSize, 0.0);
        return spec.asUnmodifyable();
    }
}

