/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.ITypeNeighbor;
import gov.nasa.ltl.graph.Pair;
import java.util.Iterator;
import java.util.TreeSet;

public class ColorPair<PropT>
extends Pair<TreeSet<ITypeNeighbor<PropT>>>
implements Comparable<ColorPair<PropT>> {
    public ColorPair(int colorIn, TreeSet<ITypeNeighbor<PropT>> iMaxSetIn) {
        super(colorIn, iMaxSetIn);
    }

    public void setColor(int colorIn) {
        super.setValue(colorIn);
    }

    public int getColor() {
        return super.getValue();
    }

    public void setIMaxSet(TreeSet<ITypeNeighbor<PropT>> iMaxSetIn) {
        super.setElement(iMaxSetIn);
    }

    public TreeSet<ITypeNeighbor<PropT>> getIMaxSet() {
        return (TreeSet)super.getElement();
    }

    @Override
    public int compareTo(ColorPair<PropT> other) {
        TreeSet<ITypeNeighbor<PropT>> otherSet = other.getIMaxSet();
        if (this.getIMaxSet().size() < otherSet.size()) {
            return -1;
        }
        if (this.getIMaxSet().size() > otherSet.size()) {
            return 1;
        }
        Iterator<ITypeNeighbor<PropT>> otherIter = otherSet.iterator();
        for (ITypeNeighbor<PropT> currNeigh : this.getIMaxSet()) {
            assert (otherIter.hasNext());
            int comparison = currNeigh.compareTo(otherIter.next());
            if (comparison >= 0 && comparison <= 0) continue;
            return comparison;
        }
        if (this.getColor() < other.getColor()) {
            return -1;
        }
        if (this.getColor() > other.getColor()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ColorPair)) {
            return false;
        }
        ColorPair other = (ColorPair)o;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

