/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Generate;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Label;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.SynchronousProduct;

public class Degeneralize {
    public static <PropT> Graph<PropT> degeneralize(Graph<PropT> g) {
        int nsets = g.getIntAttribute("nsets");
        String type = g.getStringAttribute("type");
        if (type.equals("gba")) {
            String ac = g.getStringAttribute("ac");
            if (ac.equals("nodes")) {
                if (nsets == 1) {
                    Degeneralize.accept(g);
                } else {
                    Label.label(g);
                    Graph<String> d = Generate.generate(nsets);
                    g = SynchronousProduct.product(g, d);
                }
            } else if (ac.equals("edges")) {
                Graph<String> d = Generate.generate(nsets);
                g = SynchronousProduct.product(g, d);
            }
        } else if (!type.equals("ba")) {
            throw new RuntimeException("invalid graph type: " + type);
        }
        return g;
    }

    private static <PropT> void accept(Graph<PropT> g) {
        g.setBooleanAttribute("nsets", false);
        g.forAllNodes(new EmptyVisitor<PropT>(){

            @Override
            public void visitNode(Node<PropT> n) {
                if (n.getBooleanAttribute("acc0")) {
                    n.setBooleanAttribute("accepting", true);
                    n.setBooleanAttribute("acc0", false);
                }
            }
        });
    }
}

