/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graphio;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graphio.SMWriter;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.io.PrintStream;

class FSPWriter<PropT>
extends SMWriter<PropT> {
    FSPWriter(PrintStream s) {
        super(s);
    }

    @Override
    public void write(Graph<PropT> g) {
        boolean first = true;
        if (g.getInit() == null) {
            this.out.print("Empty");
            return;
        }
        this.out.print("RES = S" + g.getInit().getId());
        for (Node<PropT> n : g.getNodes()) {
            this.out.println(',');
            this.write(n);
        }
        this.out.println('.');
        if (g.getIntAttribute("nsets") != 0) {
            int i = 0;
            while (i < g.getIntAttribute("nsets")) {
                this.out.print("AS" + i + " = { ");
                for (Node<PropT> n : g.getNodes()) {
                    if (!n.getBooleanAttribute("acc" + i)) continue;
                    if (!first) {
                        this.out.print(", ");
                    }
                    first = false;
                    this.out.print("S" + n.getId());
                }
                this.out.println(" }");
                ++i;
            }
        } else {
            this.out.print("AS = { ");
            for (Node<PropT> n : g.getNodes()) {
                if (!n.getBooleanAttribute("accepting")) continue;
                if (!first) {
                    this.out.print(", ");
                }
                first = false;
                this.out.print("S" + n.getId());
            }
            this.out.println(" }");
        }
    }

    @Override
    public void write(Node<PropT> n) {
        boolean first = true;
        this.out.print("S" + n.getId() + "=(");
        for (Edge<PropT> e : n.getOutgoingEdges()) {
            if (!first) {
                this.out.print(" |");
            }
            first = false;
            this.write(e);
        }
        this.out.print(')');
    }

    @Override
    public void write(Edge<PropT> e) {
        int nsets = e.getSource().getGraph().getIntAttribute("nsets");
        boolean first = true;
        if (e.getGuard().isTrue()) {
            this.out.print("TRUE");
        } else {
            ((SMWriter)this).write(e.getGuard());
        }
        if (nsets != 0) {
            int i = 0;
            while (i < nsets) {
                if (e.getBooleanAttribute("acc" + i)) {
                    if (first) {
                        this.out.print('{');
                    } else {
                        this.out.print(',');
                    }
                    first = false;
                    this.out.print(i);
                }
                ++i;
            }
            if (!first) {
                this.out.print('}');
            }
        } else if (e.getBooleanAttribute("accepting")) {
            this.out.print('@');
        }
        this.out.print("-> S" + e.getNext().getId());
    }

    @Override
    public void write(State<PropT>[] states) {
        if (states == null || states.length == 0) {
            this.out.print("\n\nRES = STOP.\n");
        }
        this.out.print("\n\nRES = S0");
        int i = 0;
        while (i < states.length) {
            if (i == states[i].getRepresentativeId()) {
                this.out.print(',');
                this.write(states[i]);
            }
            ++i;
        }
        this.out.print(".\n");
    }

    @Override
    public void write(State<PropT> s) {
        boolean first = true;
        this.out.print('S');
        this.out.print(s.getRepresentativeId());
        this.out.print('=');
        for (Transition transition : s.getTransitions()) {
            if (first) {
                this.out.print('(');
            } else {
                this.out.print('|');
            }
            first = false;
            this.write(transition);
        }
        if (!first) {
            this.out.print(')');
        }
    }

    @Override
    public void write(Transition<PropT> t) {
        ((SMWriter)this).write(t.getGuard());
        this.out.print('{');
        if (t.getAcceptingConds() == 0) {
            if (t.isSafeAccepting()) {
                this.out.print('0');
            }
        } else {
            int i = 0;
            while (i < t.getAcceptingConds()) {
                if (t.isAccepting(i)) {
                    this.out.print(i);
                }
                ++i;
            }
        }
        this.out.print("} -> S" + t.goesTo() + " ");
    }
}

