/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graphio;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.Literal;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graphio.Writer;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.io.PrintStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWriter<PropT>
extends Writer<PropT> {
    protected PrintStream out;

    XMLWriter(PrintStream s) {
        this.out = s;
    }

    @Override
    public void write(Graph<PropT> g) {
        DocumentBuilder db = null;
        Transformer transformer = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (ParserConfigurationException e) {
            assert (false) : e;
            return;
        }
        catch (TransformerConfigurationException e) {
            assert (false) : e;
            return;
        }
        catch (TransformerFactoryConfigurationError e) {
            assert (false) : e;
            return;
        }
        Document doc = db.newDocument();
        Element graph = doc.createElement("graph");
        graph.setAttribute("nodes", "" + g.getNodeCount());
        for (Node<PropT> n : g.getNodes()) {
            Map<Object, String> attr = n.getAttributes().getAll();
            Element node = doc.createElement("node");
            node.setAttribute("id", "" + n.getId());
            if (n == g.getInit()) {
                Element element = doc.createElement("init");
                element.appendChild(doc.createTextNode("true"));
                node.appendChild(element);
            }
            for (Object object : attr.keySet()) {
                if (("" + object).equals("_id")) continue;
                Element k = doc.createElement("" + object);
                if (!attr.get(object).equals("")) {
                    k.appendChild(doc.createTextNode(attr.get(object)));
                }
                node.appendChild(k);
            }
            for (Edge edge : n.getOutgoingEdges()) {
                Element trans = doc.createElement("transition");
                trans.setAttribute("to", "" + edge.getNext().getId());
                if (edge.getGuard() != null && !edge.getGuard().isTrue()) {
                    Element guard = doc.createElement("guard");
                    guard.appendChild(doc.createTextNode(XMLWriter.formatSMGuard(edge.getGuard())));
                    trans.appendChild(guard);
                }
                if (edge.getAction() != null && !edge.getAction().equals("-")) {
                    Element action = doc.createElement("action");
                    action.appendChild(doc.createTextNode(edge.getAction()));
                    trans.appendChild(action);
                }
                node.appendChild(trans);
            }
            graph.appendChild(node);
        }
        doc.appendChild(graph);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(this.out);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(Node<PropT> n) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Edge<PropT> e) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(State<PropT>[] states) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(State<PropT> s) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Transition<PropT> t) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Guard<PropT> g) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Literal<PropT> l) {
        throw new RuntimeException("Not implemented.");
    }
}

