/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.tests;

import gov.nasa.ltl.graph.Degeneralize;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.SCCReduction;
import gov.nasa.ltl.graph.SFSReduction;
import gov.nasa.ltl.graph.Simplify;
import gov.nasa.ltl.graph.SuperSetReduction;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTL2Buchi;
import gov.nasa.ltl.trans.Rewriter;
import gov.nasa.ltl.trans.Translator;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import java.util.Random;

public class RandomFormulae {
    public static int N = 3;
    public static int Lmin = 5;
    public static int Lmax = 30;
    public static int Linc = 5;
    public static int F = 100;
    public static long seed = 0L;
    public static boolean haveSeed = false;
    public static boolean optimise = false;
    public static boolean verbose = false;
    public static double P = 0.3333333333333333;
    private static String Pstr = null;
    private static boolean haveCpuTime;

    public static void main(String[] args) {
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        RandomFormulae.parseArgs(args);
        if (!haveSeed) {
            seed = System.nanoTime();
        }
        Random rand = new Random(seed);
        if (Pstr == null) {
            Pstr = "" + P;
            P = Double.valueOf(Pstr);
        }
        if (tb.isCurrentThreadCpuTimeSupported()) {
            haveCpuTime = true;
            tb.setThreadCpuTimeEnabled(true);
        }
        RandomFormulae.verbose("Parameters:\n-N " + N + " -L " + Lmin + " " + Lmax + " " + Linc + " -P " + Pstr + " -F " + F + " -seed " + seed + (optimise ? " -optimise" : "") + (verbose ? " -verbose" : "") + "\n");
        RandomFormulae.verbose("Plot me with:\nset key autotitle columnheader\nplot [0:" + (Lmax + Linc) + "] [0:1] for [i in \"2 4 6 8\"] " + "\"data.file\" using 1:i:(column(i+1)) with errorbars\n");
        System.out.println("\"L\" \"GBA states\" \"\" \"GBA transitions\" \"\" \"BA states\" \"\" \"BA transitions\" \"\"");
        System.out.flush();
        int L = Lmin;
        while (L <= Lmax) {
            FormulaSource formulae = new FormulaSource(L, N, P, rand);
            int i = 0;
            double[] baStates = new double[F];
            double[] baTrans = new double[F];
            double[] gbaStates = new double[F];
            double[] gbaTrans = new double[F];
            long[] autTime = new long[F];
            long[] buTime = new long[F];
            long time = 0L;
            for (Formula<Integer> f : formulae) {
                if (i >= F) break;
                if (optimise) {
                    f = new Rewriter<Integer>(f).rewrite();
                }
                Translator.setAlgorithm(Translator.Algorithm.LTL2AUT);
                if (haveCpuTime) {
                    time = tb.getCurrentThreadCpuTime();
                }
                Graph<Integer> gbaAut = Translator.translate(f);
                if (haveCpuTime) {
                    autTime[i] = tb.getCurrentThreadCpuTime() - time;
                }
                if (optimise) {
                    gbaAut = SuperSetReduction.reduce(gbaAut);
                }
                Graph<Integer> baAut = Degeneralize.degeneralize(gbaAut);
                if (optimise) {
                    baAut = SFSReduction.reduce(Simplify.simplify(SCCReduction.reduce(baAut)));
                }
                if (baAut.getNodeCount() == 0 || baAut.getEdgeCount() == 0) {
                    Formula.resetStatic();
                    continue;
                }
                assert (gbaAut.getNodeCount() > 0 && gbaAut.getEdgeCount() > 0);
                Translator.setAlgorithm(Translator.Algorithm.LTL2BUCHI);
                if (haveCpuTime) {
                    time = tb.getCurrentThreadCpuTime();
                }
                Graph<Integer> gbaBu = Translator.translate(f);
                if (haveCpuTime) {
                    buTime[i] = tb.getCurrentThreadCpuTime() - time;
                }
                if (optimise) {
                    gbaBu = SuperSetReduction.reduce(gbaBu);
                }
                Graph<Integer> baBu = Degeneralize.degeneralize(gbaBu);
                if (optimise) {
                    baBu = SFSReduction.reduce(Simplify.simplify(SCCReduction.reduce(baBu)));
                }
                gbaStates[i] = (double)gbaBu.getNodeCount() / (double)gbaAut.getNodeCount();
                gbaTrans[i] = (double)gbaBu.getEdgeCount() / (double)gbaAut.getEdgeCount();
                baStates[i] = (double)baBu.getNodeCount() / (double)baAut.getNodeCount();
                baTrans[i] = (double)baBu.getEdgeCount() / (double)baAut.getEdgeCount();
                Formula.resetStatic();
                ++i;
            }
            RandomFormulae.output(L, gbaStates, gbaTrans, baStates, baTrans, autTime, buTime);
            L += Linc;
        }
    }

    private static void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-N")) {
                if (i + 1 >= args.length) {
                    RandomFormulae.usage();
                }
                try {
                    N = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    RandomFormulae.usage();
                }
                if (N < 1) {
                    RandomFormulae.usage();
                }
                ++i;
            } else if (args[i].equals("-L")) {
                if (i + 3 >= args.length) {
                    RandomFormulae.usage();
                }
                try {
                    Lmin = Integer.parseInt(args[i + 1]);
                    Lmax = Integer.parseInt(args[i + 2]);
                    Linc = Integer.parseInt(args[i + 3]);
                }
                catch (NumberFormatException e) {
                    RandomFormulae.usage();
                }
                if (Lmin < 1 || Lmax < 1 || Lmax < Lmin || Linc < 1) {
                    RandomFormulae.usage();
                }
                i += 3;
            } else if (args[i].equals("-F")) {
                if (i + 1 >= args.length) {
                    RandomFormulae.usage();
                }
                try {
                    F = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    RandomFormulae.usage();
                }
                ++i;
            } else if (args[i].equals("-P")) {
                if (i + 1 >= args.length) {
                    RandomFormulae.usage();
                }
                try {
                    P = Double.parseDouble(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    RandomFormulae.usage();
                }
                if (P < 0.0 || P > 1.0) {
                    RandomFormulae.usage();
                }
                Pstr = args[i + 1];
                ++i;
            } else if (args[i].equals("-seed")) {
                if (i + 1 >= args.length) {
                    RandomFormulae.usage();
                }
                try {
                    seed = Long.parseLong(args[i + 1]);
                    haveSeed = true;
                }
                catch (NumberFormatException e) {
                    RandomFormulae.usage();
                }
                ++i;
            } else if (args[i].equals("-optimise")) {
                optimise = true;
            } else if (args[i].equals("-verbose")) {
                verbose = true;
            } else {
                RandomFormulae.usage();
            }
            ++i;
        }
    }

    private static void usage() {
        System.err.println("usage: gov.nasa.ltl.tests.RandomFormulae [-N n] [-L min max inc] [-F f] [-P p] [-seed s] [-optimise] [-verbose]");
        System.err.flush();
        System.exit(1);
    }

    private static void verbose(String msg) {
        if (verbose) {
            System.err.println("# " + msg.replaceAll("\n", "\n# "));
        }
    }

    private static void output(int L, double[] gbaStates, double[] gbaTrans, double[] baStates, double[] baTrans, long[] autTime, long[] buTime) {
        double gbaStatesM = RandomFormulae.mean(gbaStates);
        double gbaTransM = RandomFormulae.mean(gbaTrans);
        double baStatesM = RandomFormulae.mean(baStates);
        double baTransM = RandomFormulae.mean(baTrans);
        double gbaStatesD = RandomFormulae.sigma(gbaStates, gbaStatesM);
        double gbaTransD = RandomFormulae.sigma(gbaTrans, gbaTransM);
        double baStatesD = RandomFormulae.sigma(baStates, baStatesM);
        double baTransD = RandomFormulae.sigma(baTrans, baTransM);
        double autM = RandomFormulae.mean(autTime);
        double buM = RandomFormulae.mean(buTime);
        if (haveCpuTime) {
            RandomFormulae.verbose("L = " + L + " average LTL2AUT time = " + autM / 1000000.0 + " ms, average LTL2Buchi time = " + buM / 1000000.0 + " ms");
        }
        System.out.println(L + " " + gbaStatesM + " " + gbaStatesD + " " + gbaTransM + " " + gbaTransD + " " + baStatesM + " " + baStatesD + " " + baTransM + " " + baTransD);
        System.out.flush();
    }

    private static double mean(double[] values) {
        double s = 0.0;
        int i = 0;
        while (i < values.length) {
            s += values[i];
            ++i;
        }
        return s / (double)values.length;
    }

    private static double mean(long[] values) {
        double s = 0.0;
        int i = 0;
        while (i < values.length) {
            s += (double)values[i];
            ++i;
        }
        return s / (double)values.length;
    }

    private static double sigma(double[] values, double mean) {
        double s = 0.0;
        int i = 0;
        while (i < values.length) {
            s += (values[i] - mean) * (values[i] - mean);
            ++i;
        }
        return Math.sqrt(s / (double)values.length);
    }

    private static class FormulaGenerator
    implements Iterator<Formula<Integer>> {
        private int length;
        private int names;
        private double pUorV;
        private Random rand;

        public FormulaGenerator(int length, int names, double pUorV, Random rand) {
            assert (0.0 <= pUorV && pUorV <= 1.0) : "bad probability for U or V";
            assert (length > 0) : "length must be positive";
            assert (names > 0) : "need at least one name";
            assert (rand != null) : "need a random number generator";
            this.length = length;
            this.names = names;
            this.pUorV = pUorV;
            this.rand = rand;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Formula<Integer> next() {
            return this.randomFormula(this.length);
        }

        private Formula<Integer> randomFormula(int length) {
            int name = 0;
            Formula<Integer> f = null;
            Formula<Integer> s1 = null;
            Formula<Integer> s2 = null;
            LTL2Buchi.debug = false;
            switch (length) {
                case 0: {
                    assert (false) : "formulae cannot have zero length";
                    return null;
                }
                case 1: {
                    name = this.rand.nextInt(this.names);
                    f = Formula.Proposition(name);
                    return f;
                }
                case 2: {
                    s1 = this.randomFormula(1);
                    if (this.rand.nextDouble() < 0.5) {
                        return Formula.Not(s1);
                    }
                    return Formula.Next(s1);
                }
            }
            int sublength = 1 + this.rand.nextInt(length - 2);
            if (this.rand.nextDouble() < this.pUorV) {
                s1 = this.randomFormula(sublength);
                s2 = this.randomFormula(length - sublength - 1);
                if (this.rand.nextDouble() < 0.5) {
                    f = Formula.Until(s1, s2);
                    return f;
                }
                f = Formula.Release(s1, s2);
                return f;
            }
            if (this.rand.nextDouble() < 0.5) {
                s1 = this.randomFormula(length - 1);
                if (this.rand.nextDouble() < 0.5) {
                    return Formula.Not(s1);
                }
                return Formula.Next(s1);
            }
            s1 = this.randomFormula(sublength);
            s2 = this.randomFormula(length - sublength - 1);
            if (this.rand.nextDouble() < 0.5) {
                f = Formula.And(s1, s2);
                return f;
            }
            f = Formula.Or(s1, s2);
            return f;
        }

        @Override
        public void remove() {
        }
    }

    public static class FormulaSource
    implements Iterable<Formula<Integer>> {
        private FormulaGenerator gen;

        public FormulaSource(int length, int names, double pUorV, Random rand) {
            this.gen = new FormulaGenerator(length, names, pUorV, rand);
        }

        @Override
        public Iterator<Formula<Integer>> iterator() {
            return this.gen;
        }
    }
}

