/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.trans.Transition;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeSet;

public class State<PropT> {
    private int representativeId = -1;
    private LinkedList<Transition<PropT>> transitions = new LinkedList();
    private BitSet accepting;
    private boolean safety_acceptance;

    State(BitSet acc) {
        this.accepting = acc;
        this.safety_acceptance = false;
    }

    State(BitSet acc, int equivId) {
        this.accepting = acc;
        this.safety_acceptance = false;
        this.representativeId = equivId;
    }

    State() {
        this.accepting = null;
        this.safety_acceptance = false;
    }

    State(int equivId) {
        this.accepting = null;
        this.safety_acceptance = false;
        this.representativeId = equivId;
    }

    public void SMoutput(Node<PropT>[] nodes, Node<PropT> node) {
        for (Transition transition : this.transitions) {
            transition.SMoutput(nodes, node);
        }
    }

    public boolean accepts(int i) {
        return !this.accepting.get(i);
    }

    void add(Transition<PropT> trans) {
        this.transitions.add(trans);
    }

    public int getRepresentativeId() {
        return this.representativeId;
    }

    public boolean isSafe() {
        return this.safety_acceptance;
    }

    void setRepresentativeId(int id) {
        this.representativeId = id;
    }

    public void step(Hashtable<PropT, Boolean> programState, TreeSet<State<PropT>> newStates, State<PropT>[] automaton) {
        for (Transition transition : this.transitions) {
            if (!transition.enabled(programState)) continue;
            newStates.add(automaton[transition.goesTo()]);
        }
    }

    void updateAcc(BitSet acc) {
        this.accepting = acc;
    }

    void updateAcc(BitSet acc, int equivId) {
        this.accepting = acc;
        this.representativeId = equivId;
    }

    void updateSafetyAcc(boolean val) {
        this.safety_acceptance = val;
    }

    public LinkedList<Transition<PropT>> getTransitions() {
        return this.transitions;
    }
}

