/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.jdraggable;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.util.HashSet;
import java.util.Set;
import net.java.swingfx.jdraggable.DragPolicy;
import net.java.swingfx.jdraggable.Draggable;
import net.java.swingfx.jdraggable.DraggableListener;
import net.java.swingfx.jdraggable.DraggableManager;
import net.java.swingfx.jdraggable.DraggableMask;

public class DefaultDraggableManager
implements DraggableManager {
    private Container draggableContainer;
    private boolean draggableContainerRegistered;
    private Draggable hitDraggable;
    private byte draggableState;
    private DragPolicy dragPolicy;
    private DraggableListener dragListener;
    private Set hearingComponents;
    private boolean nullifyLayout = true;

    public DefaultDraggableManager() {
    }

    public DefaultDraggableManager(Container draggableContainer) {
        if (draggableContainer == null) {
            throw new IllegalArgumentException("Can not register a null Draggable Container");
        }
        this.registerDraggableContainer(draggableContainer);
    }

    @Override
    public void setNullifyLayout(boolean nullifyLayout) {
        this.nullifyLayout = nullifyLayout;
    }

    @Override
    public boolean shouldNullifyLayout() {
        return this.nullifyLayout;
    }

    @Override
    public boolean startDrag(Component componentToDrag) {
        if (this.isDraggableContainerRegistered() && this.getDragPolicy().isDraggable(componentToDrag)) {
            this.hitDraggable = componentToDrag instanceof Draggable ? (Draggable)((Object)componentToDrag) : new DraggableMask(componentToDrag);
            this.setState((byte)2);
            return true;
        }
        return false;
    }

    @Override
    public boolean dragging() {
        if (this.isDraggableContainerRegistered() && this.hitDraggable != null) {
            this.setState((byte)4);
            return true;
        }
        return false;
    }

    @Override
    public boolean stopDrag() {
        if (this.isDraggableContainerRegistered()) {
            this.hitDraggable = null;
            this.setState((byte)1);
            return true;
        }
        return false;
    }

    @Override
    public Container getDraggableContainer() {
        return this.draggableContainer;
    }

    private boolean isDraggableContainerRegistered() {
        return this.draggableContainerRegistered;
    }

    private void setState(byte state) {
        this.draggableState = state;
    }

    @Override
    public byte getState(Draggable draggableComponent) {
        return this.draggableState;
    }

    @Override
    public void registerDraggableContainer(Container draggableContainer) {
        if (this.draggableContainer != null) {
            throw new IllegalArgumentException("A Draggable Container has already been registered");
        }
        this.draggableContainer = draggableContainer;
        draggableContainer.addContainerListener(this);
        this.dragListener = new DraggableListener(this);
        this.hearingComponents = new HashSet();
        this.draggableContainerRegistered = true;
    }

    @Override
    public void unregisterDraggableContainer(Container draggableContainer) {
        if (this.draggableContainer == null) {
            throw new IllegalStateException("Failed to unregister draggable container, since no draggable container was registered");
        }
        if (!this.draggableContainer.equals(draggableContainer)) {
            throw new IllegalArgumentException("Failed to unregister draggable container, the given Container is not the same as the register draggable container");
        }
        this.draggableContainer.removeContainerListener(this);
        this.cleanupHearingComponents();
        this.dragListener = null;
        this.draggableContainer = null;
        this.draggableContainerRegistered = false;
    }

    private void cleanupHearingComponents() {
        int count = this.draggableContainer.getComponentCount();
        int i = count - 1;
        while (i >= 0 && this.hearingComponents.size() > 0) {
            Component c = this.draggableContainer.getComponent(i);
            Integer code = new Integer(c.hashCode());
            if (c != null && this.hearingComponents.contains(code)) {
                this.hearingComponents.remove(code);
            }
            --i;
        }
    }

    @Override
    public DragPolicy getDragPolicy() {
        if (this.dragPolicy == null) {
            this.setDragPolicy(DragPolicy.DEFAULT);
        }
        return this.dragPolicy;
    }

    @Override
    public void setDragPolicy(DragPolicy dragPolicy) {
        this.dragPolicy = dragPolicy;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (this.dragListener == null || !this.isDraggableContainerRegistered()) {
            throw new IllegalStateException("Draggable Container must be registered prior to adding components");
        }
        Component c = e.getChild();
        Integer code = new Integer(c.hashCode());
        if (!this.hearingComponents.contains(code)) {
            this.hearingComponents.add(code);
            c.addMouseListener(this.dragListener);
            c.addMouseMotionListener(this.dragListener);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component c = e.getChild();
        Integer code = new Integer(c.hashCode());
        if (this.hearingComponents.contains(code)) {
            this.hearingComponents.remove(code);
        }
    }
}

