/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.rubberband;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import net.java.swingfx.rubberband.canvas.RubberBandCanvas;

public class AnimatedStroke {
    private static final int DASH_WIDTH = 3;
    private static final int STROKE_COUNT = 6;
    private static final int DASH_SPEED = 50;
    private int strokeIndex;
    private final Stroke[] strokes;
    private final Timer animationTimer;
    private RubberBandCanvas canvas;

    public AnimatedStroke(RubberBandCanvas canvas) {
        this.canvas = canvas;
        this.animationTimer = new Timer(50, this.getAnimationActionListener());
        this.strokes = new Stroke[6];
        this.initStrokes();
    }

    private void initStrokes() {
        float[] dash = new float[]{3.0f, 3.0f};
        int i = 0;
        while (i < 6) {
            this.strokes[i] = new BasicStroke(1.0f, 0, 0, 1.0f, dash, i);
            ++i;
        }
    }

    public Stroke getStroke() {
        return this.strokes[this.strokeIndex];
    }

    public void startAnimation() {
        this.animationTimer.start();
    }

    public void stopAnimation() {
        this.animationTimer.stop();
    }

    private ActionListener getAnimationActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimatedStroke animatedStroke = AnimatedStroke.this;
                animatedStroke.strokeIndex = animatedStroke.strokeIndex + 1;
                AnimatedStroke animatedStroke2 = AnimatedStroke.this;
                animatedStroke2.strokeIndex = animatedStroke2.strokeIndex % 6;
                AnimatedStroke.this.canvas.getCanvas().repaint();
            }
        };
    }
}

