/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.waitwithstyle;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.java.swingfx.common.Utils;

public class AnimatedPanel
extends JPanel {
    private static final long serialVersionUID = 3257288036894324529L;
    protected float gradient;
    protected String message;
    protected Thread animator;
    protected BufferedImage convolvedImage;
    protected BufferedImage originalImage;
    protected static AlphaComposite composite = AlphaComposite.getInstance(3);
    protected RenderingHints brightnessHints;

    public AnimatedPanel(String message, ImageIcon icon) {
        this.validateMessage(message);
        if (icon == null) {
            throw new IllegalArgumentException("Icon can not be null.");
        }
        this.message = message;
        Image image = icon.getImage();
        this.originalImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        this.convolvedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = this.originalImage.createGraphics();
        g.drawImage(image, 0, 0, this);
        g.dispose();
        this.brightnessHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.setBrightness(1.0f);
        this.setOpaque(false);
    }

    private void validateMessage(String msg) throws IllegalArgumentException {
        if (Utils.isNullOrEmpty(msg)) {
            throw new IllegalArgumentException("Invalid message.  Message can not be null or empty.");
        }
    }

    public void setText(String text) {
        this.validateMessage(text);
        this.message = text;
        this.repaint();
    }

    public String getText() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.convolvedImage != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            BufferedImage bufferedImage = this.convolvedImage;
            synchronized (bufferedImage) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                FontRenderContext context = g2.getFontRenderContext();
                TextLayout layout = new TextLayout(this.message, this.getFont(), context);
                Rectangle2D bounds = layout.getBounds();
                int x = (width - this.convolvedImage.getWidth(null)) / 2;
                int y = (int)((double)height - ((double)this.convolvedImage.getHeight(null) + bounds.getHeight() + (double)layout.getAscent())) / 2;
                g2.drawImage((Image)this.convolvedImage, x, y, this);
                Color foreground = this.getForeground();
                g2.setColor(new Color(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), (int)(this.gradient * 255.0f)));
                layout.draw(g2, (float)((double)width - bounds.getWidth()) / 2.0f, (float)((double)(y + this.convolvedImage.getHeight(null)) + bounds.getHeight() + (double)layout.getAscent()));
            }
        }
    }

    private void setBrightness(float multiple) {
        float[] brightKernel = new float[]{multiple};
        ConvolveOp bright = new ConvolveOp(new Kernel(1, 1, brightKernel), 1, this.brightnessHints);
        bright.filter(this.originalImage, this.convolvedImage);
        this.repaint();
    }

    private void setGradientFactor(float gradient) {
        this.gradient = gradient;
    }

    public void start() {
        this.animator = new Thread((Runnable)new HighlightCycler(), "Highlighter");
        this.animator.start();
    }

    public void stop() {
        if (this.animator != null) {
            this.animator.interrupt();
        }
        this.animator = null;
    }

    class HighlightCycler
    implements Runnable {
        private int way = 1;
        private final int LOWER_BOUND = 10;
        private final int UPPER_BOUND = 35;
        private int value = 10;

        HighlightCycler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException e) {
                    return;
                }
                this.value += this.way;
                if (this.value > 35) {
                    this.value = 35;
                    this.way = -1;
                } else if (this.value < 10) {
                    this.value = 10;
                    this.way = 1;
                }
                BufferedImage bufferedImage = AnimatedPanel.this.convolvedImage;
                synchronized (bufferedImage) {
                    AnimatedPanel.this.setBrightness((float)this.value / 10.0f);
                    AnimatedPanel.this.setGradientFactor((float)this.value / 35.0f);
                }
            }
        }
    }
}

