/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.swing.ATEEditorKit;
import org.antlr.works.ate.swing.ATEKeyBindings;
import org.antlr.works.ate.swing.ATERenderingView;
import org.antlr.xjlib.appkit.undo.XJUndo;

public class ATETextPane
extends JTextPane {
    public static final String ATTRIBUTE_CHARACTER_FOLDING_PROXY = "char_folding_proxy";
    public static final String ATTRIBUTE_PARAGRAPH_FOLDING_PROXY = "para_folding_proxy";
    protected ATEPanel textEditor;
    protected ATEKeyBindings keyBindings;
    private boolean writable = true;
    protected boolean wrap = false;
    protected boolean highlightCursorLine = false;
    private int destinationCursorPosition = -1;

    public ATETextPane(ATEPanel textEditor, StyledEditorKit editorKit) {
        super(new DefaultStyledDocument());
        this.setCaret(new ATECaret());
        this.setEditorKit(editorKit == null ? new ATEEditorKit(textEditor) : editorKit);
        this.textEditor = textEditor;
    }

    public void close() {
        this.setCaret(new DefaultCaret());
        this.textEditor = null;
    }

    public ATEKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    public void setKeyBindings(ATEKeyBindings keyBindings) {
        this.keyBindings = keyBindings;
    }

    public void setWritable(boolean flag) {
        this.setEditable(flag);
        this.writable = flag;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWordWrap(boolean flag) {
        this.wrap = flag;
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public void setHighlightCursorLine(boolean flag) {
        this.highlightCursorLine = flag;
    }

    public boolean highlightCursorLine() {
        return this.highlightCursorLine;
    }

    public void setFont(Font f) {
        super.setFont(f);
        ATERenderingView.DEFAULT_FONT = f;
    }

    public void setTabSize(int size) {
        this.getDocument().putProperty("tabSize", size);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container parent = this.getParent();
            return parent == null || this.getUI().getPreferredSize((JComponent)this).width < parent.getSize().width;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.wrap) {
            Dimension size = this.getPreferredSize();
            super.setBounds(x, y, Math.max(size.width, width), Math.max(size.height, height));
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintDestinationCursor(g);
        this.textEditor.textPaneDidPaint(g);
    }

    private void paintDestinationCursor(Graphics g) {
        if (this.destinationCursorPosition < 0) {
            return;
        }
        try {
            Rectangle r = this.modelToView(this.destinationCursorPosition);
            g.setColor(Color.black);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void printPaint(Graphics g) {
        boolean flag = this.highlightCursorLine();
        this.setHighlightCursorLine(false);
        boolean caretVisible = this.getCaret().isVisible();
        this.getCaret().setVisible(false);
        this.paint(g);
        this.getCaret().setVisible(caretVisible);
        this.setHighlightCursorLine(flag);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.writable) {
            if (keyEvent.getKeyCode() == 9 && keyEvent.getID() == 401) {
                int stop;
                int start = this.getSelectionStart();
                if (start != (stop = this.getSelectionEnd())) {
                    try {
                        this.indentText(start, stop, keyEvent.isShiftDown() ? -1 : 1);
                        keyEvent.consume();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else {
                    super.processKeyEvent(keyEvent);
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void indentText(int start, int stop, int direction) throws BadLocationException {
        String text = this.getText();
        int begin = this.findBeginningLineBoundary(start);
        int end = this.findEndLineBoundary(stop);
        if (stop == this.findBeginningLineBoundary(stop)) {
            end = this.findEndLineBoundary(stop - 1);
        }
        StringBuilder modifiedPortion = new StringBuilder();
        int selectionStart = start;
        int selectionEnd = stop;
        boolean modified = false;
        boolean beginLine = true;
        boolean firstLine = true;
        for (int i = begin; i < end; ++i) {
            char c = text.charAt(i);
            if (beginLine) {
                boolean ignoreChars;
                beginLine = false;
                boolean bl = ignoreChars = c == '\t' || c == ' ';
                if (!ignoreChars) {
                    beginLine = false;
                }
                if (ignoreChars && direction == -1) {
                    if (firstLine && i < start) {
                        --selectionStart;
                    }
                    --selectionEnd;
                    firstLine = false;
                    modified = true;
                    continue;
                }
                if (direction > 0) {
                    if (firstLine && i <= start) {
                        ++selectionStart;
                    }
                    ++selectionEnd;
                    firstLine = false;
                    modifiedPortion.append('\t');
                    modified = true;
                }
            } else if (c == '\n') {
                beginLine = true;
            }
            modifiedPortion.append(text.charAt(i));
        }
        if (!modified) {
            return;
        }
        StringBuilder modifiedText = new StringBuilder(text);
        modifiedText.replace(begin, end, modifiedPortion.toString());
        this.textEditor.disableUndo();
        XJUndo undo = this.textEditor.getTextPaneUndo();
        undo.addEditEvent(new UndoableRefactoringEdit(text, modifiedText.toString()));
        this.setText(modifiedText.toString());
        this.textEditor.enableUndo();
        this.getCaret().setDot(selectionStart);
        this.getCaret().moveDot(selectionEnd);
    }

    public int findBeginningLineBoundary(int pos) {
        int index;
        String s = this.getText();
        for (index = pos - 1; index >= 0 && s.charAt(index) != '\n'; --index) {
        }
        return index + 1;
    }

    public int findEndLineBoundary(int pos) {
        int index;
        String s = this.getText();
        for (index = pos; index < s.length() && s.charAt(index) != '\n'; ++index) {
        }
        return index + 1;
    }

    public int findPrevWordBoundary(int pos) {
        int index;
        String s = this.getText();
        for (index = pos - 1; index >= 0 && this.isWordChar(s.charAt(index)); --index) {
        }
        return index + 1;
    }

    public int findNextWordBoundary(int pos) {
        int index;
        String s = this.getText();
        for (index = pos; index < s.length() && this.isWordChar(s.charAt(index)); ++index) {
        }
        return index;
    }

    public boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    protected class ATECaret
    extends DefaultCaret {
        public boolean selectingWord = false;
        public boolean selectingLine = false;
        public boolean draggingWord = false;
        public boolean draggingLine = false;
        public boolean startedDragging = false;
        public int mouseDraggingOffset;
        public int selectionMovingLineBegin;
        public int selectionMovingLineEnd;
        public int selectionAnchorLineBegin;
        public int selectionAnchorLineEnd;
        public int selectionStart;
        public int selectionEnd;
        public int dragDropCursorPosition = 0;

        public ATECaret() {
            this.setBlinkRate(500);
        }

        public void paint(Graphics g) {
            if (!this.isVisible()) {
                return;
            }
            try {
                Rectangle r = ATETextPane.this.modelToView(this.getDot());
                g.setColor(ATETextPane.this.getCaretColor());
                g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                g.drawLine(r.x + 1, r.y, r.x + 1, r.y + r.height - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected synchronized void damage(Rectangle r) {
            if (r == null) {
                return;
            }
            this.x = r.x;
            this.y = r.y;
            this.width = 2;
            this.height = r.height;
            this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2 || !SwingUtilities.isLeftMouseButton(e)) {
                super.mouseClicked(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!ATETextPane.this.isWritable() || e.getButton() != 1) {
                super.mousePressed(e);
                return;
            }
            this.draggingWord = false;
            this.draggingLine = false;
            this.selectingWord = false;
            this.selectingLine = false;
            this.startedDragging = false;
            if (e.getClickCount() % 2 == 0) {
                this.selectWord();
                this.selectingWord = true;
                this.selectionStart = ATETextPane.this.getSelectionStart();
                this.selectionEnd = ATETextPane.this.getSelectionEnd();
                ATETextPane.this.setDragEnabled(false);
                e.consume();
                return;
            }
            if (e.getClickCount() % 3 == 0) {
                this.selectLine();
                this.selectingLine = true;
                this.selectionStart = ATETextPane.this.getSelectionStart();
                this.selectionEnd = ATETextPane.this.getSelectionEnd();
                this.selectionMovingLineBegin = this.selectionStart;
                this.selectionAnchorLineBegin = this.selectionStart;
                this.selectionMovingLineEnd = this.selectionEnd;
                this.selectionAnchorLineEnd = this.selectionEnd;
                ATETextPane.this.setDragEnabled(false);
                e.consume();
                return;
            }
            this.selectionStart = ATETextPane.this.getSelectionStart();
            this.selectionEnd = ATETextPane.this.getSelectionEnd();
            int mouseCharIndex = ATETextPane.this.viewToModel(e.getPoint());
            if (this.selectionStart != this.selectionEnd && e.getClickCount() == 1 && mouseCharIndex >= this.selectionStart && mouseCharIndex <= this.selectionEnd) {
                String s = ATETextPane.this.getText();
                if ((this.selectionStart == 0 || s.charAt(this.selectionStart - 1) == '\n') && s.charAt(this.selectionEnd - 1) == '\n') {
                    this.draggingLine = true;
                } else {
                    this.draggingWord = true;
                }
                this.mouseDraggingOffset = mouseCharIndex - this.selectionStart;
            }
            if (!this.draggingWord && !this.draggingLine) {
                super.mousePressed(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!ATETextPane.this.isWritable() || e.getButton() != 1) {
                super.mouseReleased(e);
                return;
            }
            if (this.draggingWord || this.draggingLine) {
                this.endDestinationCursor();
                super.mousePressed(e);
            }
            if (this.startedDragging) {
                super.mousePressed(e);
            }
            if (this.draggingWord) {
                this.moveSelectionWord(e);
            } else if (this.draggingLine) {
                this.moveSelectionLine(e);
            }
            super.mouseReleased(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!ATETextPane.this.isWritable() || e.getButton() != 1) {
                super.mouseDragged(e);
                return;
            }
            if (this.draggingWord || this.draggingLine) {
                this.dragDropCursorPosition = ATETextPane.this.viewToModel(e.getPoint());
                if (!this.startedDragging) {
                    this.startedDragging = true;
                    this.beginDestinationCursor();
                }
            }
            if (this.selectingWord) {
                this.extendSelectionWord(e);
                ATETextPane.this.repaint();
            } else if (this.selectingLine) {
                this.extendSelectionLine(e);
            } else if (this.draggingWord) {
                this.setDestinationCursorPosition(ATETextPane.this.viewToModel(e.getPoint()));
            } else if (this.draggingLine) {
                int mouseCharIndex = ATETextPane.this.viewToModel(e.getPoint());
                int lineBegin = ATETextPane.this.findBeginningLineBoundary(mouseCharIndex);
                this.setDestinationCursorPosition(lineBegin);
            } else {
                super.mouseDragged(e);
            }
            ATETextPane.this.repaint();
        }

        private void setDestinationCursorPosition(int pos) {
            ATETextPane.this.destinationCursorPosition = pos;
            if (ATETextPane.this.destinationCursorPosition != -1) {
                try {
                    ATETextPane.this.scrollRectToVisible(ATETextPane.this.modelToView(pos));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ATETextPane.this.repaint();
        }

        private void beginDestinationCursor() {
            ATETextPane.this.setDragEnabled(false);
            this.setVisible(false);
        }

        private void endDestinationCursor() {
            ATETextPane.this.setDragEnabled(true);
            this.setVisible(true);
            this.setDestinationCursorPosition(-1);
        }

        private void moveSelectionLine(MouseEvent e) {
            int mouseCharIndex = ATETextPane.this.viewToModel(e.getPoint());
            StyledDocument doc = ATETextPane.this.getStyledDocument();
            ATETextPane.this.textEditor.getTextPaneUndo().beginUndoGroup("moveSelectionLine");
            try {
                if (mouseCharIndex > this.selectionEnd) {
                    int moveTo = ATETextPane.this.findBeginningLineBoundary(mouseCharIndex);
                    int offset = moveTo - this.selectionEnd;
                    String s = doc.getText(this.selectionEnd, offset);
                    doc.remove(this.selectionEnd, offset);
                    doc.insertString(this.selectionStart, s, null);
                    this.selectionEnd += offset;
                    this.selectionStart += offset;
                } else if (mouseCharIndex < this.selectionStart) {
                    int moveFrom = Math.max(0, ATETextPane.this.findBeginningLineBoundary(mouseCharIndex));
                    int offset = this.selectionStart - moveFrom;
                    String s = doc.getText(moveFrom, offset);
                    doc.insertString(this.selectionEnd, s, null);
                    doc.remove(moveFrom, offset);
                    this.selectionEnd -= offset;
                    this.selectionStart -= offset;
                }
            }
            catch (BadLocationException ex) {
                System.out.println(ex);
            }
            ATETextPane.this.textEditor.getTextPaneUndo().endUndoGroup();
        }

        private void moveSelectionWord(MouseEvent e) {
            int mouseCharIndex = ATETextPane.this.viewToModel(e.getPoint());
            StyledDocument doc = ATETextPane.this.getStyledDocument();
            ATETextPane.this.textEditor.getTextPaneUndo().beginUndoGroup("moveSelectionWord");
            try {
                if (mouseCharIndex > this.selectionEnd) {
                    int offset = mouseCharIndex - this.selectionEnd;
                    String s = doc.getText(this.selectionEnd, offset);
                    doc.remove(this.selectionEnd, offset);
                    doc.insertString(this.selectionStart, s, null);
                    this.selectionEnd += offset;
                    this.selectionStart += offset;
                } else if (mouseCharIndex < this.selectionStart) {
                    mouseCharIndex = Math.max(0, mouseCharIndex);
                    int offset = this.selectionStart - mouseCharIndex;
                    String s = doc.getText(mouseCharIndex, offset);
                    doc.insertString(this.selectionEnd, s, null);
                    doc.remove(mouseCharIndex, offset);
                    this.selectionEnd -= offset;
                    this.selectionStart -= offset;
                }
            }
            catch (BadLocationException ex) {
                System.out.println(ex);
            }
            ATETextPane.this.textEditor.getTextPaneUndo().endUndoGroup();
        }

        public void extendSelectionWord(MouseEvent e) {
            int mouseCharIndex = ATETextPane.this.viewToModel(e.getPoint());
            if (mouseCharIndex > this.selectionEnd) {
                int npos = ATETextPane.this.findNextWordBoundary(mouseCharIndex);
                if (npos > this.selectionEnd) {
                    ATETextPane.this.select(this.selectionStart, npos);
                }
            } else if (mouseCharIndex < this.selectionStart) {
                int npos = ATETextPane.this.findPrevWordBoundary(mouseCharIndex);
                if (npos < this.selectionStart) {
                    ATETextPane.this.select(Math.max(0, npos), this.selectionEnd);
                }
            } else {
                ATETextPane.this.select(this.selectionStart, this.selectionEnd);
            }
        }

        public void extendSelectionLine(MouseEvent e) {
            int mouseCharIndex = ATETextPane.this.viewToModel(e.getPoint());
            if (mouseCharIndex > this.selectionMovingLineEnd) {
                int npos = ATETextPane.this.findEndLineBoundary(mouseCharIndex);
                if (npos > this.selectionMovingLineEnd) {
                    this.selectionMovingLineEnd = npos;
                    this.selectionMovingLineBegin = ATETextPane.this.findBeginningLineBoundary(mouseCharIndex);
                    this.selectionStart = Math.min(this.selectionMovingLineBegin, this.selectionAnchorLineBegin);
                    this.selectionEnd = Math.max(this.selectionMovingLineEnd, this.selectionAnchorLineEnd);
                    ATETextPane.this.select(this.selectionStart, this.selectionEnd);
                }
            } else if (mouseCharIndex < this.selectionMovingLineBegin) {
                int npos = Math.max(0, ATETextPane.this.findBeginningLineBoundary(mouseCharIndex));
                if (npos < this.selectionMovingLineBegin) {
                    this.selectionMovingLineBegin = npos;
                    this.selectionMovingLineEnd = ATETextPane.this.findEndLineBoundary(mouseCharIndex);
                    this.selectionEnd = Math.max(this.selectionMovingLineEnd, this.selectionAnchorLineEnd);
                    this.selectionStart = Math.min(this.selectionMovingLineBegin, this.selectionAnchorLineBegin);
                    ATETextPane.this.select(this.selectionStart, this.selectionEnd);
                }
            } else {
                ATETextPane.this.select(this.selectionStart, this.selectionEnd);
            }
        }

        public void selectWord() {
            int p = ATETextPane.this.getCaretPosition();
            ATETextPane.this.setCaretPosition(ATETextPane.this.findPrevWordBoundary(p));
            ATETextPane.this.moveCaretPosition(ATETextPane.this.findNextWordBoundary(p));
        }

        public void selectLine() {
            int p = ATETextPane.this.getCaretPosition();
            ATETextPane.this.setCaretPosition(ATETextPane.this.findBeginningLineBoundary(p));
            ATETextPane.this.moveCaretPosition(ATETextPane.this.findEndLineBoundary(p));
        }
    }

    protected class UndoableRefactoringEdit
    extends AbstractUndoableEdit {
        public String oldContent;
        public String newContent;

        public UndoableRefactoringEdit(String oldContent, String newContent) {
            this.oldContent = oldContent;
            this.newContent = newContent;
        }

        public void redo() {
            super.redo();
            this.refactorReplaceEditorText(this.newContent);
        }

        public void undo() {
            super.undo();
            this.refactorReplaceEditorText(this.oldContent);
        }

        private void refactorReplaceEditorText(String text) {
            int old = ATETextPane.this.getCaretPosition();
            ATETextPane.this.textEditor.disableUndo();
            ATETextPane.this.setText(text);
            ATETextPane.this.textEditor.enableUndo();
            ATETextPane.this.setCaretPosition(Math.min(old, text.length()));
        }
    }
}

