/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.antlr.works.ate.gutter.ATEGutterColumnManager;
import org.antlr.works.ate.gutter.ATEGutterItem;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.utils.IconManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorGutterColumnManager
extends ATEGutterColumnManager {
    private final GrammarWindow window;
    private final Map<Integer, ATEGutterItem> breakpoints = new HashMap<Integer, ATEGutterItem>();
    private static final String RULES = "rules";
    private static final String BREAKPOINTS = "breakpoints";
    private static final int DEFAULT_NO_BREAKPOINTS_WIDTH = 5;

    public EditorGutterColumnManager(GrammarWindow window) {
        super(window.textEditor);
        this.window = window;
    }

    @Override
    public String[] getColumns() {
        return new String[]{RULES, BREAKPOINTS};
    }

    @Override
    public int getColumnWidth(String column) {
        int width = 0;
        if (column.equals(BREAKPOINTS) && this.breakpoints.isEmpty()) {
            width = 5;
        }
        List<ATEGutterItem> items = this.getGutterItems(column);
        for (ATEGutterItem item : items) {
            width = Math.max(width, item.getItemWidth());
        }
        return width;
    }

    @Override
    public boolean handleClickInColumn(String column, int rowTextIndex) {
        int line;
        if (column.equals(BREAKPOINTS) && !this.breakpoints.containsKey(line = this.window.getTextEditor().getLineIndexAtTextPosition(rowTextIndex))) {
            this.breakpoints.put(line, new BreakpointGutterItem(line));
            return true;
        }
        return false;
    }

    @Override
    public List<ATEGutterItem> getGutterItems(String column) {
        if (column.equals(RULES)) {
            ArrayList<ATEGutterItem> items = new ArrayList<ATEGutterItem>();
            List<ElementRule> rules = this.window.getGrammarEngine().getRules();
            if (rules != null) {
                for (ElementRule r : rules) {
                    items.add(r);
                }
            }
            return items;
        }
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(this.breakpoints.keySet());
        Collections.sort(sortedKeys);
        ArrayList<ATEGutterItem> sortedItems = new ArrayList<ATEGutterItem>();
        for (Integer k : sortedKeys) {
            sortedItems.add(this.breakpoints.get(k));
        }
        return sortedItems;
    }

    public Set<Integer> getBreakpoints() {
        HashSet<Integer> lines = new HashSet<Integer>();
        for (ATEGutterItem item : this.getGutterItems(BREAKPOINTS)) {
            lines.add(((BreakpointGutterItem)item).line);
        }
        return lines;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreakpointGutterItem
    implements ATEGutterItem {
        private int line;

        private BreakpointGutterItem(int line) {
            this.line = line;
        }

        @Override
        public int getItemIndex() {
            Point index = EditorGutterColumnManager.this.window.getTextEditor().getLineTextPositionsAtLineIndex(this.line);
            return index.x;
        }

        @Override
        public void setItemIndex(int index) {
        }

        @Override
        public List<Integer> getItemTypes() {
            return Arrays.asList(1);
        }

        @Override
        public int getItemWidth() {
            int width = 0;
            for (int type : this.getItemTypes()) {
                width += this.getItemIcon(type).getIconWidth();
            }
            return width;
        }

        @Override
        public int getItemHeight() {
            int height = 0;
            for (int type : this.getItemTypes()) {
                height = Math.max(height, this.getItemIcon(type).getIconHeight());
            }
            return height;
        }

        @Override
        public ImageIcon getItemIcon(int type) {
            return IconManager.shared().getIconBreakpoint();
        }

        @Override
        public String getItemTooltip(int type) {
            return "Breakpoint at line " + (this.line + 1);
        }

        @Override
        public void itemAction(int type) {
            EditorGutterColumnManager.this.breakpoints.remove(this.line);
        }
    }
}

