/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.antlr.works.ate.swing.ATERenderingToken;
import org.antlr.works.ate.swing.ATERenderingView;
import org.antlr.works.ate.swing.ATERenderingViewDelegate;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.element.Jumpable;

public class GrammarEditorKit
extends StyledEditorKit
implements ViewFactory,
ATERenderingViewDelegate {
    private GrammarWindow window;
    private final Set<ATERenderingView> views = new HashSet<ATERenderingView>();
    private final List<ATERenderingToken> indexes = new ArrayList<ATERenderingToken>();
    private ATERenderingToken[] cachedTokens;
    private boolean indexesModified = true;
    private final ATERenderingToken debuggerCursorToken = new DebuggerCursorToken();
    private final HighlightedReferenceStartToken highlightedReferenceStartToken = new HighlightedReferenceStartToken();
    private final HighlightedReferenceToken highlightedReferenceToken = new HighlightedReferenceToken();

    public GrammarEditorKit(GrammarWindow window) {
        this.window = window;
    }

    public void close() {
        for (ATERenderingView v : this.views) {
            v.close();
        }
        this.views.clear();
        this.window = null;
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public Document createDefaultDocument() {
        return new DefaultStyledDocument();
    }

    public View create(Element elem) {
        ATERenderingView v = new ATERenderingView(elem, this.window.getTextEditor());
        v.setDelegate(this);
        this.views.add(v);
        return v;
    }

    private void addToken(ATERenderingToken token) {
        if (!this.indexes.contains(token)) {
            this.indexes.add(token);
            this.indexesModified = true;
        }
    }

    private void removeToken(ATERenderingToken token) {
        if (this.indexes.contains(token)) {
            this.indexes.remove(token);
            this.indexesModified = true;
        }
    }

    public ATERenderingToken[] getTokens() {
        this.indexesModified = false;
        Jumpable ref = this.window.getHighlightedReference();
        if (ref != null) {
            this.highlightedReferenceStartToken.setIndex(ref.getStartIndex());
            this.highlightedReferenceToken.setIndex(ref.getEndIndex());
            this.highlightedReferenceToken.setStartToken(this.highlightedReferenceStartToken);
            this.addToken(this.highlightedReferenceStartToken);
            this.addToken(this.highlightedReferenceToken);
        } else {
            this.removeToken(this.highlightedReferenceStartToken);
            this.removeToken(this.highlightedReferenceToken);
        }
        if (this.window.getDebuggerLocation() != -1) {
            this.addToken(this.debuggerCursorToken);
            this.debuggerCursorToken.setIndex(this.window.getDebuggerLocation());
        } else {
            this.removeToken(this.debuggerCursorToken);
        }
        if (this.indexesModified || this.cachedTokens == null) {
            Collections.sort(this.indexes);
            this.cachedTokens = this.indexes.toArray(new ATERenderingToken[this.indexes.size()]);
        }
        return this.cachedTokens;
    }

    private static class HighlightedReferenceToken
    extends ATERenderingToken {
        private HighlightedReferenceStartToken startToken;

        private HighlightedReferenceToken() {
        }

        public void setStartToken(HighlightedReferenceStartToken startToken) {
            this.startToken = startToken;
        }

        public void drawToken(ATERenderingView view, ATERenderingToken t, Graphics g, FontMetrics metrics, int x, int y, char c, Document doc, AttributeSet attribute, Segment text) throws BadLocationException {
            g.setColor(Color.blue);
            g.drawLine(this.startToken.getStartX(), y + 1, x, y + 1);
            doc.getText(this.startToken.getStartIndex(), t.getIndex() - this.startToken.getStartIndex(), text);
            Utilities.drawTabbedText(text, this.startToken.getStartX(), y, g, (TabExpander)view, this.startToken.getStartIndex());
        }
    }

    private static class HighlightedReferenceStartToken
    extends ATERenderingToken {
        private int startX;
        private int startIndex;

        private HighlightedReferenceStartToken() {
        }

        public void drawToken(ATERenderingView view, ATERenderingToken t, Graphics g, FontMetrics metrics, int x, int y, char c, Document doc, AttributeSet attribute, Segment text) {
            this.startX = x;
            this.startIndex = t.getIndex();
        }

        public int getStartX() {
            return this.startX;
        }

        public int getStartIndex() {
            return this.startIndex;
        }
    }

    private static class DebuggerCursorToken
    extends ATERenderingToken {
        private DebuggerCursorToken() {
        }

        public void drawToken(ATERenderingView view, ATERenderingToken t, Graphics g, FontMetrics metrics, int x, int y, char c, Document doc, AttributeSet attribute, Segment text) {
            g.setColor(Color.red);
            g.fillRect(x, y - metrics.getHeight() + metrics.getDescent(), metrics.charWidth(c), metrics.getHeight());
        }
    }
}

