/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.find;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.works.dialog.FindAndReplaceDialog;
import org.antlr.works.find.FindAndReplaceDelegate;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.frame.XJFrameDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class FindAndReplace
implements XJFrameDelegate {
    public static final String BEGIN_QUOTE = "\\Q";
    public static final String END_QUOTE = "\\E";
    public FindAndReplaceDelegate delegate;
    public String findString;
    public String replaceString;
    public int flags;
    public String prefix = "";
    public String suffix = "";
    public String prefixRegex = "\\Q";
    public String suffixRegex = "\\E";
    public FindAndReplaceDialog dialog;

    public FindAndReplace(FindAndReplaceDelegate delegate) {
        this.delegate = delegate;
    }

    public void find() {
        this.display();
    }

    public String getCompilableString() {
        return this.prefix + this.prefixRegex + this.findString + this.suffixRegex + this.suffix;
    }

    public Pattern getCompiledPattern() {
        Pattern p = null;
        try {
            p = Pattern.compile(this.getCompilableString(), this.flags);
        }
        catch (Exception e) {
            XJAlert.display(this.dialog.getJavaContainer(), "Regex Find", "Pattern error:\n" + e.toString());
        }
        return p;
    }

    public void setPositionToTop() {
        this.delegate.getTextPane().setSelectionStart(0);
        this.delegate.getTextPane().setSelectionEnd(0);
    }

    public void setPositionToBottom() {
        this.delegate.getTextPane().setSelectionStart(this.delegate.getText().length() - 1);
        this.delegate.getTextPane().setSelectionEnd(this.delegate.getText().length() - 1);
    }

    public boolean matching() {
        Pattern p = this.getCompiledPattern();
        if (p == null) {
            return false;
        }
        String text = this.delegate.getText();
        Matcher m = p.matcher(text);
        if (m.find(0)) {
            this.delegate.getTextEditor().selectTextRange(m.start(), m.end());
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.findString == null || this.findString.length() == 0) {
            return false;
        }
        int position = this.delegate.getTextPane().getSelectionEnd();
        String text = this.delegate.getText();
        Pattern p = this.getCompiledPattern();
        if (p == null) {
            return false;
        }
        Matcher m = p.matcher(text);
        if (m.find(position)) {
            this.delegate.getTextEditor().selectTextRange(m.start(), m.end());
            return true;
        }
        return false;
    }

    public boolean prev() {
        if (this.findString == null || this.findString.length() == 0) {
            return false;
        }
        int position = this.delegate.getTextPane().getSelectionStart();
        String text = this.delegate.getText();
        Pattern p = this.getCompiledPattern();
        if (p == null) {
            return false;
        }
        Matcher m = p.matcher(text.substring(0, position));
        int matchStart = 0;
        int matchEnd = 0;
        boolean matched = false;
        while (m.find(matchEnd)) {
            matchStart = m.start();
            matchEnd = m.end();
            matched = true;
        }
        if (matched) {
            this.delegate.getTextEditor().selectTextRange(matchStart, matchEnd);
            return true;
        }
        return false;
    }

    public void replace() {
        String t = this.delegate.getTextEditor().getSelectedText();
        if (t != null && t.length() > 0) {
            this.delegate.getTextEditor().replaceSelectedText(this.replaceString);
        }
    }

    public void replaceAll() {
        Pattern p = this.getCompiledPattern();
        if (p == null) {
            return;
        }
        Matcher m = p.matcher(this.delegate.getText());
        String s = m.replaceAll(this.replaceString);
        int oldCursorPosition = this.delegate.getTextEditor().getCaretPosition();
        this.delegate.setText(s);
        this.delegate.getTextEditor().setCaretPosition(oldCursorPosition, false, false);
    }

    public void display() {
        if (this.dialog == null) {
            this.dialog = new FindAndReplaceDialog(this);
        }
        this.dialog.setDelegate(this);
        this.dialog.setFindText(this.delegate.getTextEditor().getSelectedText());
        this.dialog.show();
    }

    public void setFindString(String string) {
        this.findString = string;
    }

    public void setReplaceString(String string) {
        this.replaceString = string;
    }

    public void setIgnoreCase(boolean ignore) {
        this.flags = ignore ? 2 : 0;
    }

    public void setRegex(boolean flag) {
        if (flag) {
            this.prefixRegex = "";
            this.suffixRegex = "";
        } else {
            this.prefixRegex = BEGIN_QUOTE;
            this.suffixRegex = END_QUOTE;
        }
    }

    public void setOptions(int options) {
        this.prefix = "";
        this.suffix = "";
        switch (options) {
            case 0: {
                break;
            }
            case 1: {
                this.prefix = "\\b";
                break;
            }
            case 2: {
                this.prefix = "\\b";
                this.suffix = "\\b";
                break;
            }
            case 3: {
                this.suffix = "\\b";
            }
        }
    }

    public void frameDidClose(XJFrame frame) {
        this.dialog = null;
    }
}

