/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.antlr.GrammarResult;

public class CheckGrammar
implements Runnable {
    private volatile CheckGrammarDelegate delegate;
    private volatile GrammarWindow window;
    private volatile boolean cancelled = false;

    public CheckGrammar(GrammarWindow window, CheckGrammarDelegate delegate) {
        this.window = window;
        this.delegate = delegate;
    }

    public void close() {
        this.window.hideProgress();
        this.window = null;
        this.delegate = null;
    }

    public void check() {
        new Thread(this).start();
    }

    public void cancel() {
        this.cancelled = true;
        this.window.getGrammarEngine().cancelAnalyze();
    }

    public void run() {
        GrammarResult result;
        this.window.getConsoleTab().setMode(1);
        this.delegate.checkGrammarDidBegin(this);
        try {
            result = this.window.getGrammarEngine().analyze();
        }
        catch (Exception e) {
            this.window.getConsoleTab().println(e);
            result = new GrammarResult(e);
        }
        if (!this.cancelled) {
            this.delegate.checkGrammarDidEnd(this, result);
        }
    }
}

