/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.tool.Grammar;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngineImpl;
import org.antlr.works.grammar.antlr.GrammarResult;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementGrammarName;
import org.antlr.works.grammar.element.ElementGroup;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.grammar.engine.GrammarEngineDelegate;
import org.antlr.works.grammar.engine.GrammarProperties;
import org.antlr.works.grammar.engine.GrammarPropertiesImpl;
import org.antlr.works.grammar.syntax.GrammarSyntaxEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarEngineImpl
implements GrammarEngine {
    private GrammarEngineDelegate delegate;
    private GrammarEngine parent;
    private final List<GrammarEngine> importedEngines = new ArrayList<GrammarEngine>();
    private final GrammarProperties properties = new GrammarPropertiesImpl();
    private final ANTLRGrammarEngine antlrEngine = new ANTLRGrammarEngineImpl();
    private final GrammarSyntaxEngine syntaxEngine = new GrammarSyntaxEngine();

    public GrammarEngineImpl(GrammarEngineDelegate delegate) {
        this.delegate = delegate;
        this.properties.setGrammarEngine(this);
        this.properties.setSyntaxEngine(this.syntaxEngine);
        this.properties.setAntlrEngine(this.antlrEngine);
        this.antlrEngine.setGrammarEngine(this);
    }

    @Override
    public void setParent(GrammarEngine parent) {
        this.parent = parent;
    }

    @Override
    public GrammarEngine getParent() {
        return this.parent;
    }

    @Override
    public GrammarEngine getRootEngine() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootEngine();
    }

    @Override
    public void close() {
        this.antlrEngine.close();
        this.syntaxEngine.close();
    }

    @Override
    public GrammarProperties getGrammarProperties() {
        return this.properties;
    }

    @Override
    public ANTLRGrammarEngine getANTLRGrammarEngine() {
        return this.antlrEngine;
    }

    @Override
    public GrammarSyntaxEngine getSyntaxEngine() {
        return this.syntaxEngine;
    }

    @Override
    public int getType() {
        return this.properties.getType();
    }

    @Override
    public ElementGrammarName getElementName() {
        return this.properties.getElementName();
    }

    @Override
    public String getGrammarName() {
        return this.properties.getName();
    }

    @Override
    public String getGrammarLanguage() {
        try {
            this.antlrEngine.createGrammars();
            Grammar g = this.antlrEngine.getParserGrammar();
            if (g == null) {
                g = this.antlrEngine.getLexerGrammar();
            }
            if (g != null) {
                return (String)g.getOption("language");
            }
        }
        catch (Exception e) {
            this.delegate.reportError(e);
        }
        return null;
    }

    @Override
    public List<ElementRule> getRules() {
        return this.properties.getRules();
    }

    @Override
    public ElementRule getRuleWithName(String name) {
        return this.properties.getRuleWithName(name);
    }

    @Override
    public List<ElementRule> getDuplicateRules() {
        return this.properties.getDuplicateRules();
    }

    @Override
    public ElementRule getRuleAtIndex(int index) {
        return this.properties.getRuleAtIndex(index);
    }

    @Override
    public List<String> getRuleNames() {
        return this.properties.getRuleNames();
    }

    @Override
    public List<ElementReference> getReferences() {
        return this.properties.getReferences();
    }

    @Override
    public List<ElementReference> getUndefinedReferences() {
        return this.properties.getUndefinedReferences();
    }

    @Override
    public List<ElementImport> getImports() {
        return this.properties.getImports();
    }

    @Override
    public List<ElementImport> getUndefinedImports() {
        ArrayList<ElementImport> undefinedImports = new ArrayList<ElementImport>();
        for (ElementImport i : this.getImports()) {
            if (this.isEngineExisting(i.getName())) continue;
            undefinedImports.add(i);
        }
        return undefinedImports;
    }

    private boolean isEngineExisting(String grammarName) {
        for (GrammarEngine e : this.importedEngines) {
            if (e.getGrammarName() == null || !e.getGrammarName().equals(grammarName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ElementAction> getActions() {
        return this.properties.getActions();
    }

    @Override
    public List<ElementGroup> getGroups() {
        return this.properties.getGroups();
    }

    @Override
    public List<ElementBlock> getBlocks() {
        return this.properties.getBlocks();
    }

    @Override
    public List<ATEToken> getDecls() {
        return this.properties.getDecls();
    }

    @Override
    public int getNumberOfLines() {
        return this.syntaxEngine.getMaxLines();
    }

    @Override
    public int getNumberOfRules() {
        return this.properties.getRules().size();
    }

    @Override
    public int getNumberOfErrors() {
        return this.properties.getNumberOfErrors();
    }

    @Override
    public String getTokenVocab() {
        return this.properties.getTokenVocab();
    }

    @Override
    public List<String> getAllGeneratedNames() throws Exception {
        return this.properties.getAllGeneratedNames();
    }

    private boolean hasSuffix() {
        return this.isCombinedGrammar();
    }

    private String getSuffix(int type) {
        if (this.hasSuffix()) {
            switch (type) {
                case 2: {
                    return "Lexer";
                }
                case 1: {
                    return "Parser";
                }
            }
        }
        return "";
    }

    @Override
    public String getGeneratedClassName(int type) throws Exception {
        String name = null;
        this.antlrEngine.createGrammars();
        if (type == 2) {
            Grammar g = this.antlrEngine.getLexerGrammar();
            if (g == null) {
                return null;
            }
            name = g.name + this.getSuffix(type);
        } else if (type == 1) {
            Grammar g = this.antlrEngine.getParserGrammar();
            if (g == null) {
                return null;
            }
            name = g.name + this.getSuffix(type);
        } else if (type == 3) {
            Grammar g = this.antlrEngine.getParserGrammar();
            if (g == null) {
                return null;
            }
            if (!this.isTreeParserGrammar()) {
                return null;
            }
            name = g.name + this.getSuffix(type);
        }
        return name;
    }

    @Override
    public int getFirstDeclarationPosition(String name) {
        return this.properties.getFirstDeclarationPosition(name);
    }

    @Override
    public List<String> getGrammarsOverriddenByRule(String name) {
        ArrayList<String> grammars = new ArrayList<String>();
        for (GrammarEngine child : this.importedEngines) {
            for (ATEToken decl : child.getDecls()) {
                if (!decl.getAttribute().equals(name)) continue;
                grammars.add(child.getGrammarName());
                break;
            }
            grammars.addAll(child.getGrammarsOverriddenByRule(name));
        }
        return grammars;
    }

    @Override
    public List<String> getGrammarsOverridingRule(String name) {
        ArrayList<String> grammars = new ArrayList<String>();
        if (this.parent != null) {
            for (ATEToken decl : this.parent.getDecls()) {
                if (!decl.getAttribute().equals(name)) continue;
                grammars.add(this.parent.getGrammarName());
                break;
            }
            grammars.addAll(this.parent.getGrammarsOverridingRule(name));
        }
        return grammars;
    }

    @Override
    public List<ATEToken> getTokens() {
        return this.syntaxEngine.getTokens();
    }

    @Override
    public void updateHierarchy(Map<String, GrammarEngine> engines, Set<GrammarEngine> alreadyVisitedEngines) {
        this.importedEngines.clear();
        for (ElementImport element : this.properties.getImports()) {
            GrammarEngine d = engines.get(element.getName());
            if (d == null || alreadyVisitedEngines.contains(d)) continue;
            alreadyVisitedEngines.add(d);
            if (this.parent != d) {
                d.setParent(this);
            }
            this.importedEngines.add(d);
            d.updateHierarchy(engines, alreadyVisitedEngines);
            alreadyVisitedEngines.remove(d);
        }
        this.resetRules();
    }

    @Override
    public GrammarResult analyze() throws Exception {
        return this.antlrEngine.analyze();
    }

    @Override
    public void cancelAnalyze() {
        this.antlrEngine.cancel();
    }

    @Override
    public void computeRuleErrors(ElementRule rule) {
        this.antlrEngine.computeRuleErrors(rule);
    }

    @Override
    public void parserCompleted() {
        this.properties.parserCompleted();
    }

    @Override
    public void updateAll() {
        this.properties.updateAll();
    }

    @Override
    public void markDirty() {
        this.antlrEngine.markDirty();
        if (this.parent != null) {
            this.parent.markDirty();
        }
    }

    @Override
    public void reset() {
        this.properties.reset();
    }

    @Override
    public boolean isCombinedGrammar() {
        return this.properties.isCombinedGrammar();
    }

    @Override
    public boolean isTreeParserGrammar() {
        return this.properties.isTreeParserGrammar();
    }

    @Override
    public void antlrGrammarEngineAnalyzeCompleted() {
        this.delegate.engineAnalyzeCompleted();
    }

    @Override
    public String getGrammarFileName() {
        return this.delegate.getGrammarFileName();
    }

    @Override
    public String getGrammarText() {
        return this.delegate.getGrammarText();
    }

    @Override
    public String getTokenVocabFile(String name) {
        return this.delegate.getTokenVocabFile(name);
    }

    @Override
    public Tool getANTLRTool() {
        return this.delegate.getANTLRTool();
    }

    @Override
    public void reportError(String error) {
        this.delegate.reportError(error);
    }

    @Override
    public void gotoToRule(String grammar, String name) {
        this.delegate.gotoToRule(grammar, name);
    }

    private void resetRules() {
        for (ElementRule r : this.properties.getRules()) {
            r.resetHierarchy();
        }
    }
}

