/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.graph;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.analysis.NFAState;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.path.GPath;
import org.antlr.works.visualization.graphics.path.GPathElement;
import org.antlr.works.visualization.graphics.path.GPathGroup;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.shape.GNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGraphGroup
extends GGraphAbstract {
    private final GDimension dimension = new GDimension();
    private final List<GGraph> graphs = new ArrayList<GGraph>();
    private final GPathGroup pathGroup = new GPathGroup();
    private int pathIndex;
    private boolean dimensionComputed = false;

    @Override
    public void setEnable(boolean flag) {
    }

    @Override
    public void setContext(GContext context) {
        super.setContext(context);
        for (GGraph graph : this.getGraphs()) {
            graph.setContext(context);
        }
        this.getPathGroup().setContext(context);
    }

    public void add(GGraph graph) {
        this.getGraphs().add(graph);
    }

    private void ensureDimension() {
        if (this.dimensionComputed) {
            return;
        }
        GDimension d = this.getDimension();
        for (int i = 0; i < this.graphs.size(); ++i) {
            GGraph graph = this.graphs.get(i);
            d.maxWidth(graph.getDimension().width);
            d.addUp(graph.getDimension().up);
            d.addDown(graph.getDimension().down);
            if (i <= 0) continue;
            d.addDown("L");
        }
        this.dimensionComputed = true;
    }

    @Override
    public float getHeight() {
        this.ensureDimension();
        return this.getDimension().getPixelHeight(this.context);
    }

    @Override
    public float getWidth() {
        this.ensureDimension();
        return this.getDimension().getPixelWidth(this.context);
    }

    public List<FATransition> getTransitionsMatchingSkippedStates(List<FATransition> candidates, List states) {
        ArrayList<Integer> statesNumbers = new ArrayList<Integer>();
        for (Object state : states) {
            statesNumbers.add(((NFAState)state).stateNumber);
        }
        ArrayList<FATransition> newCandidates = new ArrayList<FATransition>();
        for (FATransition t : candidates) {
            if (t.skippedStates == null || !t.skippedStates.containsAll(statesNumbers)) continue;
            newCandidates.add(t);
        }
        return newCandidates;
    }

    public FATransition getNodeTransitionToNextNonSkippedState(GNode node, List path) {
        if (node == null) {
            return null;
        }
        List<FATransition> candidateTransitions = new ArrayList<FATransition>(node.state.transitions);
        FATransition candidate = null;
        int start = this.getPathIndex();
        block4: while (this.getPathIndex() < path.size()) {
            candidateTransitions = this.getTransitionsMatchingSkippedStates(candidateTransitions, path.subList(start, this.getPathIndex() + 1));
            switch (candidateTransitions.size()) {
                case 0: {
                    break block4;
                }
                case 1: {
                    candidate = candidateTransitions.get(0);
                    break;
                }
                default: {
                    if (this.getPathIndex() + 1 >= path.size()) break;
                    NFAState nextPathState = (NFAState)path.get(this.getPathIndex() + 1);
                    for (FATransition t : candidateTransitions) {
                        if (t.target.stateNumber != nextPathState.stateNumber) continue;
                        this.pathIndex = this.getPathIndex() + 1;
                        return t;
                    }
                }
            }
            this.pathIndex = this.getPathIndex() + 1;
        }
        return candidate;
    }

    public void addNextElementInSameRule(List<GPathElement> elements, GNode node, GNode nextNode) {
        elements.add(GPathElement.createElement(node));
        FATransition t = node.state.getTransitionToStateNumber(nextNode.state.stateNumber);
        if (t == null) {
            t = nextNode.state.getTransitionToStateNumber(node.state.stateNumber);
            if (t == null) {
                elements.add(GPathElement.createLink(node, nextNode));
            } else {
                elements.add(GPathElement.createElement(nextNode.getLink(t)));
            }
        } else {
            elements.add(GPathElement.createElement(node.getLink(t)));
        }
    }

    public void addNextElementInOtherRule(List<GPathElement> elements, GNode node, GNode externalNode, GNode nextNode, NFAState nextState) {
        FATransition t;
        if (externalNode == null && node.state.getFirstTransition() != null) {
            t = node.state.getTransitionToExternalStateRule(nextState.enclosingRule.name);
            if (t == null) {
                System.err.println("[GGraphGroup] No transition to external state " + nextState.stateNumber + "[" + nextState.enclosingRule.name + "] - using first transition by default");
                t = node.state.getFirstTransition();
            }
            externalNode = this.findNodeForStateNumber(t.target.stateNumber);
        }
        if (externalNode == null) {
            elements.add(GPathElement.createElement(node));
            elements.add(GPathElement.createLink(node, nextNode));
        } else {
            elements.add(GPathElement.createElement(node));
            t = node.state.getTransitionToStateNumber(externalNode.state.stateNumber);
            elements.add(GPathElement.createElement(node.getLink(t)));
            elements.add(GPathElement.createElement(externalNode));
            elements.add(GPathElement.createLink(externalNode, nextNode));
        }
    }

    public void addPath(List path, boolean disabled, Map<Integer, FAState> skippedStates) {
        ArrayList<GPathElement> elements = new ArrayList<GPathElement>();
        NFAState nextState = null;
        GNode nextNode = null;
        this.pathIndex = 0;
        while (this.getPathIndex() < path.size()) {
            block12: {
                GNode externalNode;
                GNode node;
                NFAState state;
                block13: {
                    FATransition t;
                    block14: {
                        FAState parentState;
                        block15: {
                            block11: {
                                if (this.getPathIndex() != 0) break block11;
                                nextState = (NFAState)path.get(this.getPathIndex());
                                nextNode = this.findNodeForStateNumber(nextState.stateNumber);
                                if (nextNode == null) {
                                    FAState parentState2 = skippedStates.get(nextState.stateNumber);
                                    if (parentState2 == null) {
                                        System.err.println("[GGraphGroup] Starting path state " + nextState.stateNumber + "[" + nextState.enclosingRule.name + "] cannot be found in the graph");
                                        return;
                                    }
                                    nextNode = this.findNodeForStateNumber(parentState2.stateNumber);
                                }
                                break block12;
                            }
                            state = nextState;
                            node = nextNode;
                            nextState = (NFAState)path.get(this.getPathIndex());
                            nextNode = this.findNodeForStateNumber(nextState.stateNumber);
                            externalNode = null;
                            if (nextNode != null) break block13;
                            t = this.getNodeTransitionToNextNonSkippedState(node, path);
                            if (t != null) break block14;
                            parentState = skippedStates.get(nextState.stateNumber);
                            if (parentState != null) break block15;
                            nextNode = node;
                            break block12;
                        }
                        nextNode = this.findNodeForStateNumber(parentState.stateNumber);
                        break block13;
                    }
                    if (this.getPathIndex() >= path.size()) {
                        nextNode = this.findNodeForStateNumber(t.target.stateNumber);
                    } else {
                        nextState = (NFAState)path.get(this.getPathIndex());
                        if (t.target.stateNumber == nextState.stateNumber) {
                            nextNode = this.findNodeForStateNumber(t.target.stateNumber);
                        } else {
                            externalNode = this.findNodeForStateNumber(t.target.stateNumber);
                            nextNode = this.findNodeForStateNumber(nextState.stateNumber);
                        }
                    }
                }
                if (state != null && node != null && nextNode != null) {
                    if (state.enclosingRule.name.equals(nextState.enclosingRule.name)) {
                        this.addNextElementInSameRule(elements, node, nextNode);
                    } else {
                        this.addNextElementInOtherRule(elements, node, externalNode, nextNode, nextState);
                    }
                }
            }
            this.pathIndex = this.getPathIndex() + 1;
        }
        if (nextNode != null) {
            elements.add(GPathElement.createElement(nextNode));
        }
        this.getPathGroup().addPath(new GPath(elements, disabled));
    }

    public void addUnreachableAlt(NFAState state, Integer alt) {
        ArrayList<GPathElement> elements = new ArrayList<GPathElement>();
        GNode node = this.findNodeForStateNumber(state.stateNumber);
        if (node == null) {
            System.err.println("[GGraphGroup] Decision state " + state.stateNumber + "[" + state.enclosingRule.name + "] cannot be found in the graph");
            return;
        }
        List<FATransition> transitions = node.state.transitions;
        int altNum = alt - 1;
        if (altNum >= transitions.size()) {
            System.err.println("[GGraphGroup] Unreachable alt " + altNum + "[" + state.enclosingRule.name + "] is out of bounds: " + transitions.size());
            return;
        }
        FATransition t = transitions.get(altNum);
        elements.add(GPathElement.createElement(node));
        elements.add(GPathElement.createElement(node.getLink(t)));
        GPath path = new GPath(elements, true);
        path.setVisible(true);
        path.setSelectable(false);
        this.getPathGroup().addPath(path);
    }

    public GNode findNodeForStateNumber(int stateNumber) {
        for (GGraph graph : this.getGraphs()) {
            GNode node = graph.findNodeForStateNumber(stateNumber);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public GDimension getDimension() {
        return this.dimension;
    }

    @Override
    public void render(float ox, float oy) {
        for (int i = 0; i < this.getGraphs().size(); ++i) {
            GGraph graph = this.getGraphs().get(i);
            graph.render(ox, oy);
            if (i >= this.getGraphs().size() - 1) continue;
            oy += graph.getHeight() + this.context.getPixelLineSpace();
        }
        this.setRendered(true);
    }

    @Override
    public void draw() {
        this.context.nodeColor = Color.black;
        this.context.linkColor = Color.black;
        this.context.setLineWidth(1.0f);
        for (GGraph graph : this.getGraphs()) {
            graph.draw();
        }
        this.getPathGroup().draw();
        if (this.context.drawdimension) {
            this.context.setLineWidth(1.0f);
            this.context.setColor(Color.lightGray);
            float width = this.getDimension().getPixelWidth(this.context);
            float up = this.getDimension().getPixelUp(this.context);
            float down = this.getDimension().getPixelDown(this.context);
            if (up + down > 0.0f) {
                this.context.drawRect(0.0f, 0.0f, width, up + down, false);
            }
        }
    }

    public List<GGraph> getGraphs() {
        return this.graphs;
    }

    public GPathGroup getPathGroup() {
        return this.pathGroup;
    }

    public int getPathIndex() {
        return this.pathIndex;
    }
}

