/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.graph.GGraphGroup;
import org.antlr.works.visualization.graphics.panel.GPanel;
import org.antlr.works.visualization.graphics.path.GPath;
import org.antlr.works.visualization.graphics.path.GPathGroup;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.utils.XJSmoothScrolling;

public class GView
extends JPanel
implements XJMenuItemDelegate {
    protected boolean useCachedImage = true;
    protected boolean cachedImageRerender = false;
    protected boolean cachedImageResize = false;
    protected String placeholder;
    protected BufferedImage cachedImage = null;
    protected List graphs = new ArrayList();
    protected int currentGraphIndex = 0;
    protected GPanel panel;
    protected GContext context;
    protected XJSmoothScrolling smoothScrolling;
    protected Point lastMouse;
    protected static final Font DEFAULT_FONT = new Font("Courier", 1, 18);
    public int offset_x = 10;
    public int offset_y = 10;
    public int prev_offset_x = 0;
    public int prev_offset_y = 0;

    public GView(GPanel panel, GContext context) {
        this.panel = panel;
        this.context = context;
        this.context.setContainer(this);
        this.smoothScrolling = new XJSmoothScrolling(this, null);
        this.setFocusable(true);
        this.setBackground(Color.white);
        this.adjustSize();
        this.addMouseMotionListener(new DefaultMouseMotionListener());
        this.addMouseListener(new DefaultMouseListener());
        this.addKeyListener(new DefaultKeyListener());
    }

    public void setEnable(boolean flag) {
        for (Object graph1 : this.graphs) {
            GGraphAbstract graph = (GGraphAbstract)graph1;
            graph.setEnable(flag);
        }
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setGraphs(List graphs) {
        this.graphs.clear();
        if (graphs == null) {
            return;
        }
        this.graphs.addAll(graphs);
        if (this.currentGraphIndex >= graphs.size()) {
            this.currentGraphIndex = graphs.size() - 1;
        }
        this.applyContext();
    }

    public List getGraphs() {
        return this.graphs;
    }

    public void applyContext() {
        for (Object graph1 : this.graphs) {
            GGraphAbstract graph = (GGraphAbstract)graph1;
            graph.setContext(this.context);
        }
    }

    public void setCacheEnabled(boolean flag) {
        if (this.useCachedImage != flag) {
            this.useCachedImage = flag;
            this.cacheInvalidate();
        }
    }

    public boolean isCachedEnabled() {
        return this.useCachedImage;
    }

    public void cacheInvalidate() {
        this.cachedImage = null;
    }

    public void cacheRerender() {
        this.cachedImageRerender = true;
    }

    public void setCacheResizeImage(boolean flag) {
        this.cachedImageResize = flag;
    }

    public BufferedImage getImage() {
        if (this.getCurrentGraph() == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.getPaintWidth(), this.getPaintHeight(), 5);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getPaintWidth(), this.getPaintHeight());
        this.render(g);
        g.dispose();
        return image;
    }

    public boolean setNextGraph() {
        ++this.currentGraphIndex;
        if (this.currentGraphIndex >= this.graphs.size()) {
            this.currentGraphIndex = this.graphs.size() - 1;
            return false;
        }
        return true;
    }

    public boolean setPrevGraph() {
        --this.currentGraphIndex;
        if (this.currentGraphIndex < 0) {
            this.currentGraphIndex = 0;
            return false;
        }
        return true;
    }

    public int getCurrentGraphIndex() {
        return this.currentGraphIndex;
    }

    public GGraphAbstract getCurrentGraph() {
        if (this.graphs.size() > 0) {
            return (GGraphAbstract)this.graphs.get(this.currentGraphIndex);
        }
        return null;
    }

    public GGraphGroup getCurrentGraphGroup() {
        return (GGraphGroup)this.getCurrentGraph();
    }

    public GPathGroup getCurrentPathGroup() {
        return this.getCurrentGraphGroup().getPathGroup();
    }

    public GPath getCurrentPath() {
        return this.getCurrentPathGroup().getCurrentPath();
    }

    public void refresh() {
        if (this.getCurrentGraph() != null) {
            this.getCurrentGraph().render(0.0f, 0.0f);
        }
        this.cacheInvalidate();
        this.adjustSize();
        this.repaint();
    }

    public void refreshSizeChanged(boolean useCacheImageResize) {
        if (this.useCachedImage) {
            this.setCacheResizeImage(useCacheImageResize);
            if (!useCacheImageResize) {
                if (this.getCurrentGraph() != null) {
                    this.getCurrentGraph().render(0.0f, 0.0f);
                }
                this.cacheInvalidate();
            }
            this.adjustSize();
            this.repaint();
        } else {
            this.refresh();
        }
    }

    public void adjustSize() {
        if (this.getCurrentGraph() == null || this.context == null) {
            return;
        }
        Dimension dimension = new Dimension(this.getGraphWidth() + 2 * this.offset_x, this.getGraphHeight() + 2 * this.offset_y);
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    public int getGraphWidth() {
        if (this.getCurrentGraph().getDimension() == null) {
            return 400;
        }
        return (int)this.getCurrentGraph().getWidth() + 20;
    }

    public int getGraphHeight() {
        if (this.getCurrentGraph().getDimension() == null) {
            return 200;
        }
        return (int)this.getCurrentGraph().getHeight() + 20;
    }

    public void addMenuItem(JPopupMenu menu, String title, int tag, Object object) {
        XJMenuItem item = new XJMenuItem();
        item.setTitle(title);
        item.setTag(tag);
        item.setObject(object);
        item.setDelegate(this);
        menu.add(item.getSwingComponent());
    }

    public JPopupMenu getContextualMenu() {
        return null;
    }

    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu menu = this.getContextualMenu();
            if (menu != null) {
                menu.show(this, e.getX(), e.getY());
            }
        } else {
            super.processMouseEvent(e);
        }
    }

    public void pathCurrentElementDidChange() {
        GPath path = this.getCurrentPath();
        Rectangle rect = path.getBoundsOfSelectedElement();
        if (!rect.isEmpty()) {
            rect.x -= 50;
            rect.y -= 50;
            rect.width += 100;
            rect.height += 100;
            this.smoothScrolling.scrollTo(rect);
        }
    }

    public boolean canDraw() {
        return this.getCurrentGraph() != null && this.getCurrentGraph().getDimension() != null && this.getCurrentGraph().isRendered();
    }

    public void render(Graphics2D g2d) {
        this.context.offsetX = this.offset_x;
        this.context.offsetY = this.offset_y;
        this.context.setGraphics2D(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.getCurrentGraph().draw();
    }

    public int getPaintWidth() {
        return this.getGraphWidth() + this.offset_x;
    }

    public int getPaintHeight() {
        return this.getGraphHeight() + this.offset_y + 1;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.canDraw()) {
            this.paintPlaceholder(g);
            return;
        }
        int width = this.getPaintWidth();
        int height = this.getPaintHeight();
        if (this.useCachedImage) {
            boolean sizeChanged;
            boolean bl = sizeChanged = this.cachedImage != null && (this.cachedImage.getWidth() != width || this.cachedImage.getHeight() != height);
            if (sizeChanged && !this.cachedImageResize && this.cachedImage != null) {
                this.cachedImage.flush();
                this.cachedImage = null;
            }
            if (this.cachedImage == null) {
                this.cachedImage = new BufferedImage(width, height, 5);
                Graphics2D gCache = (Graphics2D)this.cachedImage.getGraphics();
                gCache.setColor(Color.white);
                gCache.fillRect(0, 0, width, height);
                this.render(gCache);
                gCache.dispose();
            } else if (this.cachedImageRerender) {
                Graphics2D gCache = (Graphics2D)this.cachedImage.getGraphics();
                gCache.setColor(Color.white);
                gCache.fillRect(0, 0, width, height);
                this.render(gCache);
                gCache.dispose();
                this.cachedImageRerender = false;
            }
        }
        if (this.cachedImage == null) {
            this.render((Graphics2D)g);
        } else {
            g.drawImage(this.cachedImage, 0, 0, width, height, null);
        }
        if (!this.cachedImageResize && this.getCurrentGraph() instanceof GGraphGroup) {
            Graphics2D g2d = (Graphics2D)g;
            this.context.offsetX = this.offset_x;
            this.context.offsetY = this.offset_y;
            this.context.setGraphics2D(g2d);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.getCurrentPathGroup().drawSelectedElement();
        }
    }

    public void paintPlaceholder(Graphics g) {
        if (this.placeholder == null) {
            return;
        }
        g.setFont(DEFAULT_FONT);
        FontMetrics fm = g.getFontMetrics();
        Rectangle r = this.getVisibleRect();
        int x = r.x + r.width / 2 - fm.stringWidth(this.placeholder) / 2;
        int y = r.y + r.height / 2 + fm.getHeight() / 2;
        g.setColor(Color.gray);
        g.drawString(this.placeholder, x, y);
    }

    public class DefaultKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (GView.this.getCurrentGraph() instanceof GGraphGroup) {
                this.handleKeyPressedInGraphGroup(e);
            }
        }

        public void handleKeyPressedInGraphGroup(KeyEvent e) {
            GPath path = GView.this.getCurrentPath();
            switch (e.getKeyCode()) {
                case 39: {
                    path.nextElement();
                    GView.this.pathCurrentElementDidChange();
                    e.consume();
                    break;
                }
                case 37: {
                    path.previousElement();
                    GView.this.pathCurrentElementDidChange();
                    e.consume();
                    break;
                }
                case 38: {
                    path.lastElement();
                    GView.this.pathCurrentElementDidChange();
                    e.consume();
                    break;
                }
                case 40: {
                    path.firstElement();
                    GView.this.pathCurrentElementDidChange();
                    e.consume();
                    break;
                }
                case 65: {
                    GView.this.getCurrentPathGroup().toggleShowRuleLinks();
                    GView.this.cacheRerender();
                    e.consume();
                }
            }
            if (e.isConsumed()) {
                GView.this.repaint();
            }
        }
    }

    public class DefaultMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (!GView.this.isFocusOwner()) {
                GView.this.requestFocusInWindow();
            }
            GView.this.setCacheEnabled(false);
            GView.this.prev_offset_x = GView.this.offset_x;
            GView.this.prev_offset_y = GView.this.offset_y;
            GView.this.lastMouse = e.getPoint();
            if (GView.this.getCurrentGraph() instanceof GGraphGroup) {
                this.handleMousePressedInGraphGroup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            GView.this.lastMouse = null;
            GView.this.setCacheEnabled(true);
            GView.this.repaint();
        }

        public void handleMousePressedInGraphGroup(MouseEvent e) {
            GView.this.getCurrentPathGroup().selectPath(e.getPoint());
        }
    }

    public class DefaultMouseMotionListener
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if (GView.this.lastMouse == null) {
                return;
            }
            Point mouse = e.getPoint();
            int dx = mouse.x - GView.this.lastMouse.x;
            int dy = mouse.y - GView.this.lastMouse.y;
            GView.this.offset_x = GView.this.prev_offset_x + dx;
            GView.this.offset_y = GView.this.prev_offset_y + dy;
            GView.this.refresh();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

