/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventManager;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.shape.SLink;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;

public class GEventCreateLinkElement
extends GAbstractEvent {
    public GElement startElement = null;
    public String startAnchorKey = null;
    public SLink linkElement = null;
    public SLinkArc linkArc = null;
    public SLinkElbow linkElbow = null;

    public GEventCreateLinkElement(GView view) {
        super(view);
    }

    public void mousePressed(MouseEvent e, Point mousePosition) {
        GElement selectedElement = this.delegate.eventQueryElementAtPoint(mousePosition);
        if (this.startElement != null) {
            if (selectedElement != null) {
                int type = this.linkElement instanceof SLinkElbow ? 1 : 0;
                this.delegate.eventCreateLink(this.startElement, this.startAnchorKey, selectedElement, selectedElement.getAnchorKeyClosestToPoint(mousePosition), type, mousePosition);
            }
            this.removeExclusiveValue(GEventManager.EXCLUSIVE_CREATE_LINK_VALUE);
            this.startElement = null;
            this.linkElement = null;
            this.delegate.eventShouldRepaint();
            return;
        }
        if (selectedElement == null || !selectedElement.acceptOutgoingLink()) {
            return;
        }
        int mask = 1088;
        if ((e.getModifiersEx() & mask) == mask || this.delegate.eventCanCreateLink()) {
            this.startElement = selectedElement;
            this.startAnchorKey = this.startElement.getAnchorKeyClosestToPoint(mousePosition);
            this.linkArc = new SLinkArc();
            this.linkArc.setStartTangentOffset(this.startElement.getDefaultAnchorOffset(this.startAnchorKey));
            this.linkElbow = new SLinkElbow();
            this.linkElement = this.view.defaultLinkShape() == 0 ? this.linkArc : this.linkElbow;
            this.linkElement.setFlateness(this.delegate.eventLinkFlateness());
            this.addExclusiveValue(GEventManager.EXCLUSIVE_CREATE_LINK_VALUE);
        }
    }

    public void mouseMoved(MouseEvent e, Point mousePosition) {
        if (this.startElement == null) {
            return;
        }
        this.updateLink(mousePosition);
        this.delegate.eventShouldRepaint();
    }

    public boolean shouldFocusOnElement(GElement element) {
        if (this.startElement == null) {
            return true;
        }
        return element.acceptIncomingLink();
    }

    public void updateLink(Point mouse) {
        GElement ce = this.delegate.eventQueryElementAtPoint(mouse);
        boolean selfLoop = ce == this.startElement;
        this.setLinkStartAnchor(this.startElement.getAnchor(this.startAnchorKey));
        if (ce == null || ce instanceof GLink) {
            this.setLinkEnd(Vector2D.vector(mouse), Anchor2D.DIRECTION_BOTTOM);
        } else {
            Anchor2D anchor = ce.getAnchorClosestToPoint(mouse);
            String anchorKey = ce.getAnchorKeyClosestToPoint(mouse);
            this.setLinkEnd(anchor.position, anchor.direction);
            if (selfLoop) {
                if (anchor.direction == Anchor2D.DIRECTION_FREE) {
                    this.linkArc.setMouse(mouse);
                } else {
                    this.linkArc.setMouse(anchor.position.add(anchor.direction));
                }
                this.linkArc.setEndTangentOffset(this.startElement.getDefaultAnchorOffset(anchorKey));
            } else {
                this.linkArc.setMouse(mouse);
                this.linkArc.setEndTangentOffset(ce.getDefaultAnchorOffset(anchorKey));
            }
            if (selfLoop && this.view.defaultLinkShape() == 1 && this.startElement.getAnchor(this.startAnchorKey).equals(anchor)) {
                this.linkElement = this.linkArc;
            } else if (this.view.defaultLinkShape() == 1) {
                this.linkElement = this.linkElbow;
            } else if (this.view.defaultLinkShape() == 0) {
                this.linkElement = this.linkArc;
            }
        }
        this.setLinkSelfLoop(selfLoop);
        this.linkElement.update();
    }

    private void setLinkSelfLoop(boolean selfLoop) {
        this.linkArc.setSelfLoop(selfLoop);
        this.linkElbow.setSelfLoop(selfLoop);
    }

    private void setLinkStartAnchor(Anchor2D anchor) {
        this.linkArc.setStartAnchor(anchor);
        this.linkElbow.setStartAnchor(anchor);
    }

    private void setLinkEnd(Vector2D position, Vector2D direction) {
        this.linkArc.setEnd(position);
        this.linkArc.setEndDirection(direction);
        this.linkElbow.setEnd(position);
        this.linkElbow.setEndDirection(direction);
    }

    public void draw(Graphics g) {
        if (this.linkElement == null) {
            return;
        }
        this.linkElement.draw((Graphics2D)g);
    }
}

