/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;

public class XJMenuItem {
    protected JMenuItem jMenuItem = null;
    protected int tag = 0;
    protected Object object = null;
    protected XJMenuItemDelegate delegate = null;
    protected XJMenu parentMenu = null;

    public XJMenuItem() {
        this.init();
    }

    public XJMenuItem(String title, int accelerator, int tag, XJMenuItemDelegate delegate) {
        this.init();
        this.setTag(tag);
        this.setTitle(title);
        this.setAccelerator(accelerator);
        this.setDelegate(delegate);
    }

    public XJMenuItem(String title, Icon icon, int accelerator, int tag, XJMenuItemDelegate delegate) {
        this.init();
        this.setTag(tag);
        this.setTitle(title);
        this.setIcon(icon);
        this.setAccelerator(accelerator);
        this.setDelegate(delegate);
    }

    public XJMenuItem(String title, int accelerator, int modifiers, int tag, XJMenuItemDelegate delegate) {
        this.init();
        this.setTag(tag);
        this.setTitle(title);
        this.setAccelerator(accelerator, modifiers);
        this.setDelegate(delegate);
    }

    public XJMenuItem(String title, int tag, XJMenuItemDelegate delegate) {
        this.init();
        this.setTag(tag);
        this.setTitle(title);
        this.setDelegate(delegate);
    }

    public void init() {
        this.jMenuItem = new JMenuItem();
        this.jMenuItem.addActionListener(new MenuActionListener());
    }

    public void setMenu(XJMenu menu) {
        this.parentMenu = menu;
    }

    public void setDelegate(XJMenuItemDelegate delegate) {
        this.delegate = delegate;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTag() {
        return this.tag;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setTitle(String title) {
        this.jMenuItem.setText(title);
    }

    public String getTitle() {
        return this.jMenuItem.getText();
    }

    public void setEnabled(boolean enabled) {
        boolean previous = this.isEnabled();
        if (enabled && !previous || !enabled && previous) {
            this.jMenuItem.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.jMenuItem.isEnabled();
    }

    public void setSelected(boolean selected) {
        boolean previous = this.isSelected();
        if (selected && !previous || !selected && previous) {
            this.jMenuItem.setSelected(selected);
        }
    }

    public boolean isSelected() {
        return this.jMenuItem.isSelected();
    }

    public void setAccelerator(int keystroke) {
        int keyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.jMenuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke, keyModifier));
    }

    public void setAccelerator(int keystroke, int modifiers) {
        this.jMenuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke, modifiers));
    }

    public void setIcon(Icon icon) {
        this.jMenuItem.setIcon(icon);
    }

    public JComponent getSwingComponent() {
        return this.jMenuItem;
    }

    public static int getKeyModifier() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public class MenuActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (XJMenuItem.this.delegate != null) {
                XJMenuItem.this.delegate.handleMenuEvent(XJMenuItem.this.parentMenu, XJMenuItem.this);
            }
        }
    }
}

