/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.undo;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import org.antlr.xjlib.appkit.undo.XJUndoAction;

public class XJRedoAction
extends AbstractAction {
    protected UndoManager undoManager;
    protected XJUndoAction undoAction;

    public XJRedoAction(UndoManager manager) {
        super("Redo");
        this.setEnabled(false);
        this.undoManager = manager;
    }

    public void setUndoAction(XJUndoAction action) {
        this.undoAction = action;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.undoManager.canRedo()) {
            return;
        }
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException ex) {
            ex.printStackTrace();
        }
        this.updateRedoState();
        this.undoAction.updateUndoState();
    }

    protected void updateRedoState() {
        if (this.undoManager.canRedo()) {
            this.setEnabled(true);
            this.putValue("Name", this.undoManager.getRedoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Redo");
        }
    }
}

