/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.list;

import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_member
extends ExecuteOnlyCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            MemberBacktrackInfo bi = (MemberBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        MemberBacktrackInfo bi = new MemberBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.item = args[0];
        if (args[1] instanceof VariableTerm) {
            bi.list = new VariableTerm();
            bi.listExpand = true;
            bi.listDest = args[1];
        } else {
            bi.list = args[1];
        }
        return this.nextSolution(interpreter, bi);
    }

    protected int nextSolution(Interpreter interpreter, MemberBacktrackInfo bi) throws PrologException {
        while (!TermConstants.emptyListAtom.equals(bi.list)) {
            if (bi.listExpand) {
                CompoundTerm tmp = CompoundTerm.getList(bi.item, bi.list);
                interpreter.unify(bi.listDest, tmp);
                bi.item = new VariableTerm();
                bi.list = tmp;
            }
            Term head = ((CompoundTerm)bi.list).args[0].dereference();
            if (!bi.listExpand) {
                bi.list = ((CompoundTerm)bi.list).args[1].dereference();
            }
            if (bi.list instanceof VariableTerm) {
                bi.listDest = bi.list;
                bi.list = new VariableTerm();
                bi.listExpand = true;
            } else if (!CompoundTerm.isListPair(bi.list) && !TermConstants.emptyListAtom.equals(bi.list)) {
                return -1;
            }
            if (interpreter.unify(bi.item, head) == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    protected static class MemberBacktrackInfo
    extends BacktrackInfo {
        protected Term item;
        protected Term list;
        protected boolean listExpand;
        protected Term listDest;
        protected int startUndoPosition;

        protected MemberBacktrackInfo() {
            super(-1, -1);
        }
    }
}

