/* Generated By:JavaCC: Do not edit this line. Parser.java */
package com.alexmerz.graphviz;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

import com.alexmerz.graphviz.objects.Edge;
import com.alexmerz.graphviz.objects.Graph;
import com.alexmerz.graphviz.objects.Id;
import com.alexmerz.graphviz.objects.Node;
import com.alexmerz.graphviz.objects.PortNode;

/**
 * The parser creates a list of Graph objects
 * found in a Reader object.
 * 
 * @version $Id: graphviz.jj,v 1.3 2006/03/20 14:58:27 Alexander Exp $
 */
public class Parser implements ParserConstants {

    private Stack<Graph> graphs = new Stack<Graph>();
    private ArrayList<Graph> graphGeneralList = new ArrayList<Graph>();
    private int direction = Graph.UNDIRECTED;
    private ArrayList<Node> nodeList = new ArrayList<Node>();
    private Map<Id,Node> nodeMap = new HashMap<Id,Node>();
    private ArrayList<Graph> graphList = new ArrayList<Graph>();

    /**
     * Returns the main Graphs found in the Reader stream
     *
     * @return the list of main Graphs
     */
    public ArrayList<Graph> getGraphs() {
        return graphGeneralList;
    }

    public Parser() {
    }

    /**
     * Parses a Graphviz document
     *
     * @param in the Reader to parse
     * @return normally true should be returned, if false then
     *         something in the JDK is broken...
     */
    public boolean parse(Reader in) throws ParseException {

        // The Art of Unix Programming: If in doubt, use brute force!
        // Throw away line endings and spaces at the end of the file
        // that could be more effective the extending the grammar
        StringBuffer sb = new StringBuffer();
        int i;
        try {
            i = in.read();
            while (i != -1) {
                sb.append((char) i);
                i = in.read();
            }
        } catch (IOException e) {
            return false;
        }
        return parse(sb);
    }

    /**
     * Parses a Graphviz document
     *
     * @param sb the StringBuffer containing the document
     * @return normally true should be returned, if false then
     *         something in the JDK is broken...
     */
    public boolean parse(StringBuffer sb) throws ParseException {
        String is = sb.toString().trim();
        is.trim();
        StringReader ins = new StringReader(is);

        Parser p = new Parser(ins);
        p.graphs(graphGeneralList);
        return true;
    }

    /**
     * Creates a node, if the node wasn't used before
     * if a node with the given id/label already
     * exists, the existing node object is returned
     * instead.
     *
     * @param g the Graph
     * @param id the Id of the node
     * @param label the Label of the node
     * @return a Node object
     */
    protected Node createNode(Graph g, String id, String label) {
        Id nid = new Id();
        nid.setId(id);
        nid.setLabel(label);
        Node n = null;
        Id tid = null;
        /*for(int i=0; i<nodeList.size(); i++) {
                n = nodeList.get(i);
                tid = n.getId();
                if(tid.isEqual(nid)) {
                        return n;
                }
        }*/
        if (nodeMap.containsKey(nid)) {
            return nodeMap.get(nid);
        }
        n = new Node();
        n.setId(nid);
        nodeList.add(n);
        nodeMap.put(nid, n);
        g.addNode(n);
        return n;
    }

    /**
    * Check is node represents a cluster/subgraph
    * and sets the flag in the node
    * 
    * @param n the node to check
    */
    protected void checkIfNodeIsSubgraph(Node n) {
        // check if node represents a cluster/subgraph		
        for (int i = 0; i < graphList.size(); i++) {
            if (graphList.get(i).getId().isEqual(n.getId())) {
                n.representsSubgraph(true);
                break;
            }
        }
    }

    /**
     * adds Graph attributes to the graph
     * 
     * @param g the graph
     * @param ht the Hashtable containing the attributes
     */
    protected void addAttributes(Graph g, Hashtable<String,String> ht) {
        Enumeration<String> e = ht.keys();
        String key;
        while (e.hasMoreElements()) {
            key = e.nextElement();
            g.addAttribute(key, ht.get(key));
        }
    }

    /**
     * adds Edge attributes to an Edge object
     * 
     * @param edge the edge object
     * @param ht the Hashtable containing the attributes
     */
    protected void addAttributes(Edge edge, Hashtable<String,String> ht) {
        Enumeration<String> e = ht.keys();
        String key;
        while (e.hasMoreElements()) {
            key = e.nextElement();
            edge.setAttribute(key, ht.get(key));
        }
    }

    /**
     * adds Node attributes to a Node object
     * 
     * @param n the Node object
     * @param ht the Hashtable containing the attributes
     */
    protected void addAttributes(Node n, Hashtable<String,String> ht) {
        Enumeration<String> e = ht.keys();
        String key;
        while (e.hasMoreElements()) {
            key = e.nextElement();
            n.setAttribute(key, ht.get(key));
        }
    }

    final public void graphs(ArrayList<Graph> gglist) throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LB:
            case SPACE:
            case DIGRAPH:
            case GRAPH:
            case STRICT:
                label_1: while (true) {
                    graph(gglist);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case LB:
                        case SPACE:
                        case DIGRAPH:
                        case GRAPH:
                        case STRICT:
                            ;
                            break;
                        default:
                            jj_la1[0] = jj_gen;
                            break label_1;
                    }
                }
                break;
            case 0:
                jj_consume_token(0);
                break;
            default:
                jj_la1[1] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void graph(ArrayList<Graph> gglist) throws ParseException {
        Graph g = new Graph();
        Token st = null;
        Id id = null;
        graphs.push(g);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LB:
            case SPACE:
                label_2: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            jj_consume_token(SPACE);
                            break;
                        case LB:
                            jj_consume_token(LB);
                            break;
                        default:
                            jj_la1[2] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                    }
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case LB:
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[3] = jj_gen;
                            break label_2;
                    }
                }
                break;
            default:
                jj_la1[4] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case STRICT:
                st = jj_consume_token(STRICT);
                label_3: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[5] = jj_gen;
                            break label_3;
                    }
                }
                break;
            default:
                jj_la1[6] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case GRAPH:
                jj_consume_token(GRAPH);
                label_4: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[7] = jj_gen;
                            break label_4;
                    }
                }
                direction = Graph.UNDIRECTED;
                break;
            case DIGRAPH:
                jj_consume_token(DIGRAPH);
                label_5: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[8] = jj_gen;
                            break label_5;
                    }
                }
                direction = Graph.DIRECTED;
                break;
            default:
                jj_la1[9] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case STRING:
            case ID:
                id = id();
                g.setId(id);
                label_6: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[10] = jj_gen;
                            break label_6;
                    }
                }
                break;
            default:
                jj_la1[11] = jj_gen;
                ;
        }
        jj_consume_token(LBRACE);
        stmt_list();
        if (null != st) {
            g.setStrict(true);
        }
        g.setType(direction);
        gglist.add(g);
    }

    final public void stmt_list() throws ParseException {
        if (jj_2_1(2147483647)) {
            reallist();
        } else {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SUBGRAPH:
                case NODE:
                case EDGE:
                case SPACE:
                case LBRACE:
                case GRAPH:
                case STRING:
                case ID:
                case NUMBER:
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            label_7: while (true) {
                                jj_consume_token(SPACE);
                                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                    case SPACE:
                                        ;
                                        break;
                                    default:
                                        jj_la1[12] = jj_gen;
                                        break label_7;
                                }
                            }
                            break;
                        default:
                            jj_la1[13] = jj_gen;
                            ;
                    }
                    lb_stmt();
                    jj_consume_token(RBRACE);
                    break;
                default:
                    jj_la1[14] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void reallist() throws ParseException {
        label_8: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SPACE:
                    label_9: while (true) {
                        jj_consume_token(SPACE);
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case SPACE:
                                ;
                                break;
                            default:
                                jj_la1[15] = jj_gen;
                                break label_9;
                        }
                    }
                    break;
                default:
                    jj_la1[16] = jj_gen;
                    ;
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SEMI:
                case LB:
                    lb();
                    break;
                case SUBGRAPH:
                case NODE:
                case EDGE:
                case LBRACE:
                case GRAPH:
                case STRING:
                case ID:
                case NUMBER:
                    lb_stmt();
                    lb();
                    break;
                default:
                    jj_la1[17] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SEMI:
                case LB:
                case SUBGRAPH:
                case NODE:
                case EDGE:
                case SPACE:
                case LBRACE:
                case GRAPH:
                case STRING:
                case ID:
                case NUMBER:
                    ;
                    break;
                default:
                    jj_la1[18] = jj_gen;
                    break label_8;
            }
        }
        jj_consume_token(RBRACE);
    }

    final public void stmt() throws ParseException {
        lb_stmt();
    }

    final public void lb_stmt() throws ParseException {
        if (jj_2_2(2147483647)) {
            graph_attrib_assign();
        } else if (jj_2_3(2147483647)) {
            edge();
        } else if (jj_2_4(2147483647)) {
            subgraph();
        } else if (jj_2_5(2147483647)) {
            generic_attributes();
        } else if (jj_2_6(2147483647)) {
            node_listing();
        } else {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case STRING:
                case ID:
                case NUMBER:
                    single_node();
                    break;
                default:
                    jj_la1[19] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void lb() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SEMI:
                jj_consume_token(SEMI);
                break;
            case LB:
                jj_consume_token(LB);
                break;
            default:
                jj_la1[20] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void edge() throws ParseException {
        ArrayList<PortNode> sources = new ArrayList<PortNode>();
        ArrayList<PortNode> targets = new ArrayList<PortNode>();
        Node n = null;
        PortNode pn = null;
        ArrayList<Node> nl = null;
        Hashtable<String,String> ht = null;
        ArrayList<Edge> el = new ArrayList<Edge>();
        Graph g = graphs.peek();
        if (jj_2_7(2147483647)) {
            n = subgraph();
            sources.add(new PortNode(n));
        } else if (jj_2_8(2147483647)) {
            nl = matrix();
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SPACE:
                    label_10: while (true) {
                        jj_consume_token(SPACE);
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case SPACE:
                                ;
                                break;
                            default:
                                jj_la1[21] = jj_gen;
                                break label_10;
                        }
                    }
                    break;
                default:
                    jj_la1[22] = jj_gen;
                    ;
            }
            for (int i = 0; i < nl.size(); i++) {
                sources.add(new PortNode(nl.get(i)));
            }
        } else {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case STRING:
                case ID:
                case NUMBER:
                    pn = node_port();
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            label_11: while (true) {
                                jj_consume_token(SPACE);
                                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                    case SPACE:
                                        ;
                                        break;
                                    default:
                                        jj_la1[23] = jj_gen;
                                        break label_11;
                                }
                            }
                            break;
                        default:
                            jj_la1[24] = jj_gen;
                            ;
                    }
                    sources.add(pn);
                    break;
                default:
                    jj_la1[25] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        label_12: while (true) {
            edge_op();
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SPACE:
                    label_13: while (true) {
                        jj_consume_token(SPACE);
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case SPACE:
                                ;
                                break;
                            default:
                                jj_la1[26] = jj_gen;
                                break label_13;
                        }
                    }
                    break;
                default:
                    jj_la1[27] = jj_gen;
                    ;
            }
            if (jj_2_9(2147483647)) {
                n = subgraph();
                targets.add(new PortNode(n));
            } else if (jj_2_10(2147483647)) {
                nl = matrix();
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case SPACE:
                        label_14: while (true) {
                            jj_consume_token(SPACE);
                            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                case SPACE:
                                    ;
                                    break;
                                default:
                                    jj_la1[28] = jj_gen;
                                    break label_14;
                            }
                        }
                        break;
                    default:
                        jj_la1[29] = jj_gen;
                        ;
                }
                for (int i = 0; i < nl.size(); i++) {
                    targets.add(new PortNode(nl.get(i)));
                }
            } else {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case STRING:
                    case ID:
                    case NUMBER:
                        pn = node_port();
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case SPACE:
                                label_15: while (true) {
                                    jj_consume_token(SPACE);
                                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                        case SPACE:
                                            ;
                                            break;
                                        default:
                                            jj_la1[30] = jj_gen;
                                            break label_15;
                                    }
                                }
                                break;
                            default:
                                jj_la1[31] = jj_gen;
                                ;
                        }
                        targets.add(pn);
                        break;
                    default:
                        jj_la1[32] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
            }
            for (int i = 0; i < sources.size(); i++) {
                for (int a = 0; a < targets.size(); a++) {
                    el.add(new Edge(sources.get(i), targets.get(a), g.getType()));
                }
            }
            sources = targets;
            targets = new ArrayList<PortNode>();
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case EDGE_DIRECTED:
                case EDGE_UNDIRECTED:
                    ;
                    break;
                default:
                    jj_la1[33] = jj_gen;
                    break label_12;
            }
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LBRACKET:
                ht = attribute_list();
                break;
            default:
                jj_la1[34] = jj_gen;
                ;
        }
        for (int i = 0; i < el.size(); i++) {
            Edge e = el.get(i);
            if (ht != null) {
                Enumeration<String> en = ht.keys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement();
                    e.setAttribute(key, ht.get(key));
                }
            }
            g.addEdge(e);
        }
    }

    final public void edge_op() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case EDGE_DIRECTED:
                jj_consume_token(EDGE_DIRECTED);
                break;
            case EDGE_UNDIRECTED:
                jj_consume_token(EDGE_UNDIRECTED);
                break;
            default:
                jj_la1[35] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public ArrayList<Node> matrix() throws ParseException {
        ArrayList<Node> nl = new ArrayList<Node>();
        Node n = null;
        jj_consume_token(LBRACE);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_16: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[36] = jj_gen;
                            break label_16;
                    }
                }
                break;
            default:
                jj_la1[37] = jj_gen;
                ;
        }
        label_17: while (true) {
            n = node();
            nl.add(n);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SPACE:
                    label_18: while (true) {
                        jj_consume_token(SPACE);
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case SPACE:
                                ;
                                break;
                            default:
                                jj_la1[38] = jj_gen;
                                break label_18;
                        }
                    }
                    break;
                default:
                    jj_la1[39] = jj_gen;
                    ;
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case STRING:
                case ID:
                case NUMBER:
                    ;
                    break;
                default:
                    jj_la1[40] = jj_gen;
                    break label_17;
            }
        }
        jj_consume_token(RBRACE);
        {
            if (true) {
                return nl;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public void generic_attributes() throws ParseException {
        Graph g = graphs.peek();
        Hashtable<String,String> ht = null;
        Enumeration<String> e = null;
        String key;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case GRAPH:
                jj_consume_token(GRAPH);
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case SPACE:
                        label_19: while (true) {
                            jj_consume_token(SPACE);
                            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                case SPACE:
                                    ;
                                    break;
                                default:
                                    jj_la1[41] = jj_gen;
                                    break label_19;
                            }
                        }
                        break;
                    default:
                        jj_la1[42] = jj_gen;
                        ;
                }
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case LBRACKET:
                        ht = attribute_list();
                        break;
                    default:
                        jj_la1[43] = jj_gen;
                        ;
                }
                e = ht.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    g.addAttribute(key, ht.get(key));
                }
                break;
            case EDGE:
                jj_consume_token(EDGE);
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case SPACE:
                        label_20: while (true) {
                            jj_consume_token(SPACE);
                            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                case SPACE:
                                    ;
                                    break;
                                default:
                                    jj_la1[44] = jj_gen;
                                    break label_20;
                            }
                        }
                        break;
                    default:
                        jj_la1[45] = jj_gen;
                        ;
                }
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case LBRACKET:
                        ht = attribute_list();
                        break;
                    default:
                        jj_la1[46] = jj_gen;
                        ;
                }
                e = ht.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    g.addGenericEdgeAttribute(key, ht.get(key));
                }
                break;
            case NODE:
                jj_consume_token(NODE);
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case SPACE:
                        label_21: while (true) {
                            jj_consume_token(SPACE);
                            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                case SPACE:
                                    ;
                                    break;
                                default:
                                    jj_la1[47] = jj_gen;
                                    break label_21;
                            }
                        }
                        break;
                    default:
                        jj_la1[48] = jj_gen;
                        ;
                }
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case LBRACKET:
                        ht = attribute_list();
                        break;
                    default:
                        jj_la1[49] = jj_gen;
                        ;
                }
                e = ht.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    g.addGenericNodeAttribute(key, ht.get(key));
                }
                break;
            default:
                jj_la1[50] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public Node subgraph() throws ParseException {
        Id id = null;
        Graph g = new Graph();
        Graph parent = graphs.peek();
        graphs.push(g);
        g.setType(parent.getType());
        g.setStrict(parent.isStrict());
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SUBGRAPH:
                jj_consume_token(SUBGRAPH);
                label_22: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[51] = jj_gen;
                            break label_22;
                    }
                }
                break;
            default:
                jj_la1[52] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case STRING:
            case ID:
                id = id();
                label_23: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[53] = jj_gen;
                            break label_23;
                    }
                    jj_consume_token(SPACE);
                }
                g.setId(id);
                break;
            default:
                jj_la1[54] = jj_gen;
                ;
        }
        jj_consume_token(LBRACE);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LB:
                label_24: while (true) {
                    jj_consume_token(LB);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case LB:
                            ;
                            break;
                        default:
                            jj_la1[55] = jj_gen;
                            break label_24;
                    }
                }
                break;
            default:
                jj_la1[56] = jj_gen;
                ;
        }
        label_25: while (true) {
            sg_stmt_list();
            if (jj_2_11(2147483647)) {
                ;
            } else {
                break label_25;
            }
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_26: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[57] = jj_gen;
                            break label_26;
                    }
                }
                break;
            default:
                jj_la1[58] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SUBGRAPH:
            case NODE:
            case EDGE:
            case LBRACE:
            case GRAPH:
            case STRING:
            case ID:
            case NUMBER:
                stmt();
                break;
            default:
                jj_la1[59] = jj_gen;
                ;
        }
        jj_consume_token(RBRACE);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_27: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[60] = jj_gen;
                            break label_27;
                    }
                }
                break;
            default:
                jj_la1[61] = jj_gen;
                ;
        }
        if (id == null) {
            g.setId(new Id());
        }
        graphs.pop();
        parent.addSubgraph(g);
        Node n = createNode(parent, g.getId().getId(), g.getId().getLabel());
        n.representsSubgraph(true);
        {
            if (true) {
                return n;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public void sg_stmt_list() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_28: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[62] = jj_gen;
                            break label_28;
                    }
                }
                break;
            default:
                jj_la1[63] = jj_gen;
                ;
        }
        stmt();
        label_29: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SEMI:
                    jj_consume_token(SEMI);
                    break;
                case LB:
                    jj_consume_token(LB);
                    break;
                default:
                    jj_la1[64] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SEMI:
                case LB:
                    ;
                    break;
                default:
                    jj_la1[65] = jj_gen;
                    break label_29;
            }
        }
    }

    final public void graph_attrib_assign() throws ParseException {
        Token id = null;
        String value = null;
        id = jj_consume_token(ID);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_30: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[66] = jj_gen;
                            break label_30;
                    }
                }
                break;
            default:
                jj_la1[67] = jj_gen;
                ;
        }
        jj_consume_token(EQUAL);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_31: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[68] = jj_gen;
                            break label_31;
                    }
                }
                break;
            default:
                jj_la1[69] = jj_gen;
                ;
        }
        value = value();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_32: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[70] = jj_gen;
                            break label_32;
                    }
                }
                break;
            default:
                jj_la1[71] = jj_gen;
                ;
        }
        graphs.peek().addAttribute(id.image, value);
    }

    final public PortNode node_port() throws ParseException {
        Node n = null;
        Id port = null;
        n = node();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DOUBLE:
                jj_consume_token(DOUBLE);
                port = id();
                break;
            default:
                jj_la1[72] = jj_gen;
                ;
        }
        PortNode pn = new PortNode();
        pn.setNode(n);
        if (port != null) {
            if (!port.getId().equals("")) {
                pn.setPort(port.getId());
            } else if (!port.getLabel().equals("")) {
                pn.setPort(port.getLabel());
            }
        }
        {
            if (true) {
                return pn;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public void node_listing() throws ParseException {
        Node n = null;
        ArrayList<Node> nl = new ArrayList<Node>();
        Hashtable<String,String> ht = null;
        n = node();
        nl.add(n);
        label_33: while (true) {
            label_34: while (true) {
                jj_consume_token(SPACE);
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case SPACE:
                        ;
                        break;
                    default:
                        jj_la1[73] = jj_gen;
                        break label_34;
                }
            }
            n = node();
            nl.add(n);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case SPACE:
                    ;
                    break;
                default:
                    jj_la1[74] = jj_gen;
                    break label_33;
            }
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LBRACKET:
                ht = attribute_list();
                for (int i = 0; i < nl.size(); i++) {
                    n = nl.get(i);
                    addAttributes(n, ht);
                }
                break;
            default:
                jj_la1[75] = jj_gen;
                ;
        }
    }

    final public void single_node() throws ParseException {
        Node n = null;
        Hashtable<String,String> ht = null;
        n = node();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_35: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[76] = jj_gen;
                            break label_35;
                    }
                }
                break;
            default:
                jj_la1[77] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LBRACKET:
                ht = attribute_list();
                addAttributes(n, ht);
                break;
            default:
                jj_la1[78] = jj_gen;
                ;
        }
    }

    final public Hashtable<String,String> attribute_list() throws ParseException {
        Hashtable<String,String> ht = new Hashtable<String,String>();
        String[] kv;
        jj_consume_token(LBRACKET);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LB:
                jj_consume_token(LB);
                break;
            default:
                jj_la1[79] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_36: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[80] = jj_gen;
                            break label_36;
                    }
                }
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case LB:
                        jj_consume_token(LB);
                        break;
                    default:
                        jj_la1[81] = jj_gen;
                        ;
                }
                break;
            default:
                jj_la1[82] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ID:
                label_37: while (true) {
                    kv = attribute();
                    ht.put(kv[0], kv[1]);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case ID:
                            ;
                            break;
                        default:
                            jj_la1[83] = jj_gen;
                            break label_37;
                    }
                }
                break;
            default:
                jj_la1[84] = jj_gen;
                ;
        }
        jj_consume_token(RBRACKET);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_38: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[85] = jj_gen;
                            break label_38;
                    }
                }
                break;
            default:
                jj_la1[86] = jj_gen;
                ;
        }
        {
            if (true) {
                return ht;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public String[] attribute() throws ParseException {
        Token id = null;
        String[] kv = new String[2];
        kv[0] = "";
        kv[1] = "";
        id = jj_consume_token(ID);
        if (jj_2_12(2147483647)) {
            kv[1] = attrib_value();
        } else {
            ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_39: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[87] = jj_gen;
                            break label_39;
                    }
                }
                break;
            default:
                jj_la1[88] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case COMMA:
                jj_consume_token(COMMA);
                label_40: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[89] = jj_gen;
                            break label_40;
                    }
                    jj_consume_token(SPACE);
                }
                break;
            default:
                jj_la1[90] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case LB:
                jj_consume_token(LB);
                break;
            default:
                jj_la1[91] = jj_gen;
                ;
        }
        kv[0] = id.image;
        {
            if (true) {
                return kv;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public String attrib_value() throws ParseException {
        String v = "";
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_41: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[92] = jj_gen;
                            break label_41;
                    }
                }
                break;
            default:
                jj_la1[93] = jj_gen;
                ;
        }
        jj_consume_token(EQUAL);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case SPACE:
                label_42: while (true) {
                    jj_consume_token(SPACE);
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                        case SPACE:
                            ;
                            break;
                        default:
                            jj_la1[94] = jj_gen;
                            break label_42;
                    }
                }
                break;
            default:
                jj_la1[95] = jj_gen;
                ;
        }
        v = value();
        {
            if (true) {
                return v;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Node node() throws ParseException {
        Token t = null;
        Id i = new Id();
        Node n = null;
        Graph c = graphs.peek();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ID:
            case NUMBER:
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case ID:
                        t = jj_consume_token(ID);
                        break;
                    case NUMBER:
                        t = jj_consume_token(NUMBER);
                        break;
                    default:
                        jj_la1[96] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                i.setId(t.image);
                n = createNode(c, t.image, "");
                checkIfNodeIsSubgraph(n);
                {
                    if (true) {
                        return n;
                    }
                }
                break;
            case STRING:
                t = jj_consume_token(STRING);
                i.setLabel(t.image);
                n = createNode(c, "", t.image.substring(1, t.image.length() - 1));
                checkIfNodeIsSubgraph(n);
                {
                    if (true) {
                        return n;
                    }
                }
                break;
            default:
                jj_la1[97] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public Id id() throws ParseException {
        Token id = null;
        Token text = null;
        Id i = new Id();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ID:
                id = jj_consume_token(ID);
                i.setId(id.image);
                {
                    if (true) {
                        return i;
                    }
                }
                break;
            case STRING:
                text = jj_consume_token(STRING);
                if (text != null) {
                    i.setLabel(text.image.substring(1, text.image.length() - 1));
                }
                {
                    if (true) {
                        return i;
                    }
                }
                break;
            default:
                jj_la1[98] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public String value() throws ParseException {
        Token text = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ID:
                text = jj_consume_token(ID);
                {
                    if (true) {
                        return text.image;
                    }
                }
                break;
            case STRING:
                text = jj_consume_token(STRING);
                {
                    if (true) {
                        return text.image.substring(1, text.image.length() - 1);
                    }
                }
                break;
            case NUMBER:
                text = jj_consume_token(NUMBER);
                {
                    if (true) {
                        return text.image;
                    }
                }
                break;
            default:
                jj_la1[99] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    final private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    final private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    final private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    final private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_5();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    final private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_6();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    final private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_7();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    final private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_8();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    final private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_9();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    final private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_10();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    final private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_11();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    final private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_12();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    final private boolean jj_3R_108() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(11)) {
            jj_scanpos = xsp;
            if (jj_scan_token(15)) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3_2() {
        if (jj_3R_44()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_48() {
        if (jj_3R_72()) {
            return true;
        }
        Token xsp;
        if (jj_3R_73()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_73()) {
                jj_scanpos = xsp;
                break;
            }
        }
        xsp = jj_scanpos;
        if (jj_3R_74()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_122() {
        if (jj_3R_124()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_121() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_120() {
        if (jj_3R_47()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_84() {
        if (jj_3R_107()) {
            return true;
        }
        if (jj_3R_108()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_119() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_118() {
        if (jj_3R_45()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_83() {
        if (jj_3R_108()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_109() {
        if (jj_scan_token(DOUBLE)) {
            return true;
        }
        if (jj_3R_97()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_117() {
        if (jj_3R_44()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_107() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_117()) {
            jj_scanpos = xsp;
            if (jj_3R_118()) {
                jj_scanpos = xsp;
                if (jj_3R_119()) {
                    jj_scanpos = xsp;
                    if (jj_3R_120()) {
                        jj_scanpos = xsp;
                        if (jj_3R_121()) {
                            jj_scanpos = xsp;
                            if (jj_3R_122()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_78() {
        if (jj_3R_107()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_82() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_52() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_82()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_83()) {
            jj_scanpos = xsp;
            if (jj_3R_84()) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_43() {
        Token xsp;
        if (jj_3R_52()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_52()) {
                jj_scanpos = xsp;
                break;
            }
        }
        if (jj_scan_token(RBRACE)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_53() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_89() {
        if (jj_3R_72()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_109()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3_1() {
        if (jj_3R_43()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_56() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_44() {
        if (jj_scan_token(ID)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_53()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(EQUAL)) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_54()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_55()) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_56()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_77() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_50() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_77()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_78()) {
            return true;
        }
        if (jj_3R_79()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_79()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_79() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(11)) {
            jj_scanpos = xsp;
            if (jj_scan_token(15)) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3_11() {
        if (jj_3R_50()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_65() {
        if (jj_3R_50()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_68() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_66() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_67() {
        if (jj_3R_78()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_103() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_64() {
        Token xsp;
        if (jj_scan_token(15)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(15)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_63() {
        if (jj_3R_97()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_62() {
        if (jj_scan_token(SUBGRAPH)) {
            return true;
        }
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_46() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_62()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_63()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(LBRACE)) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_64()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_65()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_65()) {
                jj_scanpos = xsp;
                break;
            }
        }
        xsp = jj_scanpos;
        if (jj_3R_66()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_67()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(RBRACE)) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_68()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_101() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_102() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_100() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_71() {
        if (jj_scan_token(NODE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_102()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_103()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_106() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_70() {
        if (jj_scan_token(EDGE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_100()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_101()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_98() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_86() {
        if (jj_scan_token(STRING)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_87() {
        if (jj_scan_token(NUMBER)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_99() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_55() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_85()) {
            jj_scanpos = xsp;
            if (jj_3R_86()) {
                jj_scanpos = xsp;
                if (jj_3R_87()) {
                    return true;
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_85() {
        if (jj_scan_token(ID)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_47() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_69()) {
            jj_scanpos = xsp;
            if (jj_3R_70()) {
                jj_scanpos = xsp;
                if (jj_3R_71()) {
                    return true;
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_69() {
        if (jj_scan_token(GRAPH)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_98()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_99()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_116() {
        if (jj_scan_token(STRING)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_115() {
        if (jj_scan_token(ID)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_97() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_115()) {
            jj_scanpos = xsp;
            if (jj_3R_116()) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_76() {
        if (jj_3R_72()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_106()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_75() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_49() {
        if (jj_scan_token(LBRACE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_75()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_76()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_76()) {
                jj_scanpos = xsp;
                break;
            }
        }
        if (jj_scan_token(RBRACE)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_105() {
        if (jj_scan_token(STRING)) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_81() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_110() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_91() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(9)) {
            jj_scanpos = xsp;
            if (jj_scan_token(10)) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_104() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(28)) {
            jj_scanpos = xsp;
            if (jj_scan_token(29)) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_72() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_104()) {
            jj_scanpos = xsp;
            if (jj_3R_105()) {
                return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_111() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3_12() {
        if (jj_3R_51()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_80() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_130() {
        if (jj_scan_token(COMMA)) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_88() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_51() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_80()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(EQUAL)) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_81()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_55()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_61() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_128() {
        if (jj_3R_51()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3_10() {
        if (jj_3R_49()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_125() {
        if (jj_scan_token(ID)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_128()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_129()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_130()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_scan_token(15)) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_129() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_90() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3_9() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_95() {
        if (jj_3R_89()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_111()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_92() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_94() {
        if (jj_3R_49()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_110()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_123() {
        if (jj_3R_125()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_114() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_113() {
        Token xsp;
        if (jj_3R_123()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_123()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_93() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3_8() {
        if (jj_3R_49()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_112() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        xsp = jj_scanpos;
        if (jj_scan_token(15)) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_60() {
        if (jj_3R_91()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_92()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_93()) {
            jj_scanpos = xsp;
            if (jj_3R_94()) {
                jj_scanpos = xsp;
                if (jj_3R_95()) {
                    return true;
                }
            }
        }
        return false;
    }

    final private boolean jj_3R_59() {
        if (jj_3R_89()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_90()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3_7() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_96() {
        if (jj_scan_token(LBRACKET)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(15)) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_112()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_113()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(RBRACKET)) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_114()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_126() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    final private boolean jj_3R_58() {
        if (jj_3R_49()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_88()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_73() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        if (jj_3R_72()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_127() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_57() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_45() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_57()) {
            jj_scanpos = xsp;
            if (jj_3R_58()) {
                jj_scanpos = xsp;
                if (jj_3R_59()) {
                    return true;
                }
            }
        }
        if (jj_3R_60()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_60()) {
                jj_scanpos = xsp;
                break;
            }
        }
        xsp = jj_scanpos;
        if (jj_3R_61()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3R_124() {
        if (jj_3R_72()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_126()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3R_127()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    final private boolean jj_3_6() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3_5() {
        if (jj_3R_47()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3_4() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3_3() {
        if (jj_3R_45()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_74() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    final private boolean jj_3R_54() {
        Token xsp;
        if (jj_scan_token(19)) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_scan_token(19)) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    public ParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token, jj_nt;
    private int jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    final private int[] jj_la1 = new int[100];
    static private int[] jj_la1_0;
    static {
        jj_la1_0();
    }

    private static void jj_la1_0() {
        jj_la1_0 =
            new int[] {0x7088000, 0x7088001, 0x88000, 0x88000, 0x88000, 0x80000, 0x4000000, 0x80000, 0x80000, 0x3000000, 0x80000, 0x18000000, 0x80000, 0x80000, 0x3a4f0000, 0x80000, 0x80000, 0x3a478800, 0x3a4f8800, 0x38000000, 0x8800, 0x80000, 0x80000, 0x80000, 0x80000, 0x38000000, 0x80000, 0x80000, 0x80000, 0x80000, 0x80000, 0x80000, 0x38000000, 0x600, 0x100000, 0x600, 0x80000, 0x80000, 0x80000, 0x80000, 0x38000000, 0x80000, 0x80000, 0x100000, 0x80000, 0x80000, 0x100000, 0x80000, 0x80000, 0x100000, 0x2060000, 0x80000, 0x10000, 0x80000, 0x18000000, 0x8000, 0x8000, 0x80000, 0x80000, 0x3a470000, 0x80000, 0x80000, 0x80000, 0x80000, 0x8800, 0x8800, 0x80000, 0x80000, 0x80000, 0x80000, 0x80000, 0x80000, 0x1000, 0x80000, 0x80000, 0x100000, 0x80000, 0x80000, 0x100000, 0x8000, 0x80000, 0x8000,
                0x80000, 0x10000000, 0x10000000, 0x80000, 0x80000, 0x80000, 0x80000, 0x80000, 0x2000, 0x8000, 0x80000, 0x80000, 0x80000, 0x80000, 0x30000000, 0x38000000, 0x18000000, 0x38000000,};
    }

    final private JJCalls[] jj_2_rtns = new JJCalls[12];
    private boolean jj_rescan = false;
    private int jj_gc = 0;

    public Parser(java.io.InputStream stream) {
        this(stream, null);
    }

    public Parser(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 100; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    public void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 100; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(java.io.Reader stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 100; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 100; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 100; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 100; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    final private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    static private final class LookaheadSuccess extends java.lang.Error {
    }

    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    final private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    final public Token getToken(int index) {
        Token t = lookingAhead ? jj_scanpos : token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    final private int jj_ntk() {
        if ((jj_nt = token.next) == null) {
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        } else {
            return (jj_ntk = jj_nt.kind);
        }
    }

    private java.util.Vector<int[]> jj_expentries = new java.util.Vector<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            boolean exists = false;
            for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
                int[] oldentry = (int[]) (e.nextElement());
                if (oldentry.length == jj_expentry.length) {
                    exists = true;
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            exists = false;
                            break;
                        }
                    }
                    if (exists) {
                        break;
                    }
                }
            }
            if (!exists) {
                jj_expentries.addElement(jj_expentry);
            }
            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[30];
        for (int i = 0; i < 30; i++) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 100; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 30; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.addElement(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.elementAt(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    final public void enable_tracing() {
    }

    final public void disable_tracing() {
    }

    final private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 12; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                            case 4:
                                jj_3_5();
                                break;
                            case 5:
                                jj_3_6();
                                break;
                            case 6:
                                jj_3_7();
                                break;
                            case 7:
                                jj_3_8();
                                break;
                            case 8:
                                jj_3_9();
                                break;
                            case 9:
                                jj_3_10();
                                break;
                            case 10:
                                jj_3_11();
                                break;
                            case 11:
                                jj_3_12();
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            } catch (LookaheadSuccess ls) {
            }
        }
        jj_rescan = false;
    }

    final private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;
    }

}
