/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class AbstractWizardDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4959664049980493436L;
    private static final String BACK_COMMAND = "<- Back";
    private static final String NEXT_COMMAND = "Next ->";
    private static final String FINISH_COMMAND = "Finish";
    private static final String CANCEL_COMMAND = "Cancel";
    private static final Font GuideTitleFont = new Font("Dialog", 1, 12);
    private final JButton backButton = new JButton("<- Back");
    private final JButton nextButton = new JButton("Next ->");
    private final JButton finishButton = new JButton("Finish");
    private final JButton cancelButton = new JButton("Cancel");
    private final JPanel centerPanel = new JPanel(new CardLayout());
    private final JLabel guideTitleLabel = new JLabel();
    private final JLabel guideTextLabel = new JLabel("T\u00e4m\u00e4 on helppi teksti\u00e4!!");
    private final JLabel guideIconLabel = new JLabel();
    private final String[] panelNames;
    private int cardIndex = 0;

    public AbstractWizardDialog(JFrame jFrame, String string, String[] stringArray) {
        super(jFrame, string, true);
        this.panelNames = stringArray;
    }

    public void showDialog() {
        this.setContentPane(this.createContentPane());
        this.showCard(this.cardIndex);
        this.pack();
        this.setResizable(true);
        this.setVisible(true);
    }

    private Container createContentPane() {
        this.backButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.cancelButton);
        JPanel jPanel = new JPanel();
        jPanel.add(this.backButton);
        jPanel.add(this.nextButton);
        jPanel.add(this.finishButton);
        jPanel.add(this.cancelButton);
        jPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        jPanel.setLayout(new FlowLayout(2));
        this.getRootPane().setDefaultButton(this.cancelButton);
        for (int i = 0; i < this.panelNames.length; ++i) {
            this.centerPanel.add(this.createCardPanel(i), this.panelNames[i]);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.guideTitleLabel.setFont(GuideTitleFont);
        this.guideIconLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 10));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel3.add((Component)this.guideTitleLabel, "North");
        jPanel3.add((Component)this.guideTextLabel, "Center");
        jPanel2.setBackground(Color.WHITE);
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)this.guideIconLabel, "East");
        jPanel2.add((Component)new JSeparator(0), "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(new JSeparator(0));
        jPanel4.add(jPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel2, "North");
        container.add((Component)this.centerPanel, "Center");
        container.add((Component)jPanel4, "South");
        return container;
    }

    protected abstract Component createCardPanel(int var1);

    protected boolean isStepToCardPossible(int n) {
        return n >= 0 && n < this.panelNames.length;
    }

    private void showCard(int n) {
        CardLayout cardLayout = (CardLayout)this.centerPanel.getLayout();
        cardLayout.show(this.centerPanel, this.panelNames[n]);
        ImageIcon imageIcon = this.getPanelIcon(n);
        if (imageIcon != null) {
            this.guideIconLabel.setIcon(imageIcon);
        }
        this.guideTextLabel.setText(this.getPanelHelp(n));
        this.guideTitleLabel.setText(this.panelNames[n]);
    }

    protected String getPanelName(int n) {
        return this.panelNames[n];
    }

    protected abstract ImageIcon getPanelIcon(int var1);

    protected abstract String getPanelHelp(int var1);

    protected void updateWizardButtonEnables() {
        this.enableBack(this.isStepToCardPossible(this.cardIndex - 1));
        this.enableNext(this.isStepToCardPossible(this.cardIndex + 1));
        this.enableFinish(this.cardIndex == this.panelNames.length - 1);
    }

    private void stepCard(int n) {
        int n2 = this.cardIndex + n;
        if (this.isStepToCardPossible(n2)) {
            this.cardIndex = n2;
            this.showCard(this.cardIndex);
            this.cardChanged(this.cardIndex - n, this.cardIndex);
            this.updateWizardButtonEnables();
        }
    }

    protected abstract void cardChanged(int var1, int var2);

    protected abstract void finish();

    protected final int getCardIndex() {
        return this.cardIndex;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CANCEL_COMMAND)) {
            this.setVisible(false);
        } else if (string.equals(BACK_COMMAND)) {
            this.stepCard(-1);
        } else if (string.equals(NEXT_COMMAND)) {
            this.stepCard(1);
        } else if (string.equals(FINISH_COMMAND)) {
            this.finish();
        }
        this.updateWizardButtonEnables();
    }

    private void enableBack(boolean bl) {
        this.backButton.setEnabled(bl);
    }

    private void enableNext(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    private void enableFinish(boolean bl) {
        this.finishButton.setEnabled(bl);
    }
}

