/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.stamppagetor.DocStyle;
import org.stamppagetor.StampGroup;
import org.stamppagetor.StampLine;
import org.stamppagetor.StampPage;
import org.stamppagetor.StampPlace;
import org.stamppagetor.StampPrintable;
import org.stamppagetor.pdf.PDFDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StampDocument
extends StampPrintable
implements Printable,
Pageable {
    public static final String XML_NODE_NAME = "doc";
    private static final int PAGE_MARGINS = 36;
    private String saveFileName = null;
    private final DocStyle docStyle;
    private final PrinterJob printerJob = PrinterJob.getPrinterJob();
    private boolean savingNeeded = false;
    private static final String XML_ENCODING_NAME = "UTF-8";
    public static final FileNameExtensionFilter docFileFilter = new FileNameExtensionFilter("Stamp Album XML documents", "xml");

    public StampDocument() {
        this.docStyle = new DocStyle();
    }

    public StampDocument(StampDocument stampDocument) {
        super(stampDocument);
        this.docStyle = new DocStyle(stampDocument.docStyle);
        this.saveFileName = stampDocument.saveFileName;
        this.savingNeeded = stampDocument.savingNeeded;
    }

    @Override
    public StampPrintable deepCopy() {
        return new StampDocument(this);
    }

    public String getFileName() {
        return this.saveFileName;
    }

    public void setFileName(String string) {
        this.saveFileName = string;
    }

    public StampPage getPage(int n) {
        if (n < 0) {
            return null;
        }
        if (this.parts.size() <= n) {
            return null;
        }
        return (StampPage)this.parts.elementAt(n);
    }

    public int getIndexOfPage(StampPage stampPage) {
        return this.parts.indexOf(stampPage);
    }

    public void save(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (string == null) {
            string = this.saveFileName;
        } else {
            this.saveFileName = string;
        }
        if (string == null) {
            throw new FileNotFoundException("No file name");
        }
        PrintStream printStream = new PrintStream(string, XML_ENCODING_NAME);
        this.toXml(printStream, "");
    }

    @Override
    public void toXml(PrintStream printStream, String string) {
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<doc>");
        this.docStyle.toXml(printStream, string);
        for (StampPrintable stampPrintable : this.parts) {
            stampPrintable.toXml(printStream, string);
        }
        printStream.println("</doc>");
    }

    public static StampDocument load(String string) throws Exception {
        int n;
        Object object;
        Object object2;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        try {
            object2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(new File("stamppagetor.xsd"));
            Schema schema = ((SchemaFactory)object2).newSchema(streamSource);
            object = schema.newValidator();
            ((Validator)object).validate(new DOMSource(document));
        }
        catch (Exception exception) {
            System.err.println("Document is not valid: " + exception);
            throw exception;
        }
        object2 = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().compareTo(XML_NODE_NAME) != 0) continue;
            object2 = nodeList.item(i);
            break;
        }
        if (object2 == null) {
            throw new Exception("Invalid file: <doc> is missing!");
        }
        StampDocument stampDocument = new StampDocument();
        stampDocument.saveFileName = string;
        nodeList = object2.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            object = nodeList.item(n);
            if (object.getNodeName().compareTo("docstyle") != 0) continue;
            stampDocument.docStyle.readDocStyleNode((Node)object);
        }
        nodeList = object2.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            object = nodeList.item(n);
            if (object.getNodeName().compareTo("page") != 0) continue;
            stampDocument.add(new StampPage((Node)object));
        }
        return stampDocument;
    }

    public void print() throws Exception {
        this.printerJob.setPrintable(this, this.getPageFormat(0));
        if (this.printerJob.printDialog()) {
            this.printerJob.print();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPDF(File file) throws Exception {
        DocStyle.ImageColouring imageColouring = this.docStyle.getStampImageColouring();
        try {
            this.docStyle.setStampImageColouring(DocStyle.ImageColouring.COLOR);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PDFDocument pDFDocument = new PDFDocument();
            pDFDocument.create(fileOutputStream, this, this, this.getPageFormat(0));
            ((OutputStream)fileOutputStream).close();
        }
        finally {
            this.docStyle.setStampImageColouring(imageColouring);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return this.print(graphics, pageFormat, n, null, new Rectangle(0, 0, 0, 0));
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n, StampPrintable stampPrintable, Rectangle rectangle) {
        if (n >= this.parts.size() || n < 0) {
            return 1;
        }
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        Rectangle rectangle2 = new Rectangle(rectangle.x + (int)d, rectangle.y + (int)d2, (int)d3, (int)d4);
        return this.print(graphics, n, stampPrintable, rectangle2);
    }

    @Override
    public void print(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        this.print(graphics, 0, stampPrintable, rectangle);
    }

    public int print(Graphics graphics, int n, StampPrintable stampPrintable, Rectangle rectangle) {
        if (n >= this.parts.size() || n < 0) {
            return 1;
        }
        graphics.setColor(Color.black);
        this.parts.elementAt(n).print(graphics, this.docStyle, stampPrintable, rectangle);
        return 0;
    }

    @Override
    public StampPrintable checkPoint(Rectangle rectangle, int n, int n2, DocStyle docStyle) {
        return null;
    }

    public StampPrintable checkPoint(int n, int n2, int n3) {
        if (n >= this.parts.size() || n < 0) {
            return null;
        }
        PageFormat pageFormat = this.docStyle.getPageFormat();
        Rectangle rectangle = new Rectangle(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        if (!rectangle.contains(n2, n3)) {
            return null;
        }
        Rectangle[] rectangleArray = this.getPartPlaces(rectangle, this.docStyle);
        if (rectangleArray[0].contains(n2, n3)) {
            rectangleArray[0].x = 0;
            rectangleArray[0].y = 0;
            return this.parts.elementAt(n).checkPoint(rectangleArray[0], n2 -= rectangleArray[0].x, n3 -= rectangleArray[0].y, this.docStyle);
        }
        return this.parts.elementAt(n);
    }

    @Override
    protected Rectangle[] getPartPlaces(Rectangle rectangle, DocStyle docStyle) {
        Rectangle[] rectangleArray = new Rectangle[1];
        PageFormat pageFormat = this.getPageFormat(0);
        int n = (int)pageFormat.getImageableX();
        int n2 = (int)pageFormat.getImageableY();
        int n3 = (int)pageFormat.getImageableWidth();
        int n4 = (int)pageFormat.getImageableHeight();
        rectangleArray[0] = new Rectangle(n, n2, n3, n4);
        return rectangleArray;
    }

    private void setPageFormat(PageFormat pageFormat) {
        this.docStyle.setPageFormat(pageFormat);
    }

    public void paperOptions() {
        this.setPageFormat(this.printerJob.pageDialog(this.getPageFormat(0)));
    }

    public DocStyle getStyle() {
        return this.docStyle;
    }

    public boolean isSavingNeeded() {
        return this.savingNeeded;
    }

    public void setSavingNeeded(boolean bl) {
        this.savingNeeded = bl;
    }

    public String toString() {
        return "Album";
    }

    public int getLeftMargin(int n) {
        return 36;
    }

    public int getRightMargin(int n) {
        return 36;
    }

    public int getTopMargin(int n) {
        return 36;
    }

    public int getBottomMargin(int n) {
        return 36;
    }

    @Override
    public int getNumberOfPages() {
        return this.parts.size();
    }

    @Override
    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.docStyle.getPageFormat();
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n >= this.parts.size() || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    public static StampDocument createEmptyDocument() {
        StampDocument stampDocument = new StampDocument();
        StampPage stampPage = new StampPage();
        stampPage.setTitleString("Title of page");
        StampGroup stampGroup = new StampGroup("Title of group");
        StampLine stampLine = new StampLine();
        StampPlace stampPlace = new StampPlace();
        stampPlace.setText(0, "1,20 $");
        stampPlace.setText(1, "green");
        stampPlace.setText(2, "");
        stampLine.add(stampPlace);
        stampGroup.add(stampLine);
        stampPage.add(stampGroup);
        stampDocument.add(stampPage);
        return stampDocument;
    }
}

