/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.stamppagetor.DocStyle;
import org.stamppagetor.DocTreePath;
import org.stamppagetor.ImageCache;
import org.stamppagetor.PageListView;
import org.stamppagetor.PageView;
import org.stamppagetor.PageViewActionListener;
import org.stamppagetor.StampDocument;
import org.stamppagetor.StampPage;
import org.stamppagetor.StampPlace;
import org.stamppagetor.StampPrintable;
import org.stamppagetor.StampShape;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.UndoStore;
import org.stamppagetor.preferences.LatestFiles;
import org.stamppagetor.property.PropertiesInterface;
import org.stamppagetor.property.PropertyListener;
import org.stamppagetor.property.PropertyPanel;
import org.stamppagetor.property.PropertyTableModel;
import org.stamppagetor.ui.UiBundle;
import org.stamppagetor.ui.UiBundleAbout;
import org.stamppagetor.ui.UiBundleAdd;
import org.stamppagetor.ui.UiBundleAddGroup;
import org.stamppagetor.ui.UiBundleAddLine;
import org.stamppagetor.ui.UiBundleAddPage;
import org.stamppagetor.ui.UiBundleAddStamp;
import org.stamppagetor.ui.UiBundleCopy;
import org.stamppagetor.ui.UiBundleCut;
import org.stamppagetor.ui.UiBundleDecStampSize;
import org.stamppagetor.ui.UiBundleDelete;
import org.stamppagetor.ui.UiBundleExit;
import org.stamppagetor.ui.UiBundleExportPfd;
import org.stamppagetor.ui.UiBundleImageImport;
import org.stamppagetor.ui.UiBundleImageScale;
import org.stamppagetor.ui.UiBundleIncStampSize;
import org.stamppagetor.ui.UiBundleInsert;
import org.stamppagetor.ui.UiBundleLatestFiles;
import org.stamppagetor.ui.UiBundleNewAlbum;
import org.stamppagetor.ui.UiBundleNextPage;
import org.stamppagetor.ui.UiBundleOpenAlbum;
import org.stamppagetor.ui.UiBundlePageStyleBorder;
import org.stamppagetor.ui.UiBundlePageZooming;
import org.stamppagetor.ui.UiBundlePaperOptions;
import org.stamppagetor.ui.UiBundlePaste;
import org.stamppagetor.ui.UiBundlePrevPage;
import org.stamppagetor.ui.UiBundlePrint;
import org.stamppagetor.ui.UiBundleProperties;
import org.stamppagetor.ui.UiBundleRedo;
import org.stamppagetor.ui.UiBundleRotateStamp;
import org.stamppagetor.ui.UiBundleSave;
import org.stamppagetor.ui.UiBundleSaveAs;
import org.stamppagetor.ui.UiBundleStampColoring;
import org.stamppagetor.ui.UiBundleStampShape;
import org.stamppagetor.ui.UiBundleStampTextAlign;
import org.stamppagetor.ui.UiBundleUndo;
import org.stamppagetor.ui.UiItem;

public class StampPageCreator
implements Runnable,
TreeSelectionListener,
ActionListener,
PageViewActionListener,
TableModelListener,
PropertyListener,
UiPlatform {
    private final Map<String, UiBundle> bundles = new HashMap<String, UiBundle>();
    private Collection<UiBundle> bundleValues = null;
    private final List<UiItem> uiItems = new LinkedList<UiItem>();
    private final Map<String, JMenu> menus = new HashMap<String, JMenu>();
    private StampDocument doc = null;
    private static final String programName = "Stamp Page Creator";
    private final ImageCache imageCache = ImageCache.getInstance();
    private final UndoStore undoStore = new UndoStore(15);
    private JFrame mainFrame = null;
    private JMenuBar menuBar = null;
    JPopupMenu popupMenu = null;
    private JTree treePane = null;
    private PageView viewPane = null;
    private JScrollPane viewScrollPane = null;
    private PageListView pageListView = null;
    private final JToolBar toolBar = new JToolBar("Edit Tools");
    private JMenu stampMenu = null;
    private DefaultMutableTreeNode treeRootNode = null;
    private DefaultTreeModel treeModel = null;
    private StampPrintable[] currentSelection = new StampPrintable[5];
    private StampPrintable currentObject = null;
    private int currentLevel = -1;
    private PropertyTableModel propertyModel = null;
    private PropertyPanel propertyPane = null;
    private JList undoList = new JList();
    private StampPrintable clipBoardObject = null;
    private int clipBoardLevel = -1;

    private void start(String[] stringArray) {
        StampDocument stampDocument = null;
        if (stringArray.length > 0) {
            String string = stringArray[0];
            try {
                stampDocument = StampDocument.load(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Can not read album file: '" + string + "'!", "Loading Error", 0);
                System.err.println("Can not load file " + string);
                exception.printStackTrace();
                return;
            }
        }
        try {
            stampDocument = StampDocument.load("firstdoc.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stampDocument == null) {
            stampDocument = StampDocument.createEmptyDocument();
        }
        stampDocument.setFileName(null);
        this.doc = stampDocument;
        this.reloadImageCache();
        SwingUtilities.invokeLater(this);
    }

    private void reloadImageCache() {
        String string = this.doc.getFileName();
        if (string != null) {
            this.imageCache.reloadImages(new File(string).getAbsoluteFile().getParentFile());
        }
    }

    @Override
    public void setDoc(StampDocument stampDocument) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        defaultMutableTreeNode.removeFromParent();
        this.doc = stampDocument;
        this.treePane.setModel(this.createTree(this.doc));
        this.viewPane.setDoc(this.doc);
        this.viewPane.setPage(null);
        this.pageListView.setDoc(this.doc);
        this.updateControls();
        this.reloadImageCache();
        this.mainFrame.setTitle(this.getFrameTitle());
        this.repaintViews();
    }

    @Override
    public int getSelectedPage() {
        if (this.currentLevel >= 1) {
            return this.doc.getIndexOfPage((StampPage)this.currentSelection[1]);
        }
        return 0;
    }

    @Override
    public void setSelectedPage(int n, StampPrintable stampPrintable) {
        StampPage stampPage = this.doc.getPage(n);
        if (stampPage != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeRootNode.getChildAt(n);
            if (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (stampPrintable != null) {
                    defaultMutableTreeNode2 = this.getTreeNodeByPath(this.doc.findObjectPath(stampPrintable));
                }
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                }
                this.treePane.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
                this.treePane.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            this.viewPane.setPage(stampPage);
            this.pageListView.setPage(n);
            this.viewPane.repaint();
            this.pageListView.repaint();
            this.repaintViews();
        }
    }

    private DefaultMutableTreeNode getTreeNodeByPath(DocTreePath docTreePath) {
        int[] nArray = docTreePath.getPath();
        int n = nArray.length;
        DefaultMutableTreeNode defaultMutableTreeNode = this.treeRootNode;
        if (n == 0) {
            return this.treeRootNode;
        }
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(nArray[i]);
        }
        return defaultMutableTreeNode;
    }

    private void addMenuItem(JMenu jMenu, JMenuItem jMenuItem, String string, KeyStroke keyStroke) {
        jMenuItem.setActionCommand(string);
        if (jMenu != null) {
            jMenu.add(jMenuItem);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string);
    }

    @Override
    public JMenuItem addPopUpMenuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        this.popupMenu.add(jMenuItem);
        return jMenuItem;
    }

    @Override
    public JButton createToolBarButton(String string, String string2, String string3) {
        JButton jButton = new JButton();
        jButton.setActionCommand(string);
        jButton.setToolTipText(string2);
        jButton.addActionListener(this);
        URL uRL = this.getClass().getResource(string3);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            jButton.setIcon(imageIcon);
        }
        this.toolBar.add(jButton);
        return jButton;
    }

    private String getFrameTitle() {
        String string;
        if (this.doc != null) {
            String string2 = this.doc.getFileName();
            if (string2 == null) {
                string = "New";
            } else {
                File file = new File(string2);
                string = file.getName();
            }
        } else {
            string = "No album";
        }
        return string + " - " + programName;
    }

    private void addBundle(UiBundle uiBundle) {
        this.bundles.put(uiBundle.getCommand(), uiBundle);
    }

    private void addBundleComponents() {
        Collection<UiBundle> collection = this.bundles.values();
        for (UiBundle object : collection) {
            this.uiItems.addAll(object.getUiItems());
        }
        class UiItemOrderer
        implements Comparator<UiItem> {
            UiItemOrderer() {
            }

            @Override
            public int compare(UiItem uiItem, UiItem uiItem2) {
                return uiItem.getPosition() - uiItem2.getPosition();
            }
        }
        Collections.sort(this.uiItems, new UiItemOrderer());
        for (UiItem uiItem : this.uiItems) {
            uiItem.addUiComponent(this);
        }
    }

    @Override
    public void run() {
        Object object2;
        Object object3;
        this.mainFrame = new JFrame(this.getFrameTitle());
        URL uRL = this.getClass().getResource("images/button_stamp_icon.png");
        if (uRL != null && (object3 = new ImageIcon(uRL)) != null) {
            this.mainFrame.setIconImage(((ImageIcon)object3).getImage());
        }
        this.mainFrame.setExtendedState(6);
        this.menuBar = new JMenuBar();
        this.popupMenu = new JPopupMenu();
        this.createMenu("Album");
        this.createMenu("Edit");
        this.createMenu("View");
        this.stampMenu = this.createMenu("Stamp");
        this.stampMenu.setEnabled(false);
        this.createMenu("Images");
        this.createMenu("Style");
        this.createMenu("Help");
        this.addBundle(new UiBundleNewAlbum());
        this.addBundle(new UiBundleOpenAlbum());
        this.addBundle(new UiBundleSave());
        this.addBundle(new UiBundleSaveAs());
        this.addBundle(new UiBundleExportPfd());
        this.addBundle(new UiBundlePaperOptions());
        this.addBundle(new UiBundlePrint());
        this.addBundle(new UiBundleLatestFiles(0));
        this.addBundle(new UiBundleLatestFiles(1));
        this.addBundle(new UiBundleLatestFiles(2));
        this.addBundle(new UiBundleLatestFiles(3));
        this.addBundle(new UiBundleExit(this));
        this.addBundle(new UiBundleInsert());
        this.addBundle(new UiBundleAdd());
        this.addBundle(new UiBundleDelete());
        this.addBundle(new UiBundleCut());
        this.addBundle(new UiBundleCopy());
        this.addBundle(new UiBundlePaste());
        this.addBundle(new UiBundleUndo());
        this.addBundle(new UiBundleRedo());
        this.addBundle(new UiBundleProperties());
        this.addBundle(new UiBundleNextPage());
        this.addBundle(new UiBundlePrevPage());
        this.addBundle(new UiBundlePageZooming(PageView.Zooming.ZOOM_FIT_PAGE, 1.0, 1, "Fit to page"));
        this.addBundle(new UiBundlePageZooming(PageView.Zooming.ZOOM_FIT_WIDTH, 1.0, 2, "Fit page width"));
        this.addBundle(new UiBundlePageZooming(PageView.Zooming.ZOOM_CUSTOM, 0.5, 3, "50 %"));
        this.addBundle(new UiBundlePageZooming(PageView.Zooming.ZOOM_CUSTOM, 1.0, 4, "100 %"));
        this.addBundle(new UiBundlePageZooming(PageView.Zooming.ZOOM_CUSTOM, 2.0, 5, "200 %"));
        this.addBundle(new UiBundlePageZooming(PageView.Zooming.ZOOM_CUSTOM, 4.0, 6, "400 %"));
        this.addBundle(new UiBundleIncStampSize());
        this.addBundle(new UiBundleDecStampSize());
        this.addBundle(new UiBundleRotateStamp());
        object3 = StampShape.getShapeNames();
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            object2 = (String)object4.next();
            this.addBundle(new UiBundleStampShape((String)object2));
        }
        this.addBundle(new UiBundleImageImport());
        this.addBundle(new UiBundleStampTextAlign("All center (CCC)", DocStyle.VerticalAlign.CENTER, DocStyle.VerticalAlign.CENTER, DocStyle.VerticalAlign.CENTER));
        this.addBundle(new UiBundleStampTextAlign("Top, Center, Center (TCC)", DocStyle.VerticalAlign.TOP, DocStyle.VerticalAlign.CENTER, DocStyle.VerticalAlign.CENTER));
        this.addBundle(new UiBundleStampTextAlign("Bottom, Center, Center (BCC)", DocStyle.VerticalAlign.BOTTOM, DocStyle.VerticalAlign.CENTER, DocStyle.VerticalAlign.CENTER));
        this.addBundle(new UiBundleStampTextAlign("Top, Bottom, Center (TBC)", DocStyle.VerticalAlign.TOP, DocStyle.VerticalAlign.BOTTOM, DocStyle.VerticalAlign.CENTER));
        this.addBundle(new UiBundleStampTextAlign("Bottom, Top, Center (BTC)", DocStyle.VerticalAlign.BOTTOM, DocStyle.VerticalAlign.TOP, DocStyle.VerticalAlign.CENTER));
        this.addBundle(new UiBundleImageScale(100));
        this.addBundle(new UiBundleImageScale(90));
        this.addBundle(new UiBundleImageScale(80));
        this.addBundle(new UiBundleImageScale(70));
        this.addBundle(new UiBundleStampColoring(DocStyle.ImageColouring.GRAYSCALE));
        this.addBundle(new UiBundleStampColoring(DocStyle.ImageColouring.COLOR));
        this.addBundle(new UiBundlePageStyleBorder(0, DocStyle.BorderStyle.NONE));
        this.addBundle(new UiBundlePageStyleBorder(1, DocStyle.BorderStyle.SIMPLE));
        this.addBundle(new UiBundlePageStyleBorder(2, DocStyle.BorderStyle.LEGACY));
        this.addBundle(new UiBundleAbout());
        this.addBundle(new UiBundleAddPage());
        this.addBundle(new UiBundleAddGroup());
        this.addBundle(new UiBundleAddLine());
        this.addBundle(new UiBundleAddStamp());
        this.addBundleComponents();
        this.bundleValues = this.bundles.values();
        this.toolBar.setRollover(true);
        this.treePane = new JTree(this.createTree(this.doc));
        this.treePane.getSelectionModel().setSelectionMode(1);
        object4 = new JScrollPane(this.treePane);
        this.viewPane = new PageView();
        this.viewPane.setDoc(this.doc);
        this.viewPane.addActionListener(this);
        this.pageListView = new PageListView();
        this.pageListView.setDoc(this.doc);
        this.pageListView.addActionListener(this);
        object2 = new JScrollPane(this.pageListView, 20, 31);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.viewScrollPane = new JScrollPane(this.viewPane);
        jPanel.add((Component)this.viewScrollPane, "Center");
        jPanel.add((Component)object2, "After");
        this.propertyModel = new PropertyTableModel(this, null);
        this.propertyPane = new PropertyPanel();
        this.propertyPane.setModel(this.propertyModel);
        JSplitPane jSplitPane = new JSplitPane(0, (Component)object4, this.propertyPane);
        jSplitPane.setDividerLocation(500);
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, jPanel);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerLocation(300);
        jSplitPane.setMinimumSize(new Dimension(300, 500));
        jSplitPane.setPreferredSize(new Dimension(300, 500));
        this.viewPane.setPreferredSize(new Dimension(1200, 900));
        this.viewPane.setMinimumSize(new Dimension(100, 900));
        this.pageListView.setMaximumSize(new Dimension(160, 90000));
        this.pageListView.setMinimumSize(new Dimension(160, 900));
        ((JComponent)object2).setMaximumSize(new Dimension(180, 90000));
        ((JComponent)object2).setMinimumSize(new Dimension(180, 900));
        ((JComponent)object2).setPreferredSize(new Dimension(180, 900));
        this.treePane.addTreeSelectionListener(this);
        Collection<UiBundle> collection = this.bundles.values();
        for (UiBundle object5 : collection) {
            object5.addKeyboardStuff(this);
        }
        PopupListener popupListener = new PopupListener();
        this.treePane.addMouseListener(popupListener);
        this.mainFrame.setJMenuBar(this.menuBar);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.toolBar, "First");
        jPanel2.add((Component)jSplitPane2, "Center");
        this.mainFrame.getContentPane().add(jPanel2);
        this.selectDocumentPathOfTree();
        this.updateControls();
        this.mainFrame.pack();
        this.mainFrame.setExtendedState(6);
        this.mainFrame.setVisible(true);
    }

    @Override
    public ActionListener getActionListener() {
        return this;
    }

    private JMenu createMenu(String string) {
        JMenu jMenu = this.menus.get(string);
        if (jMenu == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = "";
            String string3 = "";
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string3 = string2;
                string4 = stringTokenizer.nextToken();
                string2 = string2 + string4;
            }
            jMenu = new JMenu(string4);
            this.menus.put(string, jMenu);
            if (string3.length() > 0) {
                this.createMenu(string3).add(jMenu);
            } else {
                this.menuBar.add(jMenu);
            }
        }
        return jMenu;
    }

    @Override
    public void addMenuItem(JMenuItem jMenuItem, String string, String string2) {
        this.addMenuItem(this.createMenu(string), jMenuItem, string2, null);
    }

    @Override
    public void addMenuSeparator(String string) {
        this.createMenu(string).addSeparator();
    }

    @Override
    public void propertyValueChanged(PropertiesInterface propertiesInterface, int n, boolean bl) {
        if (bl) {
            this.repaintViews();
        } else {
            this.undoStore.addState(this, "property change");
            this.undoStore.clearRedoBuffer();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.runCommand(actionEvent.getActionCommand());
    }

    @Override
    public void runCommand(String string) {
        UiBundle uiBundle = this.bundles.get(string);
        if (uiBundle != null) {
            if (uiBundle.isUndoable()) {
                this.undoStore.addState(this, string);
                this.undoStore.clearRedoBuffer();
            }
            uiBundle.doAction(this);
        }
        this.propertyPane.dataChanged();
        this.updateControls();
        this.repaintViews();
        this.undoList.setListData(this.undoStore.getList());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.repaintViews();
    }

    @Override
    public void pagePressed(int n, StampPrintable stampPrintable) {
        this.setSelectedPage(n, stampPrintable);
    }

    private void selectDocumentPathOfTree() {
        if (this.doc != null) {
            TreePath treePath = new TreePath(this.treeRootNode.getPath());
            this.treePane.scrollPathToVisible(treePath);
            this.treePane.setSelectionPath(treePath);
        }
        this.updateControls();
    }

    @Override
    public void loadFile(File file) {
        try {
            this.setDoc(StampDocument.load(file.getAbsolutePath()));
            LatestFiles.getInstance().addFile(this.doc.getFileName());
            this.getMainFrame().setTitle(this.getFrameTitle());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Can not load album file: '" + file.getAbsolutePath() + "'!", "Loading Error", 0);
            exception.printStackTrace();
        }
    }

    private DefaultTreeModel createTree(StampDocument stampDocument) {
        this.treeRootNode = stampDocument.buildTreeNode();
        this.treeModel = new DefaultTreeModel(this.treeRootNode);
        return this.treeModel;
    }

    @Override
    public StampPlace getSelectedStamp() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePane.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        if (defaultMutableTreeNode.getLevel() != 4) {
            return null;
        }
        return (StampPlace)this.currentSelection[defaultMutableTreeNode.getLevel()];
    }

    @Override
    public void cutNode() {
        this.deleteNode(true);
    }

    @Override
    public void deleteNode() {
        this.deleteNode(false);
    }

    private void deleteNode(boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePane.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        int n = defaultMutableTreeNode.getLevel();
        if (n == 0) {
            return;
        }
        StampPrintable stampPrintable = this.currentSelection[n - 1];
        StampPrintable stampPrintable2 = this.currentSelection[n];
        if (stampPrintable2 == null || stampPrintable == null) {
            return;
        }
        if (bl) {
            this.clipBoardObject = stampPrintable2.deepCopy();
            this.clipBoardLevel = n;
        }
        stampPrintable.deleteChild(stampPrintable2);
        this.currentSelection[n] = null;
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getPath());
        this.treePane.scrollPathToVisible(treePath);
        this.treePane.setSelectionPath(treePath);
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        if (n == 1 && this.doc.getNumberOfPages() >= 1) {
            this.viewPane.setPage(this.doc.getPage(0));
            this.pageListView.setPage(0);
        } else {
            this.viewPane.setPage((StampPage)this.currentSelection[1]);
            this.pageListView.setPage(this.doc.getIndexOfPage((StampPage)this.currentSelection[1]));
        }
        this.repaintViews();
    }

    @Override
    public void copyNode() {
        this.clipBoardObject = null;
        this.clipBoardLevel = -1;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePane.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        int n = defaultMutableTreeNode.getLevel();
        if (n == 0) {
            return;
        }
        StampPrintable stampPrintable = this.currentSelection[n];
        if (stampPrintable == null) {
            return;
        }
        this.clipBoardObject = stampPrintable.deepCopy();
        this.clipBoardLevel = n;
    }

    @Override
    public void pasteNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePane.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        int n = defaultMutableTreeNode.getLevel();
        StampPrintable stampPrintable = this.clipBoardObject.deepCopy();
        if (stampPrintable == null || this.clipBoardLevel == -1) {
            return;
        }
        if (this.currentObject == null) {
            return;
        }
        if (n + 1 != this.clipBoardLevel) {
            return;
        }
        this.currentObject.add(stampPrintable);
        DefaultMutableTreeNode defaultMutableTreeNode2 = stampPrintable.buildTreeNode();
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.repaintViews();
    }

    @Override
    public void addNode(int n, StampPrintable stampPrintable) {
        StampPrintable stampPrintable2 = this.currentSelection[n - 1];
        StampPrintable stampPrintable3 = this.currentSelection[n];
        if (stampPrintable2 == null) {
            return;
        }
        int n2 = stampPrintable2.insertChild(stampPrintable, stampPrintable3);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(stampPrintable);
        TreePath treePath = this.treePane.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(n - 1);
        this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
        this.treePane.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
        this.treePane.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        this.repaintViews();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePane.getLastSelectedPathComponent();
        StampPrintable stampPrintable = this.currentSelection[1];
        this.currentLevel = -1;
        this.currentObject = null;
        for (n = 0; n < 5; ++n) {
            this.currentSelection[n] = null;
        }
        if (defaultMutableTreeNode == null) {
            this.stampMenu.setEnabled(false);
            this.updateControls();
            return;
        }
        int n2 = n = (this.currentLevel = defaultMutableTreeNode.getLevel());
        this.currentSelection[n2--] = (StampPrintable)defaultMutableTreeNode.getUserObject();
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) {
            this.currentSelection[n2--] = (StampPrintable)defaultMutableTreeNode2.getUserObject();
        }
        this.stampMenu.setEnabled(n == 4);
        this.viewPane.setSelection((StampPrintable)defaultMutableTreeNode.getUserObject());
        boolean bl = false;
        if (this.currentObject != defaultMutableTreeNode.getUserObject()) {
            this.currentObject = (StampPrintable)defaultMutableTreeNode.getUserObject();
            bl = true;
        }
        if (bl || this.currentSelection[1] != stampPrintable) {
            this.viewPane.setPage((StampPage)this.currentSelection[1]);
            this.pageListView.setPage(this.doc.getIndexOfPage((StampPage)this.currentSelection[1]));
        }
        this.updateControls();
    }

    @Override
    public int getClipboardLevel() {
        return this.clipBoardLevel;
    }

    private void updateControls() {
        this.propertyModel = new PropertyTableModel(this, this.currentObject);
        this.propertyPane.setModel(this.propertyModel);
        this.mainFrame.setTitle(this.getFrameTitle());
        for (UiBundle uiBundle : this.bundleValues) {
            uiBundle.checkStatesOfUiComponents(this);
        }
    }

    private void repaintViews() {
        this.viewPane.repaint();
        this.pageListView.updatePages();
        this.pageListView.repaint();
        this.treePane.repaint();
        this.propertyPane.repaint();
    }

    @Override
    public JTree getTreePane() {
        return this.treePane;
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public UndoStore getUndoStore() {
        return this.undoStore;
    }

    @Override
    public StampPrintable getCurrentObject() {
        return this.currentObject;
    }

    @Override
    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public ImageCache getImageCache() {
        return this.imageCache;
    }

    @Override
    public PageView getPageView() {
        return this.viewPane;
    }

    @Override
    public StampDocument getDoc() {
        return this.doc;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Can not change look and feel");
        }
        StampPageCreator stampPageCreator = new StampPageCreator();
        stampPageCreator.start(stringArray);
    }

    @Override
    public void pagePopUp(int n, StampPrintable stampPrintable, Component component, int n2, int n3) {
        this.popupMenu.show(component, n2, n3);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                StampPageCreator.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

