/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.stamppagetor.DocStyle;
import org.stamppagetor.ImageCache;
import org.stamppagetor.Misc;
import org.stamppagetor.StampPlaceText;
import org.stamppagetor.StampPrintable;
import org.stamppagetor.StampShape;
import org.stamppagetor.property.PropertyInfo;
import org.stamppagetor.property.PropertyInfoImage;
import org.stamppagetor.property.PropertyInfoInteger;
import org.stamppagetor.property.PropertyInfoString;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StampPlace
extends StampPrintable {
    public static final String XML_NODE_NAME = "stamp";
    private static Dimension lastSizeSetting = new Dimension(25, 35);
    private static StampPlaceText[] lastTexts = new StampPlaceText[]{new StampPlaceText("price"), new StampPlaceText("color"), new StampPlaceText("")};
    private static final int xspace = 5;
    private static final int yspace = 5;
    private static final int textSpacing = 1;
    private static final float lineWeight = 0.5f;
    private static final float MM_TO_POINTS = 2.8346457f;
    private int xsize = 28;
    private int ysize = 40;
    private String shape = "rect";
    private String imageName = null;
    private static final PropertyInfo[] properties = new PropertyInfo[]{new PropertyInfoInteger("Stamp width (mm)", null), new PropertyInfoInteger("Stamp heigh (mm)", null), new PropertyInfoString("Text1", null), new PropertyInfoString("Text2", null), new PropertyInfoString("Text3", null), new PropertyInfoString("Shape", StampShape.getShapeNameArray()), new PropertyInfoImage("Image file")};

    public StampPlace() {
        this.xsize = StampPlace.lastSizeSetting.width;
        this.ysize = StampPlace.lastSizeSetting.height;
        for (StampPlaceText stampPlaceText : lastTexts) {
            this.parts.add(stampPlaceText.deepCopy());
        }
    }

    public StampPlace(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().compareTo("text") == 0) {
                this.parts.add(new StampPlaceText(node2));
            }
            if (node2.getNodeName().compareTo("xsize") == 0) {
                this.xsize = Integer.parseInt(node2.getTextContent());
            }
            if (node2.getNodeName().compareTo("ysize") == 0) {
                this.ysize = Integer.parseInt(node2.getTextContent());
            }
            if (node2.getNodeName().compareTo("shape") == 0) {
                this.shape = node2.getTextContent();
            }
            if (node2.getNodeName().compareTo("image") != 0) continue;
            this.imageName = node2.getTextContent();
        }
    }

    public StampPlace(StampPlace stampPlace) {
        super(stampPlace);
        this.xsize = stampPlace.xsize;
        this.ysize = stampPlace.ysize;
        this.shape = stampPlace.shape;
        this.imageName = stampPlace.imageName;
        lastSizeSetting.setSize(stampPlace.xsize, stampPlace.ysize);
    }

    @Override
    public StampPrintable deepCopy() {
        return new StampPlace(this);
    }

    @Override
    public void toXml(PrintStream printStream, String string) {
        string = string + "  ";
        printStream.println(string + "<stamp>");
        printStream.println(string + "  <xsize>" + this.xsize + "</xsize>");
        printStream.println(string + "  <ysize>" + this.ysize + "</ysize>");
        printStream.println(string + "  <shape>" + Misc.covertToXmlString(this.shape) + "</shape>");
        if (this.imageName != null) {
            printStream.println(string + "  <image>" + Misc.covertToXmlString(this.imageName) + "</image>");
        }
        for (StampPrintable stampPrintable : this.parts) {
            stampPrintable.toXml(printStream, string);
        }
        printStream.println(string + "</stamp>");
    }

    @Override
    public void print(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        Object object;
        this.printRect(graphics, stampPrintable, rectangle);
        int n = this.getTopTextsHeight(docStyle);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + n, this.getStampBoxWidth(), this.getStampBoxHeight());
        this.printParts(graphics, docStyle, stampPrintable, rectangle);
        if (this.imageName != null) {
            BufferedImage bufferedImage;
            object = ImageCache.getInstance();
            switch (docStyle.getStampImageColouring()) {
                case GRAYSCALE: {
                    bufferedImage = ((ImageCache)object).getGrayscaleImage(this.imageName);
                    break;
                }
                case COLOR: {
                    bufferedImage = ((ImageCache)object).getColorImage(this.imageName);
                    break;
                }
                default: {
                    bufferedImage = null;
                }
            }
            if (bufferedImage != null) {
                Rectangle rectangle3 = new Rectangle(rectangle2.x + 5, rectangle2.y + 6, (int)((float)this.xsize * 2.8346457f), (int)((float)this.ysize * 2.8346457f));
                int n2 = 100 - docStyle.getStampImageScaler();
                Rectangle rectangle4 = new Rectangle(rectangle3.x + rectangle3.width * n2 / 200, rectangle3.y + rectangle3.height * n2 / 200, rectangle3.width - rectangle3.width * n2 / 100, rectangle3.height - rectangle3.height * n2 / 100);
                graphics.drawImage(bufferedImage, rectangle4.x, rectangle4.y, rectangle4.x + rectangle4.width, rectangle4.y + rectangle4.height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            }
        }
        if (this.shape != null) {
            object = StampShape.getShape(this.shape);
            if (object != null) {
                ((StampShape)object).draw((Graphics2D)graphics, rectangle2);
            } else {
                System.out.println("invalid shape: '" + this.shape + "'");
            }
        } else {
            System.out.println("null shape");
        }
    }

    @Override
    public StampPrintable checkPoint(Rectangle rectangle, int n, int n2, DocStyle docStyle) {
        if (rectangle.contains(n, n2)) {
            return this;
        }
        return null;
    }

    @Override
    protected Rectangle[] getPartPlaces(Rectangle rectangle, DocStyle docStyle) {
        int n = this.parts.size();
        Rectangle[] rectangleArray = new Rectangle[n];
        int n2 = this.getTopTextsHeight(docStyle);
        int n3 = this.getCenterTextsHeight(docStyle) + (n - 1) * 1;
        int n4 = this.getStampBoxHeight();
        int n5 = (int)(5.25f + (float)((n4 - n3) / 2));
        block5: for (int i = 0; i < n; ++i) {
            StampPrintable stampPrintable = this.parts.elementAt(i);
            int n6 = stampPrintable.getHeight(docStyle);
            switch (docStyle.getStampTextVerticalAlign(i)) {
                case TOP: {
                    rectangleArray[i] = new Rectangle(0, 0, (int)((float)this.xsize * 2.8346457f + 10.0f), n6);
                    continue block5;
                }
                case CENTER: {
                    rectangleArray[i] = new Rectangle(5, n5, (int)((float)this.xsize * 2.8346457f), n6);
                    n5 += stampPrintable.getHeight(docStyle) + 1;
                    continue block5;
                }
                case BOTTOM: {
                    rectangleArray[i] = new Rectangle(0, n2 + n4, (int)((float)this.xsize * 2.8346457f + 10.0f), n6);
                }
            }
        }
        return rectangleArray;
    }

    private int getTextsHeight(DocStyle docStyle, DocStyle.VerticalAlign verticalAlign, boolean bl) {
        int n = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (docStyle.getStampTextVerticalAlign(i) != verticalAlign) continue;
            if (bl) {
                n += this.parts.elementAt(i).getHeight(docStyle);
                continue;
            }
            n = Math.max(n, this.parts.elementAt(i).getHeight(docStyle));
        }
        return n;
    }

    private int getTopTextsHeight(DocStyle docStyle) {
        return this.getTextsHeight(docStyle, DocStyle.VerticalAlign.TOP, false);
    }

    private int getBottomTextsHeight(DocStyle docStyle) {
        return this.getTextsHeight(docStyle, DocStyle.VerticalAlign.BOTTOM, false);
    }

    private int getCenterTextsHeight(DocStyle docStyle) {
        return this.getTextsHeight(docStyle, DocStyle.VerticalAlign.CENTER, true);
    }

    private int getStampBoxHeight() {
        return (int)((float)this.ysize * 2.8346457f + 1.0f + 10.0f);
    }

    private int getStampBoxWidth() {
        return (int)((float)this.xsize * 2.8346457f + 11.0f);
    }

    @Override
    protected int getHeight(DocStyle docStyle) {
        return this.getStampBoxHeight() + this.getTopTextsHeight(docStyle) + this.getBottomTextsHeight(docStyle);
    }

    @Override
    protected int getWidth(DocStyle docStyle) {
        return this.getStampBoxWidth();
    }

    @Override
    public DefaultMutableTreeNode buildTreeNode() {
        return new DefaultMutableTreeNode(this);
    }

    public String toString() {
        return "Stamp: " + this.getTextSring();
    }

    public void setSize(Dimension dimension) {
        this.xsize = dimension.width;
        this.ysize = dimension.height;
        lastSizeSetting.setSize(dimension);
    }

    public Dimension getSize() {
        return new Dimension(this.xsize, this.ysize);
    }

    public void setShape(String string) {
        this.shape = string;
    }

    public String getShape() {
        return this.shape;
    }

    public void rotate() {
        int n = this.ysize;
        this.ysize = this.xsize;
        this.xsize = n;
        lastSizeSetting.setSize(this.xsize, this.ysize);
    }

    private String getTextSring() {
        StringBuffer stringBuffer = new StringBuffer();
        for (StampPrintable stampPrintable : this.parts) {
            stringBuffer.append(((StampPlaceText)stampPrintable).getText() + " ");
        }
        return stringBuffer.toString();
    }

    public void setText(int n, String string) {
        StampPlaceText stampPlaceText = new StampPlaceText(string);
        this.parts.setElementAt(stampPlaceText, n);
        StampPlace.lastTexts[n] = stampPlaceText;
    }

    public String getText(int n) {
        return ((StampPlaceText)this.parts.elementAt(n)).getText();
    }

    @Override
    public int getPropertyCount() {
        return properties.length;
    }

    @Override
    public PropertyInfo getPropertyInfo(int n) {
        return properties[n];
    }

    @Override
    public Object getPropertyValue(int n) {
        switch (n) {
            case 0: {
                return new Integer(this.xsize);
            }
            case 1: {
                return new Integer(this.ysize);
            }
            case 2: {
                return this.getText(0);
            }
            case 3: {
                return this.getText(1);
            }
            case 4: {
                return this.getText(2);
            }
            case 5: {
                return this.shape;
            }
            case 6: {
                return this.imageName;
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        try {
            switch (n) {
                case 0: {
                    this.xsize = (Integer)object;
                    break;
                }
                case 1: {
                    this.ysize = (Integer)object;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.setText(n - 2, (String)object);
                    break;
                }
                case 5: {
                    this.shape = (String)object;
                    break;
                }
                case 6: {
                    this.imageName = (String)object;
                    break;
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid property value!", "Error", 0);
        }
    }
}

