/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.stamppagetor.DocStyle;
import org.stamppagetor.DocTreePath;
import org.stamppagetor.property.PropertiesInterface;
import org.stamppagetor.property.PropertyInfo;

public abstract class StampPrintable
implements PropertiesInterface {
    protected final Vector<StampPrintable> parts = new Vector();
    private static final BasicStroke selectionBoxLine = new BasicStroke(3.0f);
    private static final Color selectionBoxColor = new Color(255, 0, 0);

    public StampPrintable() {
    }

    public StampPrintable(StampPrintable stampPrintable) {
        for (StampPrintable stampPrintable2 : stampPrintable.parts) {
            this.parts.add(stampPrintable2.deepCopy());
        }
    }

    public abstract void print(Graphics var1, DocStyle var2, StampPrintable var3, Rectangle var4);

    public void printParts(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        Rectangle[] rectangleArray = this.getPartPlaces(rectangle, docStyle);
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle2 = rectangleArray[i];
            Rectangle rectangle3 = new Rectangle(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y, rectangle2.width, rectangle2.height);
            this.parts.elementAt(i).print(graphics, docStyle, stampPrintable, rectangle3);
        }
    }

    public StampPrintable checkPoint(Rectangle rectangle, int n, int n2, DocStyle docStyle) {
        if (rectangle.contains(n, n2)) {
            Rectangle[] rectangleArray = this.getPartPlaces(rectangle, docStyle);
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (!rectangleArray[i].contains(n, n2)) continue;
                rectangleArray[i].x = 0;
                rectangleArray[i].y = 0;
                return this.parts.elementAt(i).checkPoint(rectangleArray[i], n -= rectangleArray[i].x, n2 -= rectangleArray[i].y, docStyle);
            }
            return this;
        }
        return null;
    }

    protected abstract Rectangle[] getPartPlaces(Rectangle var1, DocStyle var2);

    public DocTreePath findObjectPath(StampPrintable stampPrintable) {
        if (stampPrintable == this) {
            return new DocTreePath();
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            DocTreePath docTreePath = this.parts.elementAt(i).findObjectPath(stampPrintable);
            if (docTreePath == null) continue;
            docTreePath.addParent(i);
            return docTreePath;
        }
        return null;
    }

    public abstract void toXml(PrintStream var1, String var2);

    public abstract StampPrintable deepCopy();

    public int insertChild(StampPrintable stampPrintable, StampPrintable stampPrintable2) {
        int n = stampPrintable2 == null ? this.parts.size() : this.parts.indexOf(stampPrintable2);
        this.parts.insertElementAt(stampPrintable, n);
        return n;
    }

    public int deleteChild(StampPrintable stampPrintable) {
        int n = this.parts.indexOf(stampPrintable);
        this.parts.remove(n);
        return n;
    }

    protected int getHeight(DocStyle docStyle) {
        return 0;
    }

    protected int getWidth(DocStyle docStyle) {
        return 0;
    }

    public void add(StampPrintable stampPrintable) {
        this.parts.add(stampPrintable);
    }

    void printRect(Graphics graphics, StampPrintable stampPrintable, Rectangle rectangle) {
        if (stampPrintable == this) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(selectionBoxColor);
            graphics2D.setStroke(selectionBoxLine);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(color);
        }
    }

    @Override
    public int getPropertyCount() {
        return 0;
    }

    @Override
    public PropertyInfo getPropertyInfo(int n) {
        return null;
    }

    @Override
    public Object getPropertyValue(int n) {
        return null;
    }

    @Override
    public void setPropertyValue(int n, Object object) {
    }

    public DefaultMutableTreeNode buildTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this);
        for (StampPrintable stampPrintable : this.parts) {
            defaultMutableTreeNode.add(stampPrintable.buildTreeNode());
        }
        return defaultMutableTreeNode;
    }
}

