/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.stamppagetor.AbstractWizardDialog;
import org.stamppagetor.image.ImageEditControl;
import org.stamppagetor.image.ImageFilenameFilter;
import org.stamppagetor.image.ImagePickerInterface;
import org.stamppagetor.image.ImagePickerPolygonSimplify;
import org.stamppagetor.image.ImagePickerWorker;
import org.stamppagetor.image.ImageViewer;
import org.stamppagetor.image.ImageViewerWithDraws;

public class ImageImportWizard
extends AbstractWizardDialog
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -554990417561934465L;
    private static final Dimension stampViewSize = new Dimension(200, 150);
    private static final int SELECT_FILE_PANEL_INDEX = 0;
    private static final int SEARCH_PARTS_PANEL_INDEX = 1;
    private static final int MODIFY_IMAGES_PANEL_INDEX = 2;
    private static final String[] PANEL_NAMES = new String[]{"Select", "Check", "Modify"};
    private static final String[] PANEL_HELPS = new String[]{"Select source image file. Good source image has solid background color. Good background colors are: black, green, blue and red.", "Check result of image analyzing. If the analyze fails, then step back and try with another image.", "Modify stamp images. Rotate images correctly, and remove useless images. Then save by pressing Finish."};
    private static final String[] PANEL_IMAGE_NAMES = new String[]{new String("images/wizard_image_file.png"), new String("images/wizard_analyze.png"), new String("images/wizard_modify.png")};
    private static final ImageIcon[] panelIcons = new ImageIcon[PANEL_IMAGE_NAMES.length];
    private final JFileChooser fileChooser = new JFileChooser();
    private ImageViewer imageViewer = new ImageViewer();
    private final ImageViewerWithDraws searchImage = new ImageViewerWithDraws();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private final JLabel phaseLabel = new JLabel("");
    private final JPanel stampImagesPane = new JPanel();
    private final ImageEditControl imageEditor = new ImageEditControl();
    private ImageIcon sourceIcon = null;
    private File sourceFile = null;
    private ImagePickerInterface picker = null;
    private ImagePickerWorker pickerTask = null;
    private boolean pickerRunning = false;
    private int imagesPicked = -1;
    private final File targetDirectory;

    public ImageImportWizard(JFrame jFrame, File file) {
        super(jFrame, "Image Import Wizard", PANEL_NAMES);
        this.targetDirectory = file;
    }

    @Override
    protected ImageIcon getPanelIcon(int n) {
        return panelIcons[n];
    }

    @Override
    protected String getPanelHelp(int n) {
        return PANEL_HELPS[n];
    }

    @Override
    protected boolean isStepToCardPossible(int n) {
        if (!super.isStepToCardPossible(n)) {
            return false;
        }
        if (n == 1 && !this.isImageFileSelected()) {
            return false;
        }
        if (this.pickerRunning) {
            return false;
        }
        return n != 2 || this.imagesPicked > 0;
    }

    @Override
    protected void cardChanged(int n, int n2) {
        if (n == 0 && n2 == 1) {
            this.startPickerProcess();
        } else if (n == 1 && n2 == 2) {
            this.imageEditor.setImages(this.picker.getImages());
        }
    }

    @Override
    protected void finish() {
        Vector<BufferedImage> vector = this.imageEditor.getImages();
        for (BufferedImage bufferedImage : vector) {
            try {
                File file = File.createTempFile("image", ".png", this.targetDirectory);
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
            catch (IOException iOException) {
                System.err.println("Can not save image");
            }
        }
        this.setVisible(false);
    }

    @Override
    protected Component createCardPanel(int n) {
        switch (n) {
            case 0: {
                return this.CreateSelectFilePanel();
            }
            case 1: {
                return this.CreateSearchPartsPanel();
            }
            case 2: {
                return this.imageEditor;
            }
        }
        return null;
    }

    private Component CreateSelectFilePanel() {
        this.fileChooser.setFileFilter(new ImageFilenameFilter());
        this.fileChooser.setControlButtonsAreShown(true);
        this.fileChooser.addActionListener(this);
        this.fileChooser.setBorder(BorderFactory.createTitledBorder("File Chooser"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Image"));
        jPanel.setPreferredSize(new Dimension(400, 500));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.imageViewer, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.fileChooser, "West");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    private Component CreateSearchPartsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Analyze of Source Image"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.searchImage, "Center");
        JPanel jPanel2 = new JPanel();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        jPanel2.add(new JLabel("Progress:"));
        jPanel2.add(this.progressBar);
        jPanel2.add(this.phaseLabel);
        jPanel2.setLayout(new FlowLayout(0));
        this.stampImagesPane.setLayout(new BoxLayout(this.stampImagesPane, 3));
        ImageViewer imageViewer = new ImageViewer();
        imageViewer.setPreferredSize(stampViewSize);
        this.stampImagesPane.add(imageViewer);
        JScrollPane jScrollPane = new JScrollPane(this.stampImagesPane, 22, 30);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Stamp Images"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "South");
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jScrollPane, "East");
        return jPanel3;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.getCardIndex() == 0) {
            if (string.equals("ApproveSelection")) {
                this.loadImageFile();
            } else if (string.equals("CancelSelection")) {
                this.setVisible(false);
            }
        }
        super.actionPerformed(actionEvent);
    }

    private void loadImageFile() {
        File file = this.fileChooser.getSelectedFile();
        if (file != null && !file.equals(this.sourceFile)) {
            this.sourceFile = file;
            this.sourceIcon = new ImageIcon(file.getAbsolutePath(), file.getAbsolutePath());
            this.imageViewer.setImage(this.sourceIcon.getImage());
        }
    }

    private boolean isImageFileSelected() {
        return this.sourceFile != null && this.sourceIcon != null && this.sourceIcon.getImageLoadStatus() == 8;
    }

    private void startPickerProcess() {
        this.phaseLabel.setText("");
        this.progressBar.setValue(0);
        this.searchImage.setImage(null);
        this.stampImagesPane.removeAll();
        this.pickerRunning = true;
        this.imagesPicked = -1;
        this.picker = new ImagePickerPolygonSimplify();
        this.picker.setSourceFile(this.sourceFile);
        this.pickerTask = new ImagePickerWorker(this.picker);
        this.pickerTask.addPropertyChangeListener(this);
        this.pickerTask.execute();
        this.updateWizardButtonEnables();
    }

    private void postWorkPicker() {
        this.pickerRunning = false;
        this.progressBar.setValue(100);
        this.searchImage.setImage(this.picker.getOriginalImage());
        Vector<BufferedImage> vector = this.picker.getImages();
        this.searchImage.clearElements();
        Vector<Polygon> vector2 = this.picker.getCropPolygons();
        for (Polygon object : vector2) {
            this.searchImage.addPolygon(object, Color.CYAN);
        }
        this.imagesPicked = vector.size();
        this.stampImagesPane.removeAll();
        for (int i = 0; i < this.imagesPicked; ++i) {
            BufferedImage bufferedImage = vector.elementAt(i);
            ImageViewer imageViewer = new ImageViewer();
            imageViewer.setPreferredSize(stampViewSize);
            imageViewer.setImage(bufferedImage);
            this.stampImagesPane.add(imageViewer);
        }
        if (this.imagesPicked == 0) {
            this.phaseLabel.setText("No stamps found!");
        }
        this.updateWizardButtonEnables();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("progress".equals(string)) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressBar.setValue(n);
        } else if ("progressPhase".equals(string)) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.phaseLabel.setText(this.picker.getPhaseName(n));
            if (this.picker.isFinalPhase(n)) {
                this.postWorkPicker();
            }
        }
    }

    static {
        for (int i = 0; i < panelIcons.length; ++i) {
            URL uRL = ImageImportWizard.class.getResource(PANEL_IMAGE_NAMES[i]);
            if (uRL == null) continue;
            ImageImportWizard.panelIcons[i] = new ImageIcon(uRL);
        }
    }
}

