/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.io.Opener;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class SimpleCommands
implements PlugIn {
    static String searchArg;
    private static String[] choices;
    private static int choiceIndex;

    public void run(String arg) {
        if (arg.equals("search")) {
            this.search();
        } else if (arg.equals("import")) {
            Opener.openResultsTable("");
        } else if (arg.equals("rename")) {
            this.rename();
        } else if (arg.equals("reset")) {
            this.reset();
        } else if (arg.equals("about")) {
            this.aboutPluginsHelp();
        } else if (arg.equals("install")) {
            this.installation();
        } else if (arg.equals("remove")) {
            this.removeStackLabels();
        } else if (arg.equals("itor")) {
            this.imageToResults();
        } else if (arg.equals("rtoi")) {
            this.resultsToImage();
        }
    }

    private void reset() {
        GenericDialog gd = new GenericDialog("");
        gd.addChoice("Reset:", choices, choices[choiceIndex]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        choiceIndex = gd.getNextChoiceIndex();
        switch (choiceIndex) {
            case 0: {
                this.unlock();
                break;
            }
            case 1: {
                this.resetClipboard();
                break;
            }
            case 2: {
                this.resetUndo();
            }
        }
    }

    private void unlock() {
        ImagePlus imp = IJ.getImage();
        boolean wasUnlocked = imp.lockSilently();
        if (wasUnlocked) {
            IJ.showStatus("\"" + imp.getTitle() + "\" is not locked");
        } else {
            IJ.showStatus("\"" + imp.getTitle() + "\" is now unlocked");
            IJ.beep();
        }
        imp.unlock();
    }

    private void resetClipboard() {
        ImagePlus.resetClipboard();
        IJ.showStatus("Clipboard reset");
    }

    private void resetUndo() {
        Undo.setup(0, null);
        IJ.showStatus("Undo reset");
    }

    private void rename() {
        ImagePlus imp = IJ.getImage();
        GenericDialog gd = new GenericDialog("Rename");
        gd.addStringField("Title:", imp.getTitle(), 30);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        imp.setTitle(gd.getNextString());
    }

    private void search() {
        searchArg = IJ.runMacroFile("ij.jar:Search", searchArg);
    }

    private void installation() {
        String url = "http://imagej.nih.gov/ij/docs/install/";
        if (IJ.isMacintosh()) {
            url = url + "osx.html";
        } else if (IJ.isWindows()) {
            url = url + "windows.html";
        } else if (IJ.isLinux()) {
            url = url + "linux.html";
        }
        IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
    }

    private void aboutPluginsHelp() {
        IJ.showMessage("\"About Plugins\" Submenu", "Plugins packaged as JAR files can add entries\nto this submenu. There is an example at\n \nhttp://imagej.nih.gov/ij/plugins/jar-demo.html");
    }

    private void removeStackLabels() {
        ImagePlus imp = IJ.getImage();
        int size = imp.getStackSize();
        if (size == 1) {
            IJ.error("Stack required");
        } else {
            ImageStack stack = imp.getStack();
            for (int i = 1; i <= size; ++i) {
                stack.setSliceLabel(null, i);
            }
            imp.repaintWindow();
        }
    }

    private void imageToResults() {
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        ResultsTable rt = ResultsTable.createTableFromImage(ip);
        rt.showRowNumbers(false);
        rt.show("Results");
    }

    private void resultsToImage() {
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt == null || rt.getCounter() == 0) {
            IJ.error("Results to Image", "The Results table is empty");
            return;
        }
        ImageProcessor ip = rt.getTableAsImage();
        if (ip == null) {
            return;
        }
        new ImagePlus("Results Table", ip).show();
    }

    static {
        choices = new String[]{"Locked Image", "Clipboard", "Undo Buffer"};
        choiceIndex = 0;
    }
}

