/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.bric.gui.About;
import org.bric.gui.output.ProgressBarFrame;
import org.bric.gui.preferences.PreferencesFrame;
import org.bric.gui.tabs.ImageEditTab;
import org.bric.gui.tabs.OutputJPanel;
import org.bric.gui.tabs.ResizeJPanel;
import org.bric.gui.tabs.RotateJPanel;
import org.bric.gui.tabs.WatermarkJPanel;
import org.bric.imageEditParameters.ImageEditParameters;
import org.bric.imageEditParameters.OutputParameters;
import org.bric.imageEditParameters.ResizeParameters;
import org.bric.imageEditParameters.RotateParameters;
import org.bric.imageEditParameters.WatermarkParameters;
import org.bric.input.ImportedImage;
import org.bric.processor.ImageProcessHandler;
import org.bric.utils.ArrayListTransferHandler;
import org.bric.utils.Utils;

public class BricUI
extends JFrame {
    DefaultListModel model = new DefaultListModel();
    static int duplicateAction = 4;
    int previewState;
    public final ImageIcon DEFAULT_ICON = new ImageIcon(this.getClass().getResource("/resource/preview.png"));
    private PreferencesFrame preferencesFrame = new PreferencesFrame();
    private About aboutFrame = new About();
    public static String lastOpenedDirectory = "";
    List<String> imagesList;
    ArrayListTransferHandler arrayListHandler;
    JFileChooser propertiesChooser;
    Properties properties;
    Locale greek = new Locale("el", "GR");
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTextPane jTextPane1;
    private JToggleButton jToggleButton1;
    private static HashSet<String> hash = new HashSet();

    public BricUI() {
        this.initComponents();
        this.arrayListHandler = new ArrayListTransferHandler();
        this.jList1.setModel(this.model);
        this.jList1.setTransferHandler(this.arrayListHandler);
        this.jList1.setDragEnabled(true);
        this.jTabbedPane1.add("Output", new OutputJPanel());
        this.jTabbedPane1.add("Resize", new ResizeJPanel());
        this.jTabbedPane1.add("Rotate", new RotateJPanel());
        this.jTabbedPane1.add("Watermark", new WatermarkJPanel());
        this.properties = new Properties();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resource/logo.png")));
        this.initializeProperties();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton4 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel8 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("lang/gui/Bundle");
        this.setTitle(bundle.getString("BricUI.title"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/clasp.png")));
        this.jToggleButton1.setText(bundle.getString("BricUI.jToggleButton1.text"));
        this.jToggleButton1.setToolTipText(bundle.getString("BricUI.jToggleButton1.toolTipText"));
        this.jToggleButton1.setBorderPainted(false);
        this.jToggleButton1.setContentAreaFilled(false);
        this.jToggleButton1.setPressedIcon(new ImageIcon(this.getClass().getResource("/resource/icons/clasp_r.png")));
        this.jToggleButton1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/clasp_r.png")));
        this.jToggleButton1.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/resource/icons/clasp_r.png")));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resource/icons/clasp_p.png")));
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/refresh.png")));
        this.jButton5.setText(bundle.getString("BricUI.jButton5.text"));
        this.jButton5.setToolTipText(bundle.getString("BricUI.jButton5.toolTipText"));
        this.jButton5.setBorderPainted(false);
        this.jButton5.setContentAreaFilled(false);
        this.jButton5.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/refresh_p.png")));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/configuration.png")));
        this.jButton6.setText(bundle.getString("BricUI.jButton6.text"));
        this.jButton6.setToolTipText(bundle.getString("BricUI.jButton6.toolTipText"));
        this.jButton6.setBorderPainted(false);
        this.jButton6.setContentAreaFilled(false);
        this.jButton6.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/configuration_p.png")));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/tick.png")));
        this.jButton7.setText(bundle.getString("BricUI.jButton7.text"));
        this.jButton7.setToolTipText(bundle.getString("BricUI.jButton7.toolTipText"));
        this.jButton7.setBorderPainted(false);
        this.jButton7.setContentAreaFilled(false);
        this.jButton7.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/tick_p.png")));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton7ActionPerformed(evt);
            }
        });
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/photo-camera.png")));
        this.jButton4.setText(bundle.getString("BricUI.jButton4.text"));
        this.jButton4.setToolTipText(bundle.getString("BricUI.jButton4.toolTipText"));
        this.jButton4.setBorderPainted(false);
        this.jButton4.setContentAreaFilled(false);
        this.jButton4.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/photo-camera_p.png")));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/disc-floopy.png")));
        this.jButton8.setText(bundle.getString("BricUI.jButton8.text"));
        this.jButton8.setToolTipText(bundle.getString("BricUI.jButton8.toolTipText"));
        this.jButton8.setBorderPainted(false);
        this.jButton8.setContentAreaFilled(false);
        this.jButton8.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/disc-floopy_p.png")));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButton9.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/disc-cd.png")));
        this.jButton9.setText(bundle.getString("BricUI.jButton9.text"));
        this.jButton9.setToolTipText(bundle.getString("BricUI.jButton9.toolTipText"));
        this.jButton9.setBorderPainted(false);
        this.jButton9.setContentAreaFilled(false);
        this.jButton9.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/disc-cd_p.png")));
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton9ActionPerformed(evt);
            }
        });
        this.jButton10.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/info.png")));
        this.jButton10.setToolTipText(bundle.getString("BricUI.jButton10.toolTipText"));
        this.jButton10.setBorderPainted(false);
        this.jButton10.setContentAreaFilled(false);
        this.jButton10.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/info_p.png")));
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton10ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton6, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton10, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButton1, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton8, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9, -2, 32, -2).addGap(210, 210, 210).addComponent(this.jButton4, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7, -2, 35, -2).addGap(9, 9, 9)));
        jPanel1Layout.linkSize(0, this.jButton10, this.jButton5);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton1, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton9, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton10, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)))));
        this.jSplitPane1.setDividerLocation(355);
        this.jSplitPane1.setResizeWeight(0.3);
        this.jTabbedPane1.setMinimumSize(new Dimension(370, 480));
        this.jSplitPane1.setRightComponent(this.jTabbedPane1);
        this.jPanel8.setMinimumSize(new Dimension(355, 480));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/add.png")));
        this.jButton1.setText(bundle.getString("BricUI.jButton1.text"));
        this.jButton1.setToolTipText(bundle.getString("BricUI.jButton1.toolTipText"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/add_p.png")));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/remove.png")));
        this.jButton2.setText(bundle.getString("BricUI.jButton2.text"));
        this.jButton2.setToolTipText(bundle.getString("BricUI.jButton2.toolTipText"));
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/remove_p.png")));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/resource/icons/error.png")));
        this.jButton3.setText(bundle.getString("BricUI.jButton3.text"));
        this.jButton3.setToolTipText(bundle.getString("BricUI.jButton3.toolTipText"));
        this.jButton3.setBorderPainted(false);
        this.jButton3.setContentAreaFilled(false);
        this.jButton3.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resource/icons/error_p.png")));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BricUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("DejaVu Sans Light", 0, 14));
        this.jLabel1.setText(bundle.getString("BricUI.jLabel1.text"));
        this.jPanel2.setBorder(new SoftBevelBorder(0));
        this.jPanel2.setMinimumSize(new Dimension(167, 136));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/resource/preview.png")));
        this.jLabel2.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel2.setMaximumSize(new Dimension(130, 130));
        this.jLabel2.setMinimumSize(new Dimension(130, 130));
        this.jLabel2.setPreferredSize(new Dimension(130, 130));
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setContentType(bundle.getString("BricUI.jTextPane1.contentType"));
        this.jTextPane1.setMinimumSize(new Dimension(6, 128));
        this.jTextPane1.setPreferredSize(new Dimension(6, 128));
        this.jScrollPane2.setViewportView(this.jTextPane1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 207, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 142, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE))));
        this.jList1.setCursor(new Cursor(12));
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BricUI.this.jList1MouseClicked(evt);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BricUI.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap()).addComponent(this.jScrollPane1, -1, 354, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 366, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -2, 24, -2).addComponent(this.jButton1, -2, 24, -2).addComponent(this.jButton3, -2, 24, -2)).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(2, 2, 2)));
        this.jSplitPane1.setLeftComponent(this.jPanel8);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, -2, 731, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.importImages();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            this.removeImages();
        }
        catch (Exception e) {
            this.jLabel2.setIcon(this.DEFAULT_ICON);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            this.clearAll();
        }
        catch (Exception e) {
            this.jLabel2.setIcon(this.DEFAULT_ICON);
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.preferencesFrame.setVisible(true);
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.setAlwaysOnTop(this.jToggleButton1.isSelected());
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        ++this.previewState;
        switch (this.previewState) {
            case 0: {
                this.jLabel2.setVisible(true);
                this.jPanel2.setVisible(true);
                break;
            }
            case 1: {
                this.jLabel2.setVisible(false);
                break;
            }
            case 2: {
                this.jLabel2.setVisible(false);
                this.jPanel2.setVisible(false);
                break;
            }
            case 3: {
                this.previewState = 0;
            }
            default: {
                this.jLabel2.setVisible(true);
                this.jPanel2.setVisible(true);
            }
        }
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        if (!this.model.isEmpty()) {
            this.startProcess(false);
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        try {
            ImportedImage importedImage = (ImportedImage)this.model.get(this.jList1.getSelectedIndex());
            this.generateThumbnailMetadataOnDemand(importedImage);
            this.jLabel2.setIcon(importedImage.getThumbnailImageIcon());
            this.previewInfo(importedImage.getPath(), importedImage.getDimensions(), importedImage.getSize());
        }
        catch (Exception e) {
            this.jLabel2.setIcon(this.DEFAULT_ICON);
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValue() != null) {
            this.startProcess(true);
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            try {
                if (this.model.isEmpty()) {
                    return;
                }
                ImportedImage image = (ImportedImage)this.model.get(this.jList1.getSelectedIndex());
                Desktop.getDesktop().open(new File(image.getPath()));
            }
            catch (IOException ex) {
                Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.saveSettings();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.loadSettings();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.aboutFrame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BricUI bricUI = new BricUI();
                Utils.centerWindow(bricUI);
                bricUI.setVisible(true);
            }
        });
    }

    public static synchronized void duplicatePane(String file) {
        if (duplicateAction == 4 || duplicateAction == 1 || duplicateAction == 3) {
            Object selection;
            Object[] selectionValues = new Object[]{"Replace all", "Replace", "Skip all", "Skip"};
            String initialSelection = selectionValues[0].toString();
            while ((selection = JOptionPane.showInputDialog(null, String.format("This image\n%s\nhas already been added", file), "Warning Duplicate Input", 3, null, selectionValues, initialSelection)) == null) {
            }
            int answer = 0;
            int i = 0;
            for (Object value : selectionValues) {
                if (selection == value.toString()) {
                    answer = i;
                }
                ++i;
            }
            switch (answer) {
                case 0: {
                    duplicateAction = 0;
                    break;
                }
                case 1: {
                    duplicateAction = 1;
                    break;
                }
                case 2: {
                    duplicateAction = 2;
                    break;
                }
                case 3: {
                    duplicateAction = 3;
                    break;
                }
                default: {
                    duplicateAction = 4;
                }
            }
        }
    }

    private void removeImages() {
        ArrayList<Integer> toBeDeleted = new ArrayList<Integer>();
        for (int number : this.jList1.getSelectedIndices()) {
            toBeDeleted.add(number);
        }
        Collections.reverse(toBeDeleted);
        Iterator i$ = toBeDeleted.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            BricUI.removeFromHash(((ImportedImage)this.model.get(value)).getPath());
            this.model.remove(value);
        }
        this.jTextPane1.setText("");
        this.updateItemsLabel();
    }

    private void updateItemsLabel() {
        this.jLabel1.setText("Items: " + this.model.getSize());
        if (this.model.getSize() == 0) {
            duplicateAction = 4;
        }
    }

    private void clearAll() {
        this.model.clear();
        this.imagesList.clear();
        BricUI.clearHash();
        System.gc();
        this.jTextPane1.setText("");
        this.updateItemsLabel();
    }

    private void previewInfo(String listSelected, String dimensions, long filesize) {
        String text = "<html><body>";
        text = text + "<b>Name:</b><br />";
        text = text + listSelected.substring(listSelected.lastIndexOf(Utils.FS) + 1, listSelected.length()) + "<br /><br />";
        text = text + "<b>Dimensions: </b><br />" + dimensions + "<br />";
        if (filesize != 0L) {
            text = text + "<br /><b>Filesize: </b><br />" + filesize / 1024L + "KB<br />";
        }
        text = text + "</body></html>";
        this.jTextPane1.setText(text);
        this.jTextPane1.setCaretPosition(0);
    }

    public void importImages() {
        this.imagesList = this.readImages();
        if (this.imagesList == Collections.EMPTY_LIST) {
            return;
        }
        Thread a = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressBarFrame importer = new ProgressBarFrame();
                importer.setImagesCount(BricUI.this.imagesList.size());
                importer.setVisible(true);
                int processors = Utils.prefs.getInt("importNumThreads", 0) == 0 ? Runtime.getRuntime().availableProcessors() : Utils.prefs.getInt("importNumThreads", 1);
                int step = (int)Math.ceil((double)BricUI.this.imagesList.size() / (double)processors);
                for (int j = 0; j < BricUI.this.imagesList.size(); j += step) {
                    BricUI.this.importImageThread(importer, j, step);
                }
            }
        });
        a.start();
    }

    private void importImageThread(final ProgressBarFrame importer, final int from, final int step) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = from; i < from + step; ++i) {
                    if (!importer.isVisible()) {
                        return;
                    }
                    if (i >= BricUI.this.imagesList.size()) break;
                    if (hash.contains(BricUI.this.imagesList.get(i))) {
                        BricUI.duplicatePane(BricUI.this.imagesList.get(i));
                    }
                    if (duplicateAction == 1 || duplicateAction == 0 || !hash.contains(BricUI.this.imagesList.get(i))) {
                        ImportedImage im = new ImportedImage(BricUI.this.imagesList.get(i));
                        if (!im.isCorrupted()) {
                            BricUI.this.addToModel(im);
                            importer.updateValue(true);
                        } else {
                            importer.updateValue(false);
                        }
                    } else {
                        importer.updateValue(true);
                    }
                    importer.showProgress(BricUI.this.imagesList.get(i));
                }
            }
        }).start();
    }

    public static void removeFromHash(String path) {
        hash.remove(path);
    }

    public static void clearHash() {
        hash.clear();
    }

    public synchronized void addToModel(final ImportedImage im) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (hash.contains(im.getPath())) {
                    BricUI.this.model.removeElement(im);
                } else {
                    hash.add(im.getPath());
                }
                BricUI.this.model.addElement(im);
                BricUI.this.updateItemsLabel();
            }
        });
    }

    public List<String> readImages() {
        ArrayList<String> imagePaths = new ArrayList<String>();
        JFileChooser chooser = new JFileChooser(lastOpenedDirectory);
        Utils.setFileChooserProperties(chooser);
        if (chooser.showOpenDialog(null) != 0) {
            return Collections.EMPTY_LIST;
        }
        lastOpenedDirectory = chooser.getSelectedFile().getParent();
        for (File path : chooser.getSelectedFiles()) {
            if (path.isDirectory()) {
                ArrayList<String> directoryChildren = new ArrayList<String>();
                this.scanDirectory(path, directoryChildren);
                imagePaths.addAll(directoryChildren);
                continue;
            }
            imagePaths.add(path.getPath());
        }
        return imagePaths;
    }

    private void generateThumbnailMetadataOnDemand(ImportedImage importedImage) {
        boolean thumbnail = Utils.prefs.getBoolean("thumbnail", true) && Utils.prefs.getInt("thumbWay", 0) == 1 && importedImage.getThumbnailImageIcon() == null;
        boolean metadata = Utils.prefs.getBoolean("metadata", true) && Utils.prefs.getInt("metaWay", 0) == 1 && importedImage.getDimensions().equals("unknown");
        Utils.setMetadataThumbnail(importedImage, metadata, thumbnail);
    }

    private void scanDirectory(File file, ArrayList<String> list) {
        File[] children = file.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isFile() && child.getName().contains(".")) {
                String extension = child.toString().substring(child.toString().lastIndexOf(46) + 1);
                for (String ext : Utils.supportedInputExtensions) {
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    list.add(child.getPath());
                }
                continue;
            }
            if (!child.isDirectory()) continue;
            this.scanDirectory(child, list);
        }
    }

    public void startProcess(final boolean preview) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ImageProcessHandler mainProcess;
                if (!preview) {
                    mainProcess = new ImageProcessHandler(BricUI.this.model);
                } else {
                    ImportedImage importedImage = (ImportedImage)BricUI.this.model.get(BricUI.this.jList1.getSelectedIndex());
                    mainProcess = new ImageProcessHandler(importedImage);
                }
                OutputParameters outputParameters = null;
                ResizeParameters resizeParameters = null;
                RotateParameters rotateParameters = null;
                WatermarkParameters watermarkParameters = null;
                for (int i = 0; i < BricUI.this.jTabbedPane1.getComponentCount(); ++i) {
                    ImageEditParameters imageEditParameters = ((ImageEditTab)((Object)BricUI.this.jTabbedPane1.getComponentAt(i))).getImageEditParameters();
                    if (imageEditParameters instanceof OutputParameters) {
                        outputParameters = (OutputParameters)imageEditParameters;
                        continue;
                    }
                    if (imageEditParameters instanceof ResizeParameters) {
                        resizeParameters = (ResizeParameters)imageEditParameters;
                        continue;
                    }
                    if (imageEditParameters instanceof RotateParameters) {
                        rotateParameters = (RotateParameters)imageEditParameters;
                        continue;
                    }
                    if (!(imageEditParameters instanceof WatermarkParameters)) continue;
                    watermarkParameters = (WatermarkParameters)imageEditParameters;
                }
                mainProcess.setResizeParameters(resizeParameters);
                mainProcess.setRotateParameters(rotateParameters);
                mainProcess.setWatermarkParameters(watermarkParameters);
                mainProcess.setOutputParameters(outputParameters);
                mainProcess.start();
            }
        }).start();
    }

    private void initializeProperties() {
        this.propertiesChooser = new JFileChooser();
        this.propertiesChooser.setFileSelectionMode(0);
        this.propertiesChooser.setFileFilter(new FileNameExtensionFilter("properties file(*.properties)", "PROPERTIES"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        FileOutputStream out = null;
        try {
            this.propertiesChooser.setDialogTitle("Save properties");
            if (this.propertiesChooser.showSaveDialog(null) != 0) {
                return;
            }
            String file = this.propertiesChooser.getSelectedFile().getPath();
            if (!file.matches(".+\\.properties")) {
                file = this.propertiesChooser.getSelectedFile().getPath() + ".properties";
            }
            out = new FileOutputStream(new File(file));
            OutputJPanel outputJPanel = (OutputJPanel)this.jTabbedPane1.getComponentAt(0);
            this.properties.setProperty("fileTypeCombo", Integer.toString(outputJPanel.getFileTypeComboIndex()));
            this.properties.setProperty("outputPathText", outputJPanel.getOutputPathText());
            this.properties.setProperty("qualityValue", Integer.toString(outputJPanel.getQualitySliderValue()));
            this.properties.setProperty("startIndexValue", Integer.toString(outputJPanel.getStartIndexSpinnerValue()));
            ResizeJPanel resizeJPanel = (ResizeJPanel)this.jTabbedPane1.getComponentAt(1);
            this.properties.setProperty("resizeAntialising", resizeJPanel.getAntialisingCheckBox() ? "1" : "0");
            this.properties.setProperty("resizeAspect", resizeJPanel.getAspectCheckBox() ? "1" : "0");
            this.properties.setProperty("resizeHeight", resizeJPanel.getHeightSpinner());
            this.properties.setProperty("resizeOrientation", resizeJPanel.getOrientationCheckBox() ? "1" : "0");
            this.properties.setProperty("resizeRendering", Integer.toString(resizeJPanel.getRenderingComboBox()));
            this.properties.setProperty("resizeEnable", resizeJPanel.getResizeEnableCheckBox() ? "1" : "0");
            this.properties.setProperty("resizeFilter", Integer.toString(resizeJPanel.getResizeFilterComboBox()));
            this.properties.setProperty("resizeSharpen", Integer.toString(resizeJPanel.getSharpenComboBox()));
            this.properties.setProperty("resizeUnits", Integer.toString(resizeJPanel.getUnitCombo()));
            this.properties.setProperty("resizeWidth", resizeJPanel.getWidthSpinner());
            RotateJPanel rotateJPanel = (RotateJPanel)this.jTabbedPane1.getComponentAt(2);
            this.properties.setProperty("rotateEnable", rotateJPanel.getRotateEnableCheckBox() ? "1" : "0");
            this.properties.setProperty("rotateAction", Integer.toString(rotateJPanel.getActionsComboBox()));
            this.properties.setProperty("rotateAngle", rotateJPanel.getAngleSlider());
            this.properties.setProperty("rotateCustom", rotateJPanel.getCustomRadioButton() ? "1" : "0");
            this.properties.setProperty("rotateDifferentValue", rotateJPanel.getDifferentValueCheckBox() ? "1" : "0");
            this.properties.setProperty("rotateMinLimit", rotateJPanel.getFromSpinner());
            this.properties.setProperty("rotateLimit", rotateJPanel.getLimitCheckBox() ? "1" : "0");
            this.properties.setProperty("rotatePredifiend", rotateJPanel.getPredefinedRadioButton() ? "1" : "0");
            this.properties.setProperty("rotateRandom", rotateJPanel.getRandomCheckBox() ? "1" : "0");
            this.properties.setProperty("rotateMaxLimit", rotateJPanel.getToSpinner());
            WatermarkJPanel watermarkJPanel = (WatermarkJPanel)this.jTabbedPane1.getComponentAt(3);
            this.properties.setProperty("watermarkColoumns", watermarkJPanel.getColoumnsSpinner());
            this.properties.setProperty("watermarkText", watermarkJPanel.getEditorTextPane());
            this.properties.setProperty("watermarkMode", Integer.toString(watermarkJPanel.getModeComboBox()));
            this.properties.setProperty("watermarkOpacity", watermarkJPanel.getOpacitySlider());
            this.properties.setProperty("watermarkPattern", Integer.toString(watermarkJPanel.getPatternComboBox()));
            this.properties.setProperty("watermarkRows", watermarkJPanel.getRowsSlidder());
            this.properties.setProperty("watermarkEnable", watermarkJPanel.getWatermarkEnableCheckBox() ? "1" : "0");
            this.properties.setProperty("watermarkImage", watermarkJPanel.getWatermarkImageText());
            this.properties.store(out, "");
        }
        catch (IOException ex) {
            Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        FileInputStream fileInput = null;
        try {
            this.propertiesChooser.setDialogTitle("Load properties");
            if (this.propertiesChooser.showOpenDialog(null) != 0) {
                return;
            }
            File file = this.propertiesChooser.getSelectedFile();
            fileInput = new FileInputStream(file);
            this.properties.load(fileInput);
            OutputJPanel outputJPanel = (OutputJPanel)this.jTabbedPane1.getComponentAt(0);
            outputJPanel.setFileTypeComboIndex(this.properties.getProperty("fileTypeCombo"));
            outputJPanel.setOutputPathText(this.properties.getProperty("outputPathText"));
            outputJPanel.setQualitySliderValue(this.properties.getProperty("qualityValue"));
            outputJPanel.setStartIndexSpinnerValue(Integer.parseInt(this.properties.getProperty("startIndexValue")));
            ResizeJPanel resizeJPanel = (ResizeJPanel)this.jTabbedPane1.getComponentAt(1);
            resizeJPanel.setAntialisingCheckBox(this.properties.getProperty("resizeAntialising").equals("1"));
            resizeJPanel.setAspectCheckBox(this.properties.getProperty("resizeAspect").equals("1"));
            resizeJPanel.setHeightSpinner(this.properties.getProperty("resizeHeight"));
            resizeJPanel.setOrientationCheckBox(this.properties.getProperty("resizeOrientation").equals("1"));
            resizeJPanel.setRenderingComboBox(Integer.parseInt(this.properties.getProperty("resizeRendering")));
            resizeJPanel.setResizeEnableCheckBox(this.properties.getProperty("resizeEnable").equals("1"));
            resizeJPanel.setResizeFilterComboBox(Integer.parseInt(this.properties.getProperty("resizeFilter")));
            resizeJPanel.setSharpenComboBox(Integer.parseInt(this.properties.getProperty("resizeSharpen")));
            resizeJPanel.setUnitCombo(Integer.parseInt(this.properties.getProperty("resizeUnits")));
            resizeJPanel.setWidthSpinner(Integer.parseInt(this.properties.getProperty("resizeWidth")));
            RotateJPanel rotateJPanel = (RotateJPanel)this.jTabbedPane1.getComponentAt(2);
            rotateJPanel.setRotateEnableCheckBox(this.properties.getProperty("rotateEnable").equals("1"));
            rotateJPanel.setActionsComboBox(Integer.parseInt(this.properties.getProperty("rotateAction")));
            rotateJPanel.setAngleSlider(Integer.parseInt(this.properties.getProperty("rotateAngle")));
            rotateJPanel.setCustomRadioButton(this.properties.getProperty("rotateCustom").equals("1"));
            rotateJPanel.setDifferentValueCheckBox(this.properties.getProperty("rotateDifferentValue").equals("1"));
            rotateJPanel.setFromSpinner(Integer.parseInt(this.properties.getProperty("rotateMinLimit")));
            rotateJPanel.setLimitCheckBox(this.properties.getProperty("rotateLimit").equals("1"));
            rotateJPanel.setPredefinedRadioButton(this.properties.getProperty("rotatePredifiend").equals("1"));
            rotateJPanel.setRandomCheckBox(this.properties.getProperty("rotateRandom").equals("1"));
            rotateJPanel.setToSpinner(Integer.parseInt(this.properties.getProperty("rotateMaxLimit")));
            WatermarkJPanel watermarkJPanel = (WatermarkJPanel)this.jTabbedPane1.getComponentAt(3);
            watermarkJPanel.setColoumnsSpinner(Integer.parseInt(this.properties.getProperty("watermarkColoumns")));
            watermarkJPanel.setEditorTextPane(this.properties.getProperty("watermarkText"));
            watermarkJPanel.setModeComboBox(Integer.parseInt(this.properties.getProperty("watermarkMode")));
            watermarkJPanel.setOpacitySlider(Integer.parseInt(this.properties.getProperty("watermarkOpacity")));
            watermarkJPanel.setPatternComboBox(Integer.parseInt(this.properties.getProperty("watermarkPattern")));
            watermarkJPanel.setRowsSlider(Integer.parseInt(this.properties.getProperty("watermarkRows")));
            watermarkJPanel.setWatermarkEnableCheckBox(this.properties.getProperty("watermarkEnable").equals("1"));
            watermarkJPanel.setWatermarkImageText(this.properties.getProperty("watermarkImage"));
        }
        catch (IOException ex) {
            Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fileInput != null) {
                    fileInput.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BricUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

