/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bric.gui.BricUI;
import org.bric.gui.tabs.ImageEditTab;
import org.bric.imageEditParameters.OutputParameters;
import org.bric.utils.Utils;

public class OutputJPanel
extends JPanel
implements ImageEditTab {
    private JComboBox fileTypeCombo;
    private JButton jButton4;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane3;
    private JSpinner jSpinner2;
    private JSpinner jSpinner3;
    private JTextPane jTextPane2;
    private JTextField outputPathText;
    private JSlider qualitySlider;
    private JSpinner startIndexSpinner;

    public OutputJPanel() {
        this.initComponents();
        SpinnerNumberModel numbering = new SpinnerNumberModel((Number)1, null, null, (Number)1);
        this.startIndexSpinner.setModel(numbering);
        SpinnerNumberModel horizontal = new SpinnerNumberModel(300, 10, 1000, 1);
        SpinnerNumberModel vertical = new SpinnerNumberModel(300, 10, 1000, 1);
        this.jSpinner2.setModel(horizontal);
        this.jSpinner3.setModel(vertical);
        this.jLabel6.setVisible(false);
        this.jLabel7.setVisible(false);
        this.jLabel8.setVisible(false);
        this.jSpinner2.setVisible(false);
        this.jSpinner3.setVisible(false);
    }

    private void initComponents() {
        this.outputPathText = new JTextField();
        this.jButton4 = new JButton();
        this.jLabel3 = new JLabel();
        this.fileTypeCombo = new JComboBox();
        this.jLabel4 = new JLabel();
        this.startIndexSpinner = new JSpinner();
        this.jLabel5 = new JLabel();
        this.qualitySlider = new JSlider();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane2 = new JTextPane();
        this.jLabel6 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jSpinner3 = new JSpinner();
        this.outputPathText.setText(System.getProperty("user.home"));
        ResourceBundle bundle = ResourceBundle.getBundle("lang/gui/tabs/Bundle");
        this.jButton4.setText(bundle.getString("OutputJPanel.jButton4.text"));
        this.jButton4.setToolTipText(bundle.getString("OutputJPanel.jButton4.toolTipText"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputJPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jLabel3.setText(bundle.getString("OutputJPanel.jLabel3.text"));
        this.fileTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"SAME AS FIRST", "JPG", "JPEG", "PNG", "GIF", "BMP", "TIF", "TIFF", "PGM", "PBM", "PNM", "PPM", "PDF"}));
        this.fileTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OutputJPanel.this.fileTypeComboItemStateChanged(evt);
            }
        });
        this.jLabel4.setText(bundle.getString("OutputJPanel.jLabel4.text"));
        this.jLabel5.setText(bundle.getString("OutputJPanel.jLabel5.text"));
        this.qualitySlider.setMajorTickSpacing(10);
        this.qualitySlider.setMinorTickSpacing(5);
        this.qualitySlider.setPaintLabels(true);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setValue(100);
        this.qualitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OutputJPanel.this.qualitySliderStateChanged(evt);
            }
        });
        this.jTextPane2.setContentType("text/html");
        this.jTextPane2.setEditable(false);
        ResourceBundle bundle1 = ResourceBundle.getBundle("lang/gui/Bundle");
        this.jTextPane2.setText(bundle1.getString("OutputJPanel.jTextPane2.text"));
        this.jScrollPane3.setViewportView(this.jTextPane2);
        this.jLabel6.setText(bundle.getString("OutputJPanel.jLabel6.text"));
        this.jLabel7.setText(bundle.getString("OutputJPanel.jLabel7.text"));
        this.jLabel8.setText(bundle.getString("OutputJPanel.jLabel8.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.outputPathText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 34, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 191, Short.MAX_VALUE).addComponent(this.fileTypeCombo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.startIndexSpinner, -2, 83, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.qualitySlider, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 366, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner2, -2, 83, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel8).addGap(18, 18, 18).addComponent(this.jSpinner3, -2, 83, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputPathText, -2, -1, -2).addComponent(this.jButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fileTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.startIndexSpinner, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner2, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner3, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.qualitySlider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jScrollPane3, -2, -1, -2)));
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(BricUI.lastOpenedDirectory);
        Utils.setFileChooserProperties(chooser);
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        this.outputPathText.setText(chooser.getSelectedFile().getPath() + Utils.FS);
        BricUI.lastOpenedDirectory = chooser.getSelectedFile().getPath();
    }

    private void fileTypeComboItemStateChanged(ItemEvent evt) {
        boolean qualityEnable = this.fileTypeCombo.getSelectedIndex() <= 2;
        this.jLabel5.setEnabled(qualityEnable);
        this.qualitySlider.setEnabled(qualityEnable);
        this.jLabel6.setEnabled(qualityEnable);
        this.jLabel7.setEnabled(qualityEnable);
        this.jLabel8.setEnabled(qualityEnable);
        this.jSpinner2.setEnabled(qualityEnable);
        this.jSpinner3.setEnabled(qualityEnable);
    }

    private void qualitySliderStateChanged(ChangeEvent evt) {
        this.jLabel5.setText(String.format("Quality: %s%%", this.qualitySlider.getValue()));
    }

    public int getFileTypeComboIndex() {
        return this.fileTypeCombo.getSelectedIndex();
    }

    public void setFileTypeComboIndex(String index) {
        this.fileTypeCombo.setSelectedIndex(Integer.parseInt(index));
    }

    public String getOutputPathText() {
        return this.outputPathText.getText();
    }

    public void setOutputPathText(String outputPathText) {
        this.outputPathText.setText(outputPathText);
    }

    public int getQualitySliderValue() {
        return this.qualitySlider.getValue();
    }

    public void setQualitySliderValue(String value) {
        this.qualitySlider.setValue(Integer.parseInt(value));
    }

    public int getStartIndexSpinnerValue() {
        return Integer.parseInt(this.startIndexSpinner.getValue().toString());
    }

    public void setStartIndexSpinnerValue(int startIndex) {
        this.startIndexSpinner.getModel().setValue(startIndex);
    }

    @Override
    public OutputParameters getImageEditParameters() {
        OutputParameters outputParameters = new OutputParameters();
        outputParameters.setOutputPath(this.outputPathText.getText());
        outputParameters.setQuality((float)this.qualitySlider.getValue() / 100.0f);
        outputParameters.setOutputFormat(this.fileTypeCombo.getSelectedItem().toString());
        outputParameters.setNumberingStartIndex((Integer)this.startIndexSpinner.getValue());
        return outputParameters;
    }
}

