/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.tabs;

import com.jhlabs.image.RotateFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bric.gui.BricUI;
import org.bric.gui.tabs.ImageEditTab;
import org.bric.gui.watermark.JPlacer;
import org.bric.imageEditParameters.WatermarkParameters;
import org.bric.utils.Utils;
import say.swing.JFontChooser;

public class WatermarkJPanel
extends JPanel
implements ImageEditTab {
    private Color color;
    private String plainText;
    private Font defaultFont;
    private Font currentFont;
    private JSpinner coloumnsSpinner;
    private JLabel editorJLabel;
    private JTextPane editorTextPane;
    private JButton jButton10;
    private JButton jButton2;
    private JButton jButton9;
    private JFontChooser jFontChooser1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPlacer jPlacer1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JComboBox modeComboBox;
    private JSlider opacitySlider;
    private JComboBox patternComboBox;
    private JSlider rotateSlider;
    private JSpinner rowsSlidder;
    private JCheckBox watermarkEnableCheckBox;
    private JTextField watermarkImageText;

    public WatermarkJPanel() {
        this.initComponents();
        this.watermarkImageText.setVisible(false);
        this.jButton2.setVisible(false);
        this.currentFont = this.defaultFont = this.editorTextPane.getFont();
    }

    private void initComponents() {
        this.jFontChooser1 = new JFontChooser();
        this.watermarkEnableCheckBox = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPlacer1 = new JPlacer();
        this.rotateSlider = new JSlider();
        this.opacitySlider = new JSlider();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.modeComboBox = new JComboBox();
        this.editorJLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.editorTextPane = new JTextPane();
        this.jButton2 = new JButton();
        this.watermarkImageText = new JTextField();
        this.jPanel3 = new JPanel();
        this.rowsSlidder = new JSpinner();
        this.patternComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.coloumnsSpinner = new JSpinner();
        this.jLabel8 = new JLabel();
        ResourceBundle bundle = ResourceBundle.getBundle("lang/gui/tabs/Bundle");
        this.watermarkEnableCheckBox.setText(bundle.getString("WatermarkJPanel.jCheckBox3.text"));
        this.watermarkEnableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WatermarkJPanel.this.watermarkEnableCheckBoxItemStateChanged(evt);
            }
        });
        this.jLabel10.setText(bundle.getString("WatermarkJPanel.jLabel10.text"));
        this.jLabel10.setEnabled(false);
        this.jLabel1.setText(bundle.getString("WatermarkJPanel.jLabel1.text"));
        this.jLabel1.setEnabled(false);
        this.jSplitPane1.setOrientation(0);
        this.jPlacer1.setEnabled(false);
        this.rotateSlider.setMaximum(360);
        this.rotateSlider.setToolTipText(bundle.getString("WatermarkJPanel.jSlider1.toolTipText"));
        this.rotateSlider.setValue(0);
        this.rotateSlider.setEnabled(false);
        this.rotateSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WatermarkJPanel.this.rotateSliderMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WatermarkJPanel.this.rotateSliderMouseExited(evt);
            }
        });
        this.rotateSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WatermarkJPanel.this.rotateSliderStateChanged(evt);
            }
        });
        this.opacitySlider.setMajorTickSpacing(10);
        this.opacitySlider.setMinorTickSpacing(5);
        this.opacitySlider.setToolTipText(bundle.getString("WatermarkJPanel.jSlider2.toolTipText"));
        this.opacitySlider.setValue(0);
        this.opacitySlider.setEnabled(false);
        this.opacitySlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                WatermarkJPanel.this.opacitySliderMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WatermarkJPanel.this.opacitySliderMouseEntered(evt);
            }
        });
        this.opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WatermarkJPanel.this.opacitySliderStateChanged(evt);
            }
        });
        GroupLayout jPlacer1Layout = new GroupLayout(this.jPlacer1);
        this.jPlacer1.setLayout(jPlacer1Layout);
        jPlacer1Layout.setHorizontalGroup(jPlacer1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opacitySlider, -1, 363, Short.MAX_VALUE).addComponent(this.rotateSlider, -1, -1, Short.MAX_VALUE));
        jPlacer1Layout.setVerticalGroup(jPlacer1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPlacer1Layout.createSequentialGroup().addComponent(this.opacitySlider, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 176, Short.MAX_VALUE).addComponent(this.rotateSlider, -2, 21, -2)));
        this.jSplitPane1.setLeftComponent(this.jPlacer1);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButton9.setText(bundle.getString("WatermarkJPanel.jButton9.text"));
        this.jButton9.setEnabled(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkJPanel.this.jButton9ActionPerformed(evt);
            }
        });
        this.jButton10.setText(bundle.getString("WatermarkJPanel.jButton10.text"));
        this.jButton10.setEnabled(false);
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkJPanel.this.jButton10ActionPerformed(evt);
            }
        });
        this.modeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Text Mode", "HTML Mode", "Image Mode"}));
        this.modeComboBox.setEnabled(false);
        this.modeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkJPanel.this.modeComboBoxActionPerformed(evt);
            }
        });
        this.editorJLabel.setText("Text Editor");
        this.editorJLabel.setEnabled(false);
        this.editorTextPane.setContentType("text/html");
        this.editorTextPane.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n    <p style=\"margin-top: 0\">\r\n      \rwatermark\n    </p>\r\n  </body>\r\n</html>\r\n");
        this.editorTextPane.setToolTipText("");
        this.editorTextPane.setEnabled(false);
        this.editorTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                WatermarkJPanel.this.editorTextPaneKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                WatermarkJPanel.this.editorTextPaneKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.editorTextPane);
        this.jButton2.setText("...");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.watermarkImageText.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.watermarkImageText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 37, -2)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.editorJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton10, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.modeComboBox, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButton10, this.jButton9);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton10).addComponent(this.modeComboBox, -2, -1, -2).addComponent(this.jButton9).addComponent(this.editorJLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 121, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.watermarkImageText, -2, -1, -2)).addContainerGap()));
        this.rowsSlidder.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.rowsSlidder.setEnabled(false);
        this.patternComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Single", "Tiled"}));
        this.patternComboBox.setEnabled(false);
        this.patternComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WatermarkJPanel.this.patternComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel3.setText(bundle.getString("WatermarkJPanel.jLabel3.text"));
        this.jLabel3.setEnabled(false);
        this.jLabel2.setText(bundle.getString("WatermarkJPanel.jLabel2.text"));
        this.jLabel2.setEnabled(false);
        this.coloumnsSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.coloumnsSpinner.setEnabled(false);
        this.jLabel8.setText(bundle.getString("WatermarkJPanel.jLabel8.text"));
        this.jLabel8.setEnabled(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patternComboBox, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsSlidder, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coloumnsSpinner, -2, 56, -2).addContainerGap()));
        jPanel3Layout.linkSize(0, this.jLabel2, this.jLabel3);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternComboBox, -2, -1, -2).addComponent(this.rowsSlidder, -2, -1, -2).addComponent(this.coloumnsSpinner, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel2).addComponent(this.jLabel3)).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(14, 14, 14).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.watermarkEnableCheckBox, -2, 74, -2).addGap(77, 77, 77).addComponent(this.jLabel10, -2, 81, -2).addGap(18, 18, 18).addComponent(this.jLabel1, -2, 90, -2).addContainerGap()).addComponent(this.jSplitPane1, -2, 0, Short.MAX_VALUE));
        layout.linkSize(0, this.jLabel1, this.jLabel10);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.watermarkEnableCheckBox).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel1)))).addGap(6, 6, 6).addComponent(this.jSplitPane1, -2, -1, Short.MAX_VALUE)));
    }

    private void watermarkEnableCheckBoxItemStateChanged(ItemEvent evt) {
        this.watermarkTabEnable();
    }

    private void rotateSliderMouseExited(MouseEvent evt) {
        this.jLabel1.setForeground(Color.BLACK);
    }

    private void rotateSliderMouseEntered(MouseEvent evt) {
        this.jLabel1.setForeground(Color.RED);
    }

    private void rotateSliderStateChanged(ChangeEvent evt) {
        this.jPlacer1.setAngle(this.rotateSlider.getValue());
        this.jLabel1.setText("Rotate: " + this.rotateSlider.getValue() + "\u00b0");
    }

    private void opacitySliderMouseExited(MouseEvent evt) {
        this.jLabel10.setForeground(Color.BLACK);
    }

    private void opacitySliderMouseEntered(MouseEvent evt) {
        this.jLabel10.setForeground(Color.RED);
    }

    private void opacitySliderStateChanged(ChangeEvent evt) {
        this.jLabel10.setText(String.format("Opacity: %s%%", this.opacitySlider.getValue()));
        this.jPlacer1.setAlpha(this.opacitySlider.getValue());
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.color = JColorChooser.showDialog(null, "Choose Color", Color.BLACK);
        this.editorTextPane.setForeground(this.color);
        this.jPlacer1.setColor(this.color);
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        if (this.jFontChooser1.showDialog(this) != 0) {
            return;
        }
        this.editorTextPane.setFont(this.jFontChooser1.getSelectedFont());
        this.currentFont = this.jFontChooser1.getSelectedFont();
    }

    private void patternComboBoxItemStateChanged(ItemEvent evt) {
        this.watermarkTabEnable();
    }

    private void editorTextPaneKeyPressed(KeyEvent evt) {
    }

    private void modeComboBoxActionPerformed(ActionEvent evt) {
        this.setEditorMode();
        this.editorTextPane.setText(this.plainText);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(BricUI.lastOpenedDirectory);
        Utils.setFileChooserProperties(chooser);
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        this.watermarkImageText.setText(chooser.getSelectedFile().getPath());
        BricUI.lastOpenedDirectory = chooser.getSelectedFile().getPath();
    }

    private void editorTextPaneKeyTyped(KeyEvent evt) {
    }

    private void setEditorMode() {
        this.plainText = this.editorTextPane.getText();
        if (this.modeComboBox.getSelectedIndex() == 0) {
            this.jScrollPane2.setVisible(true);
            this.watermarkImageText.setVisible(false);
            this.jButton2.setVisible(false);
            this.jButton10.setVisible(true);
            this.jButton9.setVisible(true);
            this.editorJLabel.setText("Text Editor");
            this.editorTextPane.setContentType("text/html");
            this.editorTextPane.setFont(this.currentFont);
            this.editorTextPane.setForeground(this.color);
        } else if (this.modeComboBox.getSelectedIndex() == 1) {
            this.jButton10.setVisible(false);
            this.jButton9.setVisible(false);
            this.jScrollPane2.setVisible(true);
            this.watermarkImageText.setVisible(false);
            this.jButton2.setVisible(false);
            this.editorJLabel.setText("HTML Editor");
            this.editorTextPane.setContentType("text/plain");
            this.editorTextPane.setFont(this.defaultFont);
            this.editorTextPane.setForeground(Color.BLACK);
        } else {
            this.jButton10.setVisible(false);
            this.jButton9.setVisible(false);
            this.jScrollPane2.setVisible(false);
            this.watermarkImageText.setVisible(true);
            this.jButton2.setVisible(true);
            this.editorJLabel.setText("Image Mode");
        }
    }

    @Override
    public WatermarkParameters getImageEditParameters() {
        WatermarkParameters watermarkParameters = new WatermarkParameters();
        watermarkParameters.setEnabled(this.watermarkEnableCheckBox.isSelected());
        watermarkParameters.setWatermarkText(this.editorTextPane.getText());
        watermarkParameters.setPattern(this.patternComboBox.getSelectedIndex());
        watermarkParameters.setTiledRows((Integer)this.rowsSlidder.getValue());
        watermarkParameters.setTiledColumns((Integer)this.coloumnsSpinner.getValue());
        watermarkParameters.setFont(this.jFontChooser1.getSelectedFont());
        watermarkParameters.setColor(this.jPlacer1.getColor());
        watermarkParameters.setComponentWidth(this.jPlacer1.getWidth());
        watermarkParameters.setComponentHeight(this.jPlacer1.getHeight());
        watermarkParameters.setCenterX(this.jPlacer1.getLabelCenterX());
        watermarkParameters.setCenterY(this.jPlacer1.getLabelCenterY());
        BufferedImage watermarkImage = this.computeWatermarkBufferedImage();
        watermarkParameters.setWatermarkImage(watermarkImage);
        watermarkParameters.setWatermarkWidth(watermarkImage.getWidth());
        watermarkParameters.setWatermarkHeight(watermarkImage.getHeight());
        return watermarkParameters;
    }

    private BufferedImage computeWatermarkBufferedImage() {
        BufferedImage watermark;
        CellRendererPane crp = new CellRendererPane();
        if (this.modeComboBox.getSelectedIndex() != 2) {
            JTextPane pane = new JTextPane();
            pane.setContentType("text/html");
            pane.setText(this.editorTextPane.getText());
            if (this.modeComboBox.getSelectedIndex() == 0) {
                pane.setForeground(this.editorTextPane.getForeground());
                pane.setFont(this.editorTextPane.getFont());
            }
            pane.setBackground(new Color(255, 255, 255, 0));
            Dimension dim = pane.getPreferredSize();
            watermark = new BufferedImage(dim.width, dim.height, 2);
            Graphics2D g = watermark.createGraphics();
            crp.paintComponent(g, pane, null, 0, 0, dim.width, dim.height);
            g.setComposite(this.makeComposite(this.jPlacer1.getAlpha()));
            g.dispose();
        } else {
            watermark = Utils.loadImage(this.watermarkImageText.getText());
        }
        float angle = (float)((double)(360 - this.rotateSlider.getValue()) * Math.PI / 180.0);
        RotateFilter rotateFilter = new RotateFilter(angle);
        return rotateFilter.filter(watermark, null);
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    private void watermarkTabEnable() {
        boolean enable = this.watermarkEnableCheckBox.isSelected();
        boolean tiled = this.patternComboBox.getSelectedIndex() == 1;
        this.jPlacer1.setEnabled(enable);
        this.jLabel8.setEnabled(enable);
        this.patternComboBox.setEnabled(enable);
        this.jLabel10.setEnabled(enable);
        this.opacitySlider.setEnabled(enable);
        this.jLabel2.setEnabled(enable & tiled);
        this.rowsSlidder.setEnabled(enable & tiled);
        this.jLabel3.setEnabled(enable & tiled);
        this.coloumnsSpinner.setEnabled(enable & tiled);
        this.jLabel1.setEnabled(enable);
        this.rotateSlider.setEnabled(enable);
        for (Component comp : this.jPanel1.getComponents()) {
            comp.setEnabled(enable);
        }
        this.editorTextPane.setEnabled(enable);
    }

    public String getColoumnsSpinner() {
        return this.coloumnsSpinner.getValue().toString();
    }

    public void setColoumnsSpinner(int coloumnsSpinner) {
        this.coloumnsSpinner.getModel().setValue(coloumnsSpinner);
    }

    public String getEditorTextPane() {
        return this.editorTextPane.getText();
    }

    public void setEditorTextPane(String editorTextPane) {
        this.editorTextPane.setText(editorTextPane);
    }

    public int getModeComboBox() {
        return this.modeComboBox.getSelectedIndex();
    }

    public void setModeComboBox(int modeComboBox) {
        this.modeComboBox.setSelectedIndex(modeComboBox);
    }

    public String getOpacitySlider() {
        return String.valueOf(this.opacitySlider.getValue());
    }

    public void setOpacitySlider(int opacitySlider) {
        this.opacitySlider.getModel().setValue(opacitySlider);
    }

    public int getPatternComboBox() {
        return this.patternComboBox.getSelectedIndex();
    }

    public void setPatternComboBox(int patternComboBox) {
        this.patternComboBox.setSelectedIndex(patternComboBox);
    }

    public String getRowsSlidder() {
        return String.valueOf(this.rowsSlidder.getValue());
    }

    public void setRowsSlider(int rowsSlidder) {
        this.rowsSlidder.getModel().setValue(rowsSlidder);
    }

    public boolean getWatermarkEnableCheckBox() {
        return this.watermarkEnableCheckBox.isSelected();
    }

    public void setWatermarkEnableCheckBox(boolean watermarkEnableCheckBox) {
        this.watermarkEnableCheckBox.setSelected(watermarkEnableCheckBox);
    }

    public String getWatermarkImageText() {
        return this.watermarkImageText.getText();
    }

    public void setWatermarkImageText(String watermarkImageText) {
        this.watermarkImageText.setText(watermarkImageText);
    }
}

