/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.watermark;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JPlacer
extends JComponent
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private Image doubleBufferedImage;
    private Graphics dbg;
    private Rectangle windowBounds;
    private Image background;
    private static final Color DEFAULT_COLOR = Color.RED;
    private Color fontColor = DEFAULT_COLOR;
    private double radAngle = 0.0;
    private double angle = 0.0;
    private float alpha = 1.0f;
    private int width;
    private int height;
    private static final String STANDARD_TEXT = "<html><body>watermark</body></html>";
    private String previewText = "<html><body>watermark</body></html>";
    private Rectangle rect;
    private int preX;
    private int preY;
    private boolean mouseReleased = false;
    private JLabel renderer = new JLabel("<html><body>watermark</body></html>");
    private CellRendererPane crp = new CellRendererPane();
    private Dimension dim;
    private int rotationCenterX;
    private int rotationCenterY;
    private Rectangle[] positions = new Rectangle[9];
    private int startX;
    private int startY;
    private int oldWidth;
    private int oldHeight;
    private int newWidth = 360;
    private int newHeight = 215;
    private int oldX;
    private int oldY;
    private boolean enabled;

    public JPlacer() {
        this.initialize();
    }

    private void initialize() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
        try {
            this.background = ImageIO.read(this.getClass().getResource("/resource/watermark/background.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(JPlacer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setSize(this.background.getWidth(this), this.background.getHeight(this));
        this.setMinimumSize(new Dimension(this.background.getWidth(this), this.background.getHeight(this)));
        this.dim = this.renderer.getPreferredSize();
        this.width = this.dim.width;
        this.height = this.dim.height;
        this.startX = this.getWidth() / 2 - this.width / 2;
        this.startY = this.getHeight() / 2 - this.height / 2;
        this.rect = new Rectangle(this.startX, this.startY, this.width, this.height);
        this.windowBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.renderer.setForeground(this.fontColor);
        this.rotationCenterX = this.rect.x + this.dim.width / 2;
        this.rotationCenterY = this.rect.y + this.dim.height / 2;
        this.renderer.setVerticalTextPosition(1);
        this.renderer.setHorizontalTextPosition(2);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.rotationCenterX = this.rect.x + this.dim.width / 2;
        this.rotationCenterY = this.rect.y + this.dim.height / 2;
        this.doubleBufferedImage = this.createImage(this.getSize().width, this.getSize().height);
        this.dbg = this.doubleBufferedImage.getGraphics();
        this.width = this.dim.width;
        this.height = this.dim.height;
        Graphics2D g2 = (Graphics2D)this.dbg;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.windowBounds.setSize(this.getWidth(), this.getHeight());
        g2.fill(this.windowBounds);
        g2.drawImage(this.background, this.getWidth() / 2 - this.background.getWidth(this) / 2, this.getHeight() / 2 - this.background.getHeight(this) / 2, this);
        g2.setColor(Color.WHITE);
        int k = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.positions[k] = new Rectangle(this.getWidth() / 3 * x, this.getHeight() / 3 * y, this.getWidth() / 3, this.getHeight() / 3);
                g2.draw(this.positions[k]);
                ++k;
            }
        }
        g2.setColor(this.fontColor);
        g2.rotate(this.radAngle, this.rotationCenterX, this.rotationCenterY);
        g2.setComposite(this.makeComposite(this.alpha));
        this.crp.paintComponent(g2, this.renderer, this, this.rect.x, this.rect.y, this.dim.width, this.dim.height);
        this.width = this.dim.width;
        this.height = this.dim.height;
        this.rect.setSize(this.width, this.height);
        g2.rotate(-this.radAngle, this.rotationCenterX, this.rotationCenterY);
        g2.dispose();
        g.drawImage(this.doubleBufferedImage, 0, 0, this);
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    private void checkRectangleCollision() {
        if (this.windowBounds.contains(this.rect)) {
            return;
        }
        if ((double)(this.rect.x + this.rect.width / 2) >= this.windowBounds.getWidth() + this.windowBounds.getX()) {
            this.setLimitLocations((int)(this.windowBounds.getWidth() - (double)(this.rect.width / 2) + this.windowBounds.getX()), this.rect.y);
        }
        if ((double)this.rect.x < this.windowBounds.getX() - (double)(this.rect.width / 2)) {
            this.setLimitLocations((int)this.windowBounds.getX() - this.rect.width / 2, this.rect.y);
        }
        if ((double)(this.rect.y + this.rect.height / 2) > this.windowBounds.getHeight() + this.windowBounds.getY()) {
            this.setLimitLocations(this.rect.x, (int)(this.windowBounds.getHeight() - (double)(this.rect.height / 2) + this.windowBounds.getY()));
        }
        if ((double)this.rect.y < this.windowBounds.getY() - (double)(this.rect.height / 2)) {
            this.setLimitLocations(this.rect.x, (int)this.windowBounds.getY() - this.rect.height / 2);
        }
    }

    private void setLimitLocations(int newX, int newY) {
        int centerX = this.rect.width / 2 - this.rect.width / 2;
        int centerY = this.rect.height / 2 - this.rect.height / 2;
        this.rect.setLocation(newX, newY);
        this.rect.setLocation(newX - centerX, newY - centerY);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.enabled) {
            return;
        }
        for (int i = 0; i < this.positions.length; ++i) {
            if (!this.positions[i].contains(me.getPoint())) continue;
            this.rect.setLocation(this.positions[i].width / 2 + this.positions[i].x - this.rect.width / 2, this.positions[i].height / 2 + this.positions[i].y - this.rect.height / 2);
            this.checkRectangleCollision();
            this.repaint();
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.preX = this.rect.x - me.getX();
        this.preY = this.rect.y - me.getY();
        if (this.rect.contains(me.getX(), me.getY())) {
            this.updateLocation(me);
        } else {
            this.mouseReleased = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.rect.contains(me.getX(), me.getY())) {
            this.updateLocation(me);
        } else {
            this.mouseReleased = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (!this.enabled) {
            return;
        }
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (!this.enabled) {
            return;
        }
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.mouseReleased) {
            this.updateLocation(me);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (!this.enabled) {
            return;
        }
        if (this.rect.contains(me.getPoint())) {
            this.setCursor(new Cursor(13));
        } else {
            this.setCursor(new Cursor(12));
        }
    }

    public void updateLocation(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        this.rect.setLocation(this.preX + e.getX(), this.preY + e.getY());
        this.checkRectangleCollision();
        this.repaint();
    }

    public double getTextX() {
        return this.rect.getX();
    }

    public double getTextY() {
        return this.rect.getY();
    }

    public void setText(String text) {
        this.previewText = text;
        this.renderer.setText(this.previewText);
        this.updateLimits();
    }

    public void setAlpha(int value) {
        this.alpha = (float)((double)(100 - value) * Math.pow(10.0, -2.0));
        this.repaint();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setFonts(Font font) {
        this.renderer.setFont(font);
        this.updateLimits();
    }

    public void setColor(Color color) {
        this.fontColor = color;
        this.renderer.setForeground(color);
        this.repaint();
    }

    public Color getColor() {
        return this.renderer.getForeground();
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.radAngle = (double)angle * Math.PI / 180.0;
        this.updateLimits();
    }

    public double getAngle() {
        return this.angle;
    }

    private void updateLimits() {
        this.dim = this.renderer.getPreferredSize();
        this.checkRectangleCollision();
        this.repaint();
    }

    public void setImage(ImageIcon image) {
        this.renderer.setIcon(image);
        this.updateLimits();
    }

    public void setImageAlign(int value) {
        switch (value) {
            case 0: {
                this.renderer.setVerticalTextPosition(1);
                this.renderer.setHorizontalTextPosition(2);
                break;
            }
            case 1: {
                this.renderer.setVerticalTextPosition(1);
                this.renderer.setHorizontalTextPosition(4);
                break;
            }
            case 2: {
                this.renderer.setVerticalTextPosition(0);
                this.renderer.setHorizontalTextPosition(2);
                break;
            }
            case 3: {
                this.renderer.setVerticalTextPosition(0);
                this.renderer.setHorizontalTextPosition(4);
                break;
            }
            case 4: {
                this.renderer.setVerticalTextPosition(1);
                this.renderer.setHorizontalTextPosition(0);
                break;
            }
            case 5: {
                this.renderer.setVerticalTextPosition(3);
                this.renderer.setHorizontalTextPosition(0);
                break;
            }
            case 6: {
                this.renderer.setVerticalTextPosition(3);
                this.renderer.setHorizontalTextPosition(2);
                break;
            }
            case 7: {
                this.renderer.setVerticalTextPosition(3);
                this.renderer.setHorizontalTextPosition(4);
            }
        }
        this.updateLimits();
    }

    public int getLabelCenterX() {
        return this.rect.x + this.rect.width / 2;
    }

    public int getLabelCenterY() {
        return this.rect.y + this.rect.height / 2;
    }

    public int getLabelWidth() {
        return this.dim.width;
    }

    public int getLabelHeight() {
        return this.dim.height;
    }

    public String getText() {
        return this.renderer.getText();
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        this.oldWidth = this.newWidth;
        this.oldHeight = this.newHeight;
        this.newWidth = this.getWidth();
        this.newHeight = this.getHeight();
        this.oldX = this.rect.x + this.rect.width / 2;
        this.oldY = this.rect.y + this.rect.height / 2;
        this.rect.setLocation((int)((double)this.newWidth / (double)this.oldWidth * (double)this.oldX - (double)(this.rect.width / 2)), (int)((double)this.newHeight / (double)this.oldHeight * (double)this.oldY - (double)(this.rect.height / 2)));
        this.dim = this.renderer.getPreferredSize();
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        super.setEnabled(value);
    }
}

