/*
 * Decompiled with CFR 0.152.
 */
package org.bric.input;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.bric.utils.PDFToImage;
import org.bric.utils.Utils;

public class GenerateThumbnail {
    public static BufferedImage generate(String filename, int thumbWidth, int thumbHeight) {
        if (filename == null) {
            return null;
        }
        Image image = filename.substring(filename.lastIndexOf(".") + 1).equalsIgnoreCase("pdf") ? (Image)PDFToImage.getBImagesFromPDF(filename, 1, 1).get(0) : Utils.loadImage(filename);
        return GenerateThumbnail.generate(image, thumbWidth, thumbHeight);
    }

    public static BufferedImage generate(Image image, int thumbWidth, int thumbHeight) {
        if (image.getWidth(null) >= image.getHeight(null)) {
            thumbHeight = thumbWidth * image.getHeight(null) / image.getWidth(null);
        } else {
            thumbWidth = thumbHeight * image.getWidth(null) / image.getHeight(null);
        }
        BufferedImage resizedImage = new BufferedImage(thumbWidth, thumbHeight, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        g.dispose();
        return resizedImage;
    }
}

