/*
 * Decompiled with CFR 0.152.
 */
package org.bric.processor;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.MultiStepRescaleOp;
import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.ResampleOp;
import com.mortennobel.imagescaling.ThumpnailRescaleOp;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.bric.imageEditParameters.ResizeParameters;
import org.bric.processor.ImageProcessor;

public class ResizeProcessor
implements ImageProcessor {
    private int width;
    private int height;
    ResizeParameters resizeParameters;

    public ResizeProcessor(ResizeParameters resizeParameters) {
        this.resizeParameters = resizeParameters;
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        BufferedImage resizedImage;
        this.computeWidthHeight(image);
        ResampleOp resampleOp = new ResampleOp(this.width, this.height);
        resampleOp.setUnsharpenMask(this.getSharpen(this.resizeParameters));
        if (this.resizeParameters.getFilter().equalsIgnoreCase("auto")) {
            resizedImage = image.getWidth() < this.width || image.getHeight() < this.height ? this.graphicsFilters(image, "bicubic", this.width, this.height) : this.graphicsFilters(image, "bilenear", this.width, this.height);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("bicubic")) {
            resampleOp.setFilter(ResampleFilters.getBiCubicFilter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("bicubichighfreqresponse")) {
            resampleOp.setFilter(ResampleFilters.getBiCubicHighFreqResponse());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("lanczos3")) {
            resampleOp.setFilter(ResampleFilters.getLanczos3Filter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("multistep")) {
            MultiStepRescaleOp multiStepRescaleOp = new MultiStepRescaleOp(this.width, this.height);
            multiStepRescaleOp.setUnsharpenMask(this.getSharpen(this.resizeParameters));
            resizedImage = multiStepRescaleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("bell")) {
            resampleOp.setFilter(ResampleFilters.getBellFilter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("box")) {
            resampleOp.setFilter(ResampleFilters.getBoxFilter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("hermite")) {
            resampleOp.setFilter(ResampleFilters.getHermiteFilter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("mitchell")) {
            resampleOp.setFilter(ResampleFilters.getMitchellFilter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("triangle")) {
            resampleOp.setFilter(ResampleFilters.getTriangleFilter());
            resizedImage = resampleOp.filter(image, null);
        } else if (this.resizeParameters.getFilter().equalsIgnoreCase("thumpnail")) {
            ThumpnailRescaleOp thumpnailRescaleOp = new ThumpnailRescaleOp(this.width, this.height);
            thumpnailRescaleOp.setUnsharpenMask(this.getSharpen(this.resizeParameters));
            resizedImage = thumpnailRescaleOp.filter(image, null);
        } else {
            resizedImage = this.resizeParameters.getFilter().equalsIgnoreCase("nearest_neighbor") ? this.graphicsFilters(image, "nearest_neighbor", this.width, this.height) : (this.resizeParameters.getFilter().equalsIgnoreCase("bilinear") ? this.graphicsFilters(image, "bilinear", this.width, this.height) : this.graphicsFilters(image, "bicubic", this.width, this.height));
        }
        return resizedImage;
    }

    public AdvancedResizeOp.UnsharpenMask getSharpen(ResizeParameters resizeParameters) {
        if (resizeParameters.getSharpen().equals("none")) {
            return AdvancedResizeOp.UnsharpenMask.None;
        }
        if (resizeParameters.getSharpen().equals("normal")) {
            return AdvancedResizeOp.UnsharpenMask.Normal;
        }
        if (resizeParameters.getSharpen().equals("oversharpened")) {
            return AdvancedResizeOp.UnsharpenMask.Oversharpened;
        }
        if (resizeParameters.getSharpen().equals("soft")) {
            return AdvancedResizeOp.UnsharpenMask.Soft;
        }
        return AdvancedResizeOp.UnsharpenMask.VerySharp;
    }

    public BufferedImage graphicsFilters(BufferedImage srcImage, String filter, int width, int height) {
        int type = srcImage.getType() == 0 ? 2 : srcImage.getType();
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        if (this.resizeParameters.getRendering() == 0) {
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        if (this.resizeParameters.isAntialising()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (filter.equalsIgnoreCase("nearest_neighbor")) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (filter.equalsIgnoreCase("bilinear")) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private void computeWidthHeight(BufferedImage image) {
        this.width = this.resizeParameters.getWidth();
        this.height = this.resizeParameters.getHeight();
        boolean maintain = this.resizeParameters.isMaintainAspectRatio();
        boolean consider = this.resizeParameters.isConsiderOrientation();
        if (this.resizeParameters.getUnits() == 0) {
            if (maintain && !consider) {
                if (this.height == 0) {
                    this.height = this.width * image.getHeight() / image.getWidth();
                } else {
                    this.width = this.height * image.getWidth() / image.getHeight();
                }
            } else if (!maintain && consider) {
                if (image.getWidth() < image.getHeight()) {
                    this.width = this.resizeParameters.getHeight();
                    this.height = this.resizeParameters.getWidth();
                }
            } else if (maintain && consider) {
                if (image.getWidth() >= image.getHeight()) {
                    this.height = this.width * image.getHeight() / image.getWidth();
                } else {
                    this.width = this.height * image.getWidth() / image.getHeight();
                }
            }
        } else if (this.resizeParameters.getUnits() == 1) {
            this.width = image.getWidth() * this.width / 100;
            this.height = image.getHeight() * this.height / 100;
        }
    }
}

