/*
 * Decompiled with CFR 0.152.
 */
package cloudberry.watermark;

import cloudberry.fonts.CFontChooser;
import cloudberry.watermark.ImageViewer;
import cloudberry.watermark.Mode;
import cloudberry.watermark.Position;
import cloudberry.watermark.WaterMarkerGUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GUIEvents
implements ActionListener {
    WaterMarkerGUI gui;

    public GUIEvents(WaterMarkerGUI g) {
        this.gui = g;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.gui.browseImagesBTN) {
            this.browseImages();
        } else if (arg0.getSource() == this.gui.browseWaterMarkBTN) {
            this.browseForWatermark();
        } else if (arg0.getSource() == this.gui.browseOutputBTN) {
            this.chooseDirectory();
        } else if (arg0.getSource() == this.gui.previewBTN) {
            if (this.gui.fileList.getSelectedValue() == null) {
                JOptionPane.showMessageDialog(null, "You need to choose a file in the list above!", "No Image Selected", 1, null);
                return;
            }
            this.showPreview();
        } else if (arg0.getSource() == this.gui.startBTN) {
            this.start();
        } else if (arg0.getSource() == this.gui.positionOptions) {
            this.updateCustomView();
        } else if (arg0.getSource() == this.gui.textStyleBTN) {
            this.customizeFont();
        }
    }

    public void browseImages() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "gif", "png", "jpeg", "bmp");
        fc.setFileFilter(filter);
        fc.setPreferredSize(new Dimension(600, 480));
        fc.showOpenDialog(null);
        File[] files = fc.getSelectedFiles();
        this.gui.watermarker.setFiles(files);
        this.gui.model.removeAllElements();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.gui.model.addElement(f);
            ++n2;
        }
    }

    public void browseForWatermark() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "gif", "png", "jpeg", "bmp");
        fc.setFileFilter(filter);
        fc.setPreferredSize(new Dimension(600, 480));
        fc.showOpenDialog(null);
        File file = fc.getSelectedFile();
        this.gui.watermarker.setWatermark(file);
        this.gui.watermarkField.setText(file.getAbsolutePath());
    }

    public void chooseDirectory() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setPreferredSize(new Dimension(600, 480));
        fc.showOpenDialog(null);
        File file = fc.getSelectedFile();
        this.gui.watermarker.setOutputDirectory(file);
        this.gui.outputField.setText(file.getAbsolutePath());
    }

    public void showPreview() {
        try {
            BufferedImage img;
            int x = this.gui.xField.getText().length() == 0 ? 0 : Integer.parseInt(this.gui.xField.getText());
            int y = this.gui.yField.getText().length() == 0 ? 0 : Integer.parseInt(this.gui.yField.getText());
            this.gui.watermarker.setCustomData(x, y);
            this.gui.watermarker.setPosition(this.getSelectedPosition());
            this.gui.watermarker.setOpacity(this.gui.alphaSlider.getValue());
            this.gui.watermarker.setText(this.gui.textField.getText());
            if (this.gui.watermarkRadio.isSelected()) {
                this.gui.watermarker.setMode(Mode.IMAGE);
                this.gui.watermarker.calculatePosition((File)this.gui.fileList.getSelectedValue(), this.gui.watermarker.watermark);
                img = this.gui.watermarker.watermarkImage((File)this.gui.fileList.getSelectedValue());
            } else {
                this.gui.watermarker.setMode(Mode.TEXT);
                this.gui.watermarker.calculateTextPosition((File)this.gui.fileList.getSelectedValue(), this.gui.watermarker.text);
                img = this.gui.watermarker.addTextToImage((File)this.gui.fileList.getSelectedValue());
            }
            ImageViewer exw = new ImageViewer();
            exw.showImage(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        int x = this.gui.xField.getText().length() == 0 ? 0 : Integer.parseInt(this.gui.xField.getText());
        int y = this.gui.yField.getText().length() == 0 ? 0 : Integer.parseInt(this.gui.yField.getText());
        if (this.gui.watermarkRadio.isSelected()) {
            this.gui.watermarker.setMode(Mode.IMAGE);
        } else {
            this.gui.watermarker.setMode(Mode.TEXT);
        }
        this.gui.watermarker.setCustomData(x, y);
        this.gui.watermarker.setPosition(this.getSelectedPosition());
        this.gui.watermarker.setOpacity(this.gui.alphaSlider.getValue());
        this.gui.watermarker.setText(this.gui.textField.getText());
        this.gui.watermarker.startWatermarking();
    }

    public Position getSelectedPosition() {
        int option = this.gui.positionOptions.getSelectedIndex();
        if (option == 0) {
            return Position.UPPER_RIGHT;
        }
        if (option == 1) {
            return Position.LOWER_RIGHT;
        }
        if (option == 2) {
            return Position.UPPER_LEFT;
        }
        if (option == 3) {
            return Position.LOWER_LEFT;
        }
        if (option == 4) {
            return Position.CENTER;
        }
        return Position.CUSTOM;
    }

    public void updateCustomView() {
        int option = this.gui.positionOptions.getSelectedIndex();
        if (option == 0 || option == 1 || option == 2 || option == 3) {
            this.gui.customLabel.setText("Padding:");
            this.gui.xField.setEnabled(true);
            this.gui.yField.setEnabled(true);
        } else if (option == 4) {
            this.gui.xField.setEnabled(false);
            this.gui.yField.setEnabled(false);
        } else if (option == 5) {
            this.gui.customLabel.setText("Position:");
            this.gui.xField.setEnabled(true);
            this.gui.yField.setEnabled(true);
        }
    }

    public void customizeFont() {
        CFontChooser fontChooser = new CFontChooser();
        this.gui.watermarker.setFont(fontChooser.showDialog(this.gui.watermarker.textFont));
        this.gui.watermarker.setColor(fontChooser.getSelectedColor());
    }
}

