/*
 * Decompiled with CFR 0.152.
 */
package cloudberry.watermark;

import cloudberry.watermark.Mode;
import cloudberry.watermark.Position;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Watermarker {
    File[] files;
    File watermark;
    String text;
    File outputDirectory;
    float opacity = 1.0f;
    int actualX = 10;
    int actualY = 100;
    int customX;
    int customY;
    Position position = Position.UPPER_RIGHT;
    Font textFont = new Font("Arial", 0, 72);
    Color textColor = Color.RED;
    Mode mode = Mode.IMAGE;

    public void setFiles(File[] fs) {
        this.files = fs;
    }

    public void setWatermark(File f) {
        this.watermark = f;
    }

    public void setOutputDirectory(File f) {
        this.outputDirectory = f;
    }

    public void setCustomData(int x, int y) {
        this.customX = x;
        this.customY = y;
    }

    public void setPosition(Position p) {
        this.position = p;
    }

    public void setOpacity(int n) {
        float f = n;
        this.opacity = f / 100.0f;
    }

    public void setFont(Font f) {
        this.textFont = f;
    }

    public void setColor(Color c) {
        this.textColor = c;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    public void startWatermarking() {
        if (this.files == null) {
            JOptionPane.showMessageDialog(null, "Error: No image file selected!", "Error", 0, null);
            return;
        }
        if (this.watermark == null && this.mode == Mode.IMAGE) {
            JOptionPane.showMessageDialog(null, "Error: No watermark file selected!", "Error", 0, null);
            return;
        }
        if (this.text == null && this.mode == Mode.TEXT && this.outputDirectory == null) {
            JOptionPane.showMessageDialog(null, "Error: No output directory selected!", "Error", 0, null);
            return;
        }
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File imgFile = fileArray[n2];
            try {
                if (this.mode == Mode.IMAGE) {
                    this.calculatePosition(imgFile, this.watermark);
                    this.saveImage(imgFile, this.watermarkImage(imgFile));
                } else {
                    this.calculateTextPosition(imgFile, this.text);
                    this.saveImage(imgFile, this.addTextToImage(imgFile));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public BufferedImage watermarkImage(File imageFile) throws Exception {
        if (this.watermark == null) {
            JOptionPane.showMessageDialog(null, "Error: No watermark selected!", "Error", 0, null);
        }
        if (imageFile == null) {
            JOptionPane.showMessageDialog(null, "Error: No image file selected!", "Error", 0, null);
        }
        BufferedImage image = ImageIO.read(imageFile);
        BufferedImage wm = ImageIO.read(this.watermark);
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 7);
        BufferedImage newWatermark = new BufferedImage(wm.getWidth(), wm.getHeight(), 7);
        float[] scales = new float[]{1.0f, 1.0f, 1.0f, this.opacity};
        float[] offsets = new float[4];
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        Graphics2D wmG2 = newWatermark.createGraphics();
        wmG2.drawImage(wm, null, 0, 0);
        wmG2.dispose();
        newWatermark = rop.filter(newWatermark, null);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawImage(image, null, 0, 0);
        g2.drawImage((Image)newWatermark, this.actualX, this.actualY, null);
        g2.dispose();
        if (imageFile.getName().toLowerCase().endsWith("jpg") || imageFile.getName().toLowerCase().endsWith("jpeg")) {
            return this.convertToJPG(newImage);
        }
        return newImage;
    }

    public BufferedImage addTextToImage(File imageFile) throws Exception {
        if (this.text == null) {
            JOptionPane.showMessageDialog(null, "Error: No text selected!", "Error", 0, null);
        }
        if (imageFile == null) {
            JOptionPane.showMessageDialog(null, "Error: No image file selected!", "Error", 0, null);
        }
        BufferedImage image = ImageIO.read(imageFile);
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 7);
        BufferedImage textLayer = new BufferedImage(image.getWidth(), image.getHeight(), 7);
        float[] scales = new float[]{1.0f, 1.0f, 1.0f, this.opacity};
        float[] offsets = new float[4];
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        Graphics2D txG2 = textLayer.createGraphics();
        txG2.setFont(this.textFont);
        txG2.setColor(this.textColor);
        txG2.drawString(this.text, this.actualX, this.actualY);
        txG2.dispose();
        textLayer = rop.filter(textLayer, null);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawImage(image, null, 0, 0);
        g2.drawImage((Image)textLayer, 0, 0, null);
        g2.dispose();
        if (imageFile.getName().toLowerCase().endsWith("jpg") || imageFile.getName().toLowerCase().endsWith("jpeg")) {
            return this.convertToJPG(newImage);
        }
        return newImage;
    }

    public void saveImage(File originalFile, BufferedImage bi) throws Exception {
        String path = String.valueOf(this.outputDirectory.getAbsolutePath()) + "/";
        path = path.concat(originalFile.getName().substring(0, originalFile.getName().lastIndexOf(".")));
        path = path.concat("_WM");
        File newFile = new File(path = path.concat(originalFile.getName().substring(originalFile.getName().lastIndexOf("."), originalFile.getName().length())));
        if (newFile.getName().toLowerCase().endsWith(".jpeg") || newFile.getName().toLowerCase().endsWith("jpg")) {
            ImageIO.write((RenderedImage)bi, "jpg", newFile);
        } else if (newFile.getName().toLowerCase().endsWith("bmp")) {
            ImageIO.write((RenderedImage)bi, "bmp", newFile);
        } else if (newFile.getName().toLowerCase().endsWith("png")) {
            ImageIO.write((RenderedImage)bi, "png", newFile);
        } else {
            JOptionPane.showMessageDialog(null, "Error: Unsupported format!", "Error", 0, null);
            System.err.println(newFile.getName());
        }
    }

    public void calculatePosition(File image, File watermark) throws IOException {
        BufferedImage bi = ImageIO.read(image);
        BufferedImage wm = ImageIO.read(watermark);
        int width = bi.getWidth();
        int height = bi.getHeight();
        int wmWidth = wm.getWidth();
        int wmHeight = wm.getHeight();
        switch (this.position) {
            case UPPER_LEFT: {
                this.actualX = this.customX;
                this.actualY = this.customY;
                break;
            }
            case UPPER_RIGHT: {
                this.actualX = width - this.customX - wmWidth;
                this.actualY = 0 + this.customY;
                break;
            }
            case LOWER_LEFT: {
                this.actualX = this.customX;
                this.actualY = height - this.customY - wmHeight;
                break;
            }
            case LOWER_RIGHT: {
                this.actualX = width - this.customX - wmWidth;
                this.actualY = height - this.customY - wmHeight;
                break;
            }
            case CENTER: {
                this.actualX = (int)(0.5 * (double)width - 0.5 * (double)wmWidth);
                this.actualY = (int)(0.5 * (double)height - 0.5 * (double)wmHeight);
                break;
            }
            case CUSTOM: {
                this.actualX = this.customX;
                this.actualY = this.customY;
                break;
            }
        }
    }

    public void calculateTextPosition(File image, String text) throws IOException {
        BufferedImage bi = ImageIO.read(image);
        int width = bi.getWidth();
        int height = bi.getHeight();
        FontMetrics fm = bi.getGraphics().getFontMetrics(this.textFont);
        int textHeight = fm.getHeight();
        int textWidth = fm.stringWidth(text);
        switch (this.position) {
            case UPPER_LEFT: {
                this.actualX = this.customX;
                this.actualY = this.customY + textHeight;
                break;
            }
            case UPPER_RIGHT: {
                this.actualX = width - this.customX - textWidth;
                this.actualY = this.customY + textHeight;
                break;
            }
            case LOWER_LEFT: {
                this.actualX = this.customX;
                this.actualY = height - this.customY;
                break;
            }
            case LOWER_RIGHT: {
                this.actualX = width - this.customX - textWidth;
                this.actualY = height - this.customY;
                break;
            }
            case CENTER: {
                this.actualX = (int)(0.5 * (double)width - 0.5 * (double)textWidth);
                this.actualY = (int)(0.5 * (double)height - 0.5 * (double)textHeight);
                break;
            }
            case CUSTOM: {
                this.actualX = this.customX;
                this.actualY = this.customY;
                break;
            }
        }
    }

    public BufferedImage convertToJPG(BufferedImage bi) {
        BufferedImage newImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
        newImage.createGraphics().drawImage(bi, 0, 0, Color.WHITE, null);
        return newImage;
    }
}

