#!/bin/bash

if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root" 1>&2
   zenity --error --text "You must run this script as root!"
   exit 1
fi
if zenity --question --text "This script will copy application data to /usr/share/BatchWatermarker, and add a menu entry (.desktop file) to /usr/share/applications. You will then be able to start Batch Watermarker through the application menu (or dash on unity).\nDo you want to proceed?"; then
  mkdir /usr/share/BatchWatermarker/
  cp  $PWD/Data/batchwatermarker.desktop /usr/share/applications/
  cp  $PWD/Data/batchwatermarker.png /usr/share/BatchWatermarker/
  cp  $PWD/Data/Watermarker.jar /usr/share/BatchWatermarker/
  zenity --info --text "Installation complete, you can now delete this folder!"
fi
