/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import net.dieslunae.jgraphite.ctrl.JGraphiteController;

public class FullScreenPreview
extends JFrame
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 8066045739195846950L;
    Image image;

    public FullScreenPreview(JGraphiteController ctrl) {
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
        if (System.getProperty("os.name").contains("OS/2")) {
            this.setUndecorated(true);
            this.setSize(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width, GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height);
        }
        this.setVisible(true);
        if (!System.getProperty("os.name").contains("OS/2")) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this);
        }
        this.image = ctrl.getScaledConvertedImage(this.getWidth(), this.getHeight());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispose();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth(this) / 2, this.getHeight() / 2 - this.image.getHeight(this) / 2, this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

