/*
 * Decompiled with CFR 0.152.
 */
package imager;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public abstract class Draggable
implements Serializable {
    Rectangle m_OrigBounds;
    volatile Rectangle m_CurrBounds;
    Rectangle m_OuterBounds;
    int m_nRelativeX;
    int m_nRelativeY;
    boolean m_bDragged = false;
    boolean m_bHorizDragAllowed = true;
    boolean m_bVertDragAllowed = true;
    boolean m_bMoveable = true;
    boolean m_bUpdateAnchor = true;
    public static BasicStroke DASH_STROKE = new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    Color m_XorColor = Color.red;
    boolean m_bNotYetDragged = true;

    public Rectangle getOrigBounds() {
        return this.m_OrigBounds;
    }

    public void setOuterBounds(int n, int n2, int n3, int n4) {
        if (this.m_OuterBounds == null) {
            this.setOuterBounds(new Rectangle(n, n2, n3, n4));
        } else {
            this.m_OuterBounds.x = n;
            this.m_OuterBounds.y = n2;
            this.m_OuterBounds.width = n3;
            this.m_OuterBounds.height = n4;
        }
    }

    public void setOuterBounds(Rectangle rectangle) {
        if (this.m_OuterBounds == null) {
            this.m_OuterBounds = rectangle;
        } else {
            this.m_OuterBounds.x = rectangle.x;
            this.m_OuterBounds.y = rectangle.y;
            this.m_OuterBounds.width = rectangle.width;
            this.m_OuterBounds.height = rectangle.height;
        }
    }

    public void setOrigBounds(Rectangle rectangle) {
        if (this.m_OrigBounds == null) {
            this.m_OrigBounds = rectangle;
        } else {
            this.m_OrigBounds.x = rectangle.x;
            this.m_OrigBounds.y = rectangle.y;
            this.m_OrigBounds.width = rectangle.width;
            this.m_OrigBounds.height = rectangle.height;
        }
        this.m_CurrBounds = this.m_OrigBounds;
    }

    public void setOrigLocation(Point point) {
        this.m_OrigBounds.setLocation(point);
    }

    public void mouseDragged(int n, int n2, Graphics graphics) {
        this.mouseDragged(n, n2, graphics, graphics);
    }

    public void mouseDragged(int n, int n2, Graphics graphics, Graphics graphics2) {
        if (!this.m_bMoveable) {
            return;
        }
        if (this.m_bNotYetDragged) {
            this.m_bNotYetDragged = false;
        }
        this.drawDraggedRegion((Graphics2D)graphics, (Graphics2D)graphics2);
        if (this.m_bHorizDragAllowed) {
            this.m_CurrBounds.x = n - this.m_nRelativeX;
        }
        if (this.m_bVertDragAllowed) {
            this.m_CurrBounds.y = n2 - this.m_nRelativeY;
        }
        this.drawDraggedRegion((Graphics2D)graphics, (Graphics2D)graphics2);
    }

    public void mousePressed(int n, int n2) {
        if (!this.m_bMoveable) {
            return;
        }
        this.m_CurrBounds.x = this.m_OrigBounds.x;
        this.m_CurrBounds.y = this.m_OrigBounds.y;
        this.m_CurrBounds.width = this.m_OrigBounds.width;
        this.m_CurrBounds.height = this.m_OrigBounds.height;
        this.m_nRelativeX = Math.abs(n - this.m_OrigBounds.x);
        this.m_nRelativeY = Math.abs(n2 - this.m_OrigBounds.y);
        this.m_bDragged = true;
        this.m_bNotYetDragged = true;
    }

    public void mouseReleased(int n, int n2) {
        if (!this.m_bMoveable) {
            return;
        }
        this.m_OrigBounds = new Rectangle(this.m_CurrBounds);
        this.m_bDragged = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean isDragged() {
        return this.m_bDragged;
    }

    public boolean isMoveable() {
        return this.m_bMoveable;
    }

    public void setMoveable(boolean bl) {
        this.m_bMoveable = bl;
    }

    public boolean contains(Point point) {
        if (this.m_OrigBounds != null) {
            return this.m_OrigBounds.contains(point);
        }
        return false;
    }

    public void doUpdateAnchor(boolean bl) {
        this.m_bUpdateAnchor = bl;
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    public boolean isNotYetDragged() {
        return this.m_bNotYetDragged;
    }

    public abstract void draw(Graphics var1);

    public abstract void drawDraggedRegion(Graphics2D var1, Graphics2D var2);
}

