/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.FormattedTextField;
import imager.Text;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OutlineText
extends Text {
    private int U_m_nOutlineWidth = 0;
    private Color V_m_OutlineColor;
    transient BasicStroke stroke;

    public OutlineText(String string, int n, int n2, Font font, Color color, TexturePaint texturePaint, Color color2, int n3) {
        super(string, n, n2, font, color, texturePaint);
        this.U_m_nOutlineWidth = n3;
        this.V_m_OutlineColor = color2;
        if (this.V_m_OutlineColor != null) {
            this.stroke = new BasicStroke(this.U_m_nOutlineWidth);
        }
        this.setUIPanel(new OutlineTextPanel());
    }

    void render(Graphics2D graphics2D, int n, int n2) {
        this.drawOutlinedText(graphics2D, n, n2);
        super.render(graphics2D, n, n2);
    }

    protected void drawOutlinedText(Graphics2D graphics2D, int n, int n2) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.m_Font;
        String string = this.m_Text;
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, string.length());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(n, n2));
        graphics2D.setColor(this.V_m_OutlineColor);
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.U_m_nOutlineWidth);
        }
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(shape);
        if (this.m_Tp == null) {
            graphics2D.setColor(this.m_Color);
        } else {
            graphics2D.setPaint(this.m_Tp);
        }
        graphics2D.fill(shape);
    }

    public void setOutlineWidth(int n) {
        this.U_m_nOutlineWidth = n;
        this.stroke = new BasicStroke(n);
    }

    public int getOutlineWidth() {
        return this.U_m_nOutlineWidth;
    }

    public Color getOutlineColor() {
        return this.V_m_OutlineColor;
    }

    public void setOutlineColor(Color color) {
        this.V_m_OutlineColor = color;
    }

    public String getName() {
        return "Outline Text";
    }

    class OutlineTextPanel
    extends JPanel {
        private JLabel U_jLabel1 = new JLabel();
        private JTextField v_jTextField1 = new FormattedTextField(2);
        private JButton u_jButton1 = new JButton();
        private JLabel V_jLabel2 = new JLabel();

        public OutlineTextPanel() {
            try {
                this.jbInit();
                this.v_jTextField1.setText("" + OutlineText.this.U_m_nOutlineWidth);
                this.V_jLabel2.setBackground(OutlineText.this.V_m_OutlineColor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void jbInit() throws Exception {
            this.U_jLabel1.setText("Outline Width:");
            this.U_jLabel1.setBounds(new Rectangle(14, 10, 70, 24));
            this.setLayout(null);
            this.v_jTextField1.setBounds(new Rectangle(88, 10, 28, 24));
            this.v_jTextField1.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ OutlineTextPanel this$1;
                {
                    this.this$1 = outlineTextPanel;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.jTextField1_focusLost(focusEvent);
                }
            });
            this.u_jButton1.setBounds(new Rectangle(12, 50, 70, 25));
            this.u_jButton1.setFont(new Font("Dialog", 0, 12));
            this.u_jButton1.setText("Color");
            this.u_jButton1.addActionListener(new ActionListener(this){
                final /* synthetic */ OutlineTextPanel this$1;
                {
                    this.this$1 = outlineTextPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.jButton1_actionPerformed(actionEvent);
                }
            });
            this.V_jLabel2.setOpaque(true);
            this.V_jLabel2.setBounds(new Rectangle(93, 50, 23, 25));
            this.add((Component)this.u_jButton1, null);
            this.add((Component)this.V_jLabel2, null);
            this.add((Component)this.v_jTextField1, null);
            this.add((Component)this.U_jLabel1, null);
        }

        void jButton1_actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, "Outline Color", this.U_jLabel1.getBackground());
            if (color != null) {
                OutlineText.this.V_m_OutlineColor = color;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, this.V_jLabel2.getBackground(), color);
                this.V_jLabel2.setBackground(color);
            }
        }

        void jTextField1_focusLost(FocusEvent focusEvent) {
            int n = OutlineText.this.getOutlineWidth();
            OutlineText.this.setOutlineWidth(Integer.parseInt(this.v_jTextField1.getText()));
            this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, n, Integer.parseInt(this.v_jTextField1.getText()));
        }
    }
}

