/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.CircularText;
import imager.FontPanel;
import imager.HelpBrowser;
import imager.Imager;
import imager.ImagerGlobal;
import imager.MultiColoredText;
import imager.OutlineText;
import imager.ShadowedText;
import imager.Text;
import imager.Text3D;
import imager.TextSelectorPanel;
import imager.TextureListPanel;
import imager.TexturePanel;
import imager.components.dialogs.JPhotoDialog;
import imager.utils.CommonComponentHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TextDialog
extends JPhotoDialog
implements PropertyChangeListener {
    protected JPanel panel1 = new JPanel();
    protected FontPanel fontPanel1;
    protected JRadioButton jRadioButton1 = new JRadioButton();
    protected JButton m_ColorButton = new JButton();
    protected JPanel m_ColorPanel = new JPanel();
    protected JRadioButton jRadioButton2 = new JRadioButton();
    protected TexturePanel m_TexturePanel = new TexturePanel();
    protected JButton textureButton = new JButton("...");
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JPanel jPanel2 = new JPanel();
    protected JButton jButton3 = new JButton();
    protected JButton helpButton = new JButton();
    protected JButton m_OkButton = new JButton();
    protected ButtonGroup buttonGroup1 = new ButtonGroup();
    protected Frame m_Frame;
    protected File currDir;
    protected JScrollPane jScrollPane1 = new JScrollPane(20, 31);
    protected JTextArea jTextArea1 = new JTextArea();
    protected JScrollPane jScrollPane2 = new JScrollPane();
    Border border1;
    BorderLayout borderLayout2 = new BorderLayout();
    protected TextSelectorPanel tsp;
    int textLocX;
    int textLocY;
    JComponent textUI;
    JPanel textUIContainer = new JPanel();
    Border border2;
    TitledBorder titledBorder1;
    protected HelpBrowser m_Help;

    public TextDialog() {
    }

    public TextDialog(Frame frame, Vector vector, Font font, Color color) {
        super(frame, "Text Options", true);
        try {
            this.m_Frame = frame;
            this.fontPanel1 = new FontPanel(font);
            this.jbInit();
            this.addPropertyChangeListener(this);
            Vector vector2 = this.U_getPreDefinedTexts(font);
            vector2.addAll(vector);
            int n = 0;
            while (n < vector2.size()) {
                ((AbstractText)vector2.elementAt(n)).addPropertyChangeListener(this);
                ++n;
            }
            vector.removeAllElements();
            this.tsp = new TextSelectorPanel(this, vector2);
            vector2.removeAllElements();
            this.tsp.addPropertyChangeListener(this);
            this.jScrollPane2.getViewport().add(this.tsp);
            this.m_ColorPanel.setBackground(color);
            this.m_ColorButton.setEnabled(true);
            this.textureButton.setEnabled(false);
            this.textureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TextDialog.this.getTexturePanel();
                }
            });
            this.setSize(710, 450);
            this.setLocationRelativeTo(frame);
            this.getRootPane().setDefaultButton(this.m_OkButton);
            this.jTextArea1.requestFocus();
            this.getRootPane().setDefaultButton(this.m_OkButton);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void show(int n, int n2) {
        this.textLocX = n;
        this.textLocY = n2;
        this.show();
    }

    void jbInit() throws Exception {
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 156));
        this.titledBorder1 = new TitledBorder(this.border2, "");
        this.panel1.setLayout(null);
        this.fontPanel1.setBounds(new Rectangle(5, 5, 280, 340));
        this.fontPanel1.addPropertyChangeListener(this);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Color");
        this.jRadioButton1.setBounds(new Rectangle(306, 145, 59, 23));
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextDialog.this.jRadioButton1_actionPerformed(actionEvent);
            }
        });
        this.m_ColorButton.setAlignmentY(0.0f);
        this.m_ColorButton.setText("Color");
        this.m_ColorButton.setBounds(new Rectangle(415, 144, 68, 25));
        this.m_ColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextDialog.this.m_ColorButton_actionPerformed(actionEvent);
            }
        });
        this.m_ColorPanel.setBounds(new Rectangle(368, 145, 41, 25));
        this.jRadioButton2.setText("Texture");
        this.jRadioButton2.setBounds(new Rectangle(306, 176, 72, 22));
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextDialog.this.jRadioButton2_actionPerformed(actionEvent);
            }
        });
        this.m_TexturePanel.addPropertyChangeListener("texture changed", this);
        this.m_TexturePanel.setBounds(new Rectangle(308, 211, 170, 23));
        this.textureButton.setBounds(new Rectangle(416, 173, 39, 29));
        this.getContentPane().setLayout(this.borderLayout1);
        this.panel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setPreferredSize(new Dimension(10, 50));
        this.jButton3.setText("Cancel");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextDialog.this.jButton3_actionPerformed(actionEvent);
            }
        });
        this.m_OkButton.setText("   Ok   ");
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextDialog.this.m_OkButton_actionPerformed(actionEvent);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextDialog.this.helpButton_actionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setBounds(new Rectangle(310, 271, 380, 81));
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextArea1.setLineWrap(true);
        this.jScrollPane2.setBounds(new Rectangle(306, 3, 381, 121));
        this.setResizable(false);
        this.panel1.add((Component)this.fontPanel1, null);
        this.panel1.add((Component)this.jScrollPane1, null);
        this.jScrollPane1.getViewport().add((Component)this.jTextArea1, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.m_OkButton, null);
        this.jPanel2.add((Component)this.jButton3, null);
        this.jPanel2.add((Component)this.helpButton, null);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.buttonGroup1.add(this.jRadioButton2);
        this.buttonGroup1.add(this.jRadioButton1);
        this.textUIContainer.setLayout(new BorderLayout());
        this.textUIContainer.setBounds(new Rectangle(487, 127, 200, 132));
        this.panel1.add((Component)this.jRadioButton1, null);
        this.panel1.add((Component)this.m_ColorButton, null);
        this.panel1.add((Component)this.textureButton, null);
        this.panel1.add((Component)this.jRadioButton2, null);
        this.panel1.add((Component)this.m_TexturePanel, null);
        this.panel1.add((Component)this.m_ColorPanel, null);
        this.panel1.add((Component)this.jScrollPane2, null);
        this.panel1.add(this.textUIContainer);
    }

    void m_ColorButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Text Color", this.m_ColorPanel.getBackground());
        if (color != null) {
            Color color2 = this.m_ColorPanel.getBackground();
            this.m_ColorPanel.setBackground(color);
            this.firePropertyChange("Text Color Changed", color2, color);
        }
    }

    protected void m_OkButton_actionPerformed(ActionEvent actionEvent) {
        if (this.jRadioButton2.isSelected() && this.m_TexturePanel.getTexture() == null) {
            JOptionPane.showConfirmDialog(this, "You must select a texture file or enable text color!", "Text Option Error", -1, 0);
            return;
        }
        if (this.jTextArea1.getText().trim().length() == 0) {
            JOptionPane.showConfirmDialog(this, "You must type in text!!", "Text Option Error", -1, 0);
            this.jTextArea1.requestFocus();
            return;
        }
        this.dispose();
        AbstractText abstractText = (AbstractText)ImagerGlobal.getClone(this.tsp.getSelectedText());
        abstractText.m_X = this.textLocX;
        abstractText.m_Y = this.textLocY;
        abstractText.m_Text = this.jTextArea1.getText();
        abstractText.m_Color = this.m_ColorPanel.getBackground();
        abstractText.m_Font = this.jTextArea1.getFont();
        abstractText.m_Tp = this.jRadioButton1.isSelected() ? null : this.m_TexturePanel.getTexture();
        ((Imager)this.m_Frame).setText(abstractText);
    }

    void jButton3_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void jRadioButton2_actionPerformed(ActionEvent actionEvent) {
        this.m_ColorButton.setEnabled(false);
        this.textureButton.setEnabled(true);
        this.firePropertyChange("texture changed", null, this.m_TexturePanel.getTexture());
    }

    void jRadioButton1_actionPerformed(ActionEvent actionEvent) {
        this.m_ColorButton.setEnabled(true);
        this.textureButton.setEnabled(false);
        this.firePropertyChange("Text Color Changed", null, this.m_ColorPanel.getBackground());
    }

    void textUIChanged(JComponent jComponent) {
        if (this.textUI != null) {
            this.textUIContainer.remove(this.textUI);
        }
        this.textUI = jComponent;
        if (jComponent != null) {
            if (this.textUIContainer.getBorder() == null) {
                this.textUIContainer.setBorder(this.titledBorder1);
            }
            this.titledBorder1.setTitle(this.tsp.getSelectedText().getName());
            this.textUIContainer.add(this.textUI);
            this.textUIContainer.validate();
            this.textUIContainer.repaint();
        } else {
            this.textUIContainer.setBorder(null);
            this.textUIContainer.repaint();
        }
    }

    public void setTextColor(Color color) {
        this.m_ColorPanel.setBackground(color);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (propertyChangeEvent.getPropertyName().equals("Selected Text Changed")) {
                this.textUIChanged(((AbstractText)propertyChangeEvent.getNewValue()).getUIPanel());
            } else if (propertyChangeEvent.getPropertyName().equals(AbstractText.TEXT_PROPERTIES_CHANGED)) {
                this.tsp.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("Font Changed")) {
                this.jTextArea1.setFont(this.fontPanel1.getSelectedFont());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Vector U_getPreDefinedTexts(Font font) {
        ShadowedText shadowedText = new ShadowedText(1, new Font(font.getName(), 1, 20));
        shadowedText.setOffsetX(5);
        shadowedText.setOffsetY(-5);
        ShadowedText shadowedText2 = new ShadowedText(0, new Font(font.getName(), 1, 20));
        Vector<AbstractText> vector = new Vector<AbstractText>();
        vector.addElement(new Text("Normal", 10, 10, new Font(font.getName(), 0, 20), Color.black));
        vector.addElement(new OutlineText("Outlined", 10, 10, new Font(font.getName(), 1, 20), Color.black, null, Color.red, 5));
        vector.addElement(new MultiColoredText("^RMul^Bti-^GCol^Oor^Eed", 10, 10, new Font(font.getName(), 1, 12), Color.black));
        vector.addElement(new CircularText("Circular Text ", 10, 10, new Font(font.getName(), 1, 20), Color.blue, null));
        vector.addElement(new Text3D("3D Text", 10, 10, new Font(font.getName(), 1, 20), Color.red, null));
        vector.addElement(shadowedText);
        vector.addElement(shadowedText2);
        return vector;
    }

    protected void helpButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.m_Help == null) {
                this.m_Help = new HelpBrowser((Dialog)this, "TextDialog", null, "Text_Dialog.htm");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_Help.setVisible(true);
    }

    private void getTexturePanel() {
        TextureListPanel textureListPanel = CommonComponentHandler.getTexturePanel(this, this.m_TexturePanel);
        textureListPanel.addPropertyChangeListener("texture changed", this);
        textureListPanel.show();
        textureListPanel.removePropertyChangeListener(this);
        textureListPanel = null;
    }
}

