/*
 * Decompiled with CFR 0.152.
 */
package imager.components;

import imager.components.JTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class JTableComponent
extends JScrollPane {
    JTableModel m_TableModel;
    JTable m_Table;
    static /* synthetic */ Class class$0;

    public JTableComponent() {
        this((JTableModel)null);
    }

    public JTableComponent(JTableModel jTableModel) {
        this.m_TableModel = jTableModel;
        this.m_Table = new JTable(this.m_TableModel);
        this.setViewportView(this.m_Table);
    }

    public JTableComponent(Object[][] objectArray, String[] stringArray) {
        this.m_TableModel = new JTableModel(objectArray, stringArray);
        this.m_Table = new JTable(this.m_TableModel);
        this.U_setUpColorRenderer();
        this.V_setUpColorEditor();
        this.setViewportView(this.m_Table);
    }

    public JTableComponent(Vector vector, String[] stringArray) {
        this.m_TableModel = new JTableModel(vector, stringArray);
        this.m_Table = new JTable(this.m_TableModel);
        this.U_setUpColorRenderer();
        this.V_setUpColorEditor();
        this.setViewportView(this.m_Table);
    }

    public Object[][] getTableData() {
        return this.m_TableModel.getData();
    }

    public void setColumnEditable(int n, boolean bl) {
        this.m_TableModel.setColumnEditable(n, bl);
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.m_Table.setCellSelectionEnabled(bl);
    }

    public JTableModel getTableModel() {
        return this.m_TableModel;
    }

    public JTable getTable() {
        return this.m_Table;
    }

    private void U_setUpColorRenderer() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.m_Table.setDefaultRenderer(clazz, new ColorRenderer(true));
    }

    public void setRowRenderer(int[] nArray) {
        TableColumnModel tableColumnModel = this.m_Table.getColumnModel();
        int n = 0;
        while (n < nArray.length) {
            tableColumnModel.getColumn(nArray[n]).setCellRenderer(new GenericRowRenderer());
            ++n;
        }
    }

    private void V_setUpColorEditor() {
        final JButton jButton = new JButton(""){

            public void setText(String string) {
            }
        };
        jButton.setBackground(Color.white);
        jButton.setBorderPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        final ColorEditor colorEditor = new ColorEditor(jButton);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.m_Table.setDefaultEditor(clazz, colorEditor);
        final JColorChooser jColorChooser = new JColorChooser();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                colorEditor.m_CurrentColor = jColorChooser.getColor();
            }
        };
        final JDialog jDialog = JColorChooser.createDialog(jButton, "Pick a Color", true, jColorChooser, actionListener, null);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setBackground(colorEditor.m_CurrentColor);
                jColorChooser.setColor(colorEditor.m_CurrentColor);
                jDialog.show();
            }
        });
    }

    public void stopEditing() {
        if (this.m_Table.getCellEditor() != null) {
            this.m_Table.getCellEditor().stopCellEditing();
        }
    }

    class GenericRowRenderer
    extends DefaultTableCellRenderer {
        GenericRowRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n % 2 == 0) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(Color.lightGray);
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border m_UnselectedBorder = null;
        Border m_SelectedBorder = null;
        boolean m_bIsBordered = true;

        public ColorRenderer(boolean bl) {
            this.m_bIsBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((Color)object);
            if (this.m_bIsBordered) {
                if (bl) {
                    if (this.m_SelectedBorder == null) {
                        this.m_SelectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.m_SelectedBorder);
                } else {
                    if (this.m_UnselectedBorder == null) {
                        this.m_UnselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.m_UnselectedBorder);
                }
            }
            return this;
        }
    }

    class ColorEditor
    extends DefaultCellEditor {
        Color m_CurrentColor = null;

        public ColorEditor(JButton jButton) {
            super(new JCheckBox());
            this.editorComponent = jButton;
            this.setClickCountToStart(1);
            jButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ColorEditor this$1;
                {
                    this.this$1 = colorEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.m_CurrentColor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JButton)this.editorComponent).setText(object.toString());
            this.m_CurrentColor = (Color)object;
            return this.editorComponent;
        }
    }
}

